/**
 * Copyright (c) 2025 Wunderkopf Technologies GmbH
 * All rights reserved.
 *
 * Permission is hereby granted, free  of charge, to any person obtaining
 * a  copy  of this  software  and  associated  documentation files  (the
 * "Software"), to  deal in  the Software without  restriction, including
 * without limitation  the rights to  use, copy, modify,  merge, publish,
 * distribute,  sublicense, and/or sell  copies of  the Software,  and to
 * permit persons to whom the Software  is furnished to do so, subject to
 * the following conditions:
 *
 * The  above  copyright  notice  and  this permission  notice  shall  be
 * included in all copies or substantial portions of the Software.
 *
 * THE  SOFTWARE IS  PROVIDED  "AS  IS", WITHOUT  WARRANTY  OF ANY  KIND,
 * EXPRESS OR  IMPLIED, INCLUDING  BUT NOT LIMITED  TO THE  WARRANTIES OF
 * MERCHANTABILITY,    FITNESS    FOR    A   PARTICULAR    PURPOSE    AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE,  ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

package de.wunderkopfservices.creditscore.client.internal;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;

import com.google.gson.annotations.SerializedName;


public class Token {
	
	@SerializedName("token")
	protected String token;
		
	@SerializedName("expires_at")
	protected ZonedDateTime expiresAt;
	
	@SerializedName("token_type")
	protected String tokenType = null;
	
	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}
	
	public ZonedDateTime getExpiresAt() {
		return expiresAt;
	}
	
	public void setExpiresAt(ZonedDateTime expiresAt) {
		this.expiresAt = expiresAt;
	}
	
	
	public boolean isValid() {
		return this.expiresAt != null && expiresAt.isAfter(ZonedDateTime.now(ZoneOffset.UTC));
	}
	
	public boolean isValid(long minutes) {
		return this.expiresAt != null && expiresAt.isAfter(ZonedDateTime.now(ZoneOffset.UTC).plusMinutes(5));
	}

	public String getTokenType() {
		return tokenType;
	}

	public void setTokenType(String tokenType) {
		this.tokenType = tokenType;
	}
	
}
