package de.wiejack.kreator.builder.processor.propertyinitializer

import com.google.devtools.ksp.symbol.ClassKind
import com.google.devtools.ksp.symbol.KSClassDeclaration
import com.google.devtools.ksp.symbol.KSPropertyDeclaration
import com.squareup.kotlinpoet.FileSpec
import com.squareup.kotlinpoet.PropertySpec
import com.squareup.kotlinpoet.ksp.toTypeName
import de.wiejack.kreator.builder.processor.api.BuildContext
import de.wiejack.kreator.builder.processor.api.CommonKspContext
import de.wiejack.kreator.builder.processor.api.PropertyInitializer
import de.wiejack.kreator.builder.processor.api.resolveCached

class EnumPropertyInitializer : PropertyInitializer {

    override fun couldInitialize(
        property: KSPropertyDeclaration,
        buildContext: BuildContext,
    ): Boolean {
        val classDeclaration = (property.type.resolveCached().declaration as KSClassDeclaration)
        return classDeclaration.classKind == ClassKind.ENUM_CLASS
    }

    override fun initializeProperty(
        propertyDeclaration: KSPropertyDeclaration,
        buildContext: BuildContext,
        targetFile: FileSpec.Builder,
        propertyConsumer: (PropertySpec) -> Unit,
    ) {
        val enumType = if (buildContext.initializeNullableProperties) {
            propertyDeclaration.type.toTypeName().copy(nullable = false)
        } else {
            propertyDeclaration.type.toTypeName()
        }

        val propertyType = PropertySpec.Companion.builder(propertyDeclaration.simpleName.asString(), enumType)
            .mutable(true)
            .initializer("$enumType.entries[0]")

        propertyConsumer.invoke(propertyType.build())
    }

    override val order: Int
        get() = 12000
}
