package de.wiejack.kreator.builder.processor.creator

import com.squareup.kotlinpoet.*
import com.squareup.kotlinpoet.ksp.toClassName
import de.wiejack.kreator.builder.processor.api.BuildContext

class BuilderExtensionFunctionCreator {

    companion object {
        const val functionName = "builder"
    }

    fun createExtensionFunction(targetFile: FileSpec.Builder, buildContext: BuildContext) {
        val packageName = buildContext.packageName.name
        val fqnClassName = buildContext.sourceProperty.toClassName().canonicalName
        val builderClassName = buildContext.builderClassName.name

        val extensionFunction = FunSpec.builder(functionName)
            .receiver(ClassName(packageName, listOf("$fqnClassName.Companion")))
            .returns(ClassName(packageName, listOf(fqnClassName)))
            .addParameter(
                ParameterSpec.builder(
                    "block", LambdaTypeName.get(
                        receiver = ClassName(packageName, builderClassName),
                        returnType = ClassName("kotlin", listOf("Unit"))
                    )
                ).build()
            )
            .addStatement("return ${CreateInstanceFunctionCreator.CREATE_INSTANCE_FROM_EXTENSION_FUNCTION_NAME}(block)")

        targetFile.addFunction(extensionFunction.build())
    }
}
