package de.wiejack.kreator.builder.api

@BuilderDslMarker
class CollectionDsl<T>(
    val target: MutableCollection<T>,
) {
    operator fun invoke(config: CollectionDsl<T>.() -> Unit){
        this.apply(config)
    }

    operator fun T.unaryPlus(): Boolean = target.add(this)

    infix fun add(toAdd: T) {
        target.add(toAdd)
    }
}