package de.wiejack.kreator.builder.api

import java.math.BigDecimal
import java.time.LocalDate
import java.time.LocalDateTime
import java.util.*
import kotlin.random.Random

@JvmName("withRandomValuesString")
fun CollectionDsl<in String>.withRandomValues(count: Int = 2) {
    target.addAll((1..count).map { randomString(5) }
    )
}

@JvmName("withRandomValuesInt")
fun CollectionDsl<in Int>.withRandomValues(count: Int = 2) {
    target.addAll((1..count).map { Random.nextInt() }
    )
}

@JvmName("withRandomValuesDouble")
fun CollectionDsl<in Double>.withRandomValues(count: Int = 2) {
    target.addAll((1..count).map { Random.nextDouble() }
    )
}

@JvmName("withRandomValuesLong")
fun CollectionDsl<in Long>.withRandomValues(count: Int = 2) {
    target.addAll((1..count).map { Random.nextLong() }
    )
}

@JvmName("withRandomValuesFloat")
fun CollectionDsl<in Float>.withRandomValues(count: Int = 2) {
    target.addAll((1..count).map { Random.nextFloat() }
    )
}

@JvmName("withRandomValuesLocalDate")
fun CollectionDsl<in LocalDate>.withRandomValues(count: Int = 2) {
    target.addAll((1..count).map { LocalDate.now().minusDays(Random.nextInt(1, 5).toLong()) }
    )
}

@JvmName("withRandomValuesLocalDateTime")
fun CollectionDsl<in LocalDateTime>.withRandomValues(count: Int = 2) {
    target.addAll((1..count).map { LocalDateTime.now().minusDays(Random.nextInt(1, 5).toLong()) }
    )
}

@JvmName("withRandomValuesUUID")
fun CollectionDsl<in UUID>.withRandomValues(count: Int = 2) {
    target.addAll((1..count).map { UUID.randomUUID() }
    )
}

@JvmName("withRandomValuesBigDecimal")
fun CollectionDsl<in BigDecimal>.withRandomValues(count: Int = 2) {
    target.addAll((1..count).map { Random.nextInt().toBigDecimal() }
    )
}