/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.test;

import de.whitefrog.frogr.helper.TimeUtils;
import de.whitefrog.frogr.test.Benchmark;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;

public class BaseBenchmark {
    @Rule
    public TestName test = new TestName();
    private static final Map<String, Task> results = new HashMap<String, Task>();
    private static long benchmarkStart;

    @BeforeClass
    public static void startBenchmark() {
        benchmarkStart = System.nanoTime();
    }

    @AfterClass
    public static void printStatistics() {
        PrintStream stream = System.out;
        stream.println("");
        stream.println("Benchmark took: " + TimeUtils.formatInterval((long)(System.nanoTime() - benchmarkStart), (TimeUnit)TimeUnit.NANOSECONDS));
        stream.println("");
        stream.println("\tDescription: (actual) => (expectation)");
        stream.println("\t======================================");
        for (Task task : results.values()) {
            BaseBenchmark.printStatistics(task);
        }
    }

    private static void printStatistics(Task task) {
        String notPassed = " (- NOT PASSED -)";
        String name = task.text;
        if (name.isEmpty()) {
            for (String method : results.keySet()) {
                if (!results.get(method).equals(task)) continue;
                name = method;
                break;
            }
        }
        Object[] objectArray = new Object[5];
        objectArray[0] = name;
        objectArray[1] = TimeUtils.formatInterval((long)task.result, (TimeUnit)TimeUnit.NANOSECONDS);
        Object object = objectArray[2] = task.expectation > 0L ? " => " + TimeUtils.formatInterval((long)task.expectation, (TimeUnit)TimeUnit.NANOSECONDS) : "";
        objectArray[3] = task.expectation > 0L ? (task.result <= task.expectation ? " (passed)" : notPassed) : "";
        objectArray[4] = TimeUtils.perSecond((double)task.result);
        System.out.println(String.format("\t%s in: %s%s%s\tThroughput: %s", objectArray));
    }

    @Before
    public void before() throws Exception {
        Method method = this.getClass().getMethod(this.test.getMethodName(), new Class[0]);
        if (method.isAnnotationPresent(Benchmark.class)) {
            Benchmark benchmark = this.getClass().getMethod(this.test.getMethodName(), new Class[0]).getAnnotation(Benchmark.class);
            Task task = new Task(benchmark);
            results.put(this.test.getMethodName(), task);
        }
    }

    @After
    public void after() {
        if (results.containsKey(this.test.getMethodName())) {
            Task task = results.get(this.test.getMethodName());
            task.result = (System.nanoTime() - task.start) / (long)task.count;
            BaseBenchmark.printStatistics(task);
            if (task.expectation > 0L) {
                TestCase.assertTrue((String)("expected " + task.result + " to be less than " + task.expectation), (task.result < task.expectation ? 1 : 0) != 0);
            }
        }
    }

    public static class Task {
        public String text;
        public long expectation;
        public int count;
        public long start;
        public long result;

        public Task(Benchmark benchmark) {
            this.text = benchmark.text();
            this.count = benchmark.count();
            this.expectation = benchmark.timeUnit().toNanos(benchmark.expectation());
            this.start = System.nanoTime();
        }
    }
}

