/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.rest.response;

import de.whitefrog.frogr.exception.DuplicateEntryException;
import de.whitefrog.frogr.exception.FrogrException;
import de.whitefrog.frogr.exception.MissingRequiredException;
import de.whitefrog.frogr.exception.PersistException;
import de.whitefrog.frogr.rest.response.FrogrResponse;
import java.security.InvalidParameterException;
import java.util.LinkedHashMap;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \f2\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0002j\u0002`\u0003H\u0016\u00a8\u0006\r"}, d2={"Lde/whitefrog/frogr/rest/response/ExceptionMapper;", "Ljavax/ws/rs/ext/ExceptionMapper;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "()V", "getErrorCode", "", "e", "Lde/whitefrog/frogr/exception/FrogrException;", "toResponse", "Ljavax/ws/rs/core/Response;", "exception", "Companion", "frogr-base"})
public final class ExceptionMapper
implements javax.ws.rs.ext.ExceptionMapper<Exception> {
    private static final Logger logger;
    private static final LinkedHashMap<Class<? extends FrogrException>, Integer> codes;
    public static final Companion Companion;

    @NotNull
    public Response toResponse(@NotNull Exception exception) {
        int code;
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        FrogrResponse response = new FrogrResponse();
        response.setSuccess(false);
        response.setMessage(exception.getMessage());
        if (exception instanceof WebApplicationException) {
            if (!(exception instanceof ForbiddenException) && !(exception instanceof NotAuthorizedException)) {
                Response response2 = ((WebApplicationException)exception).getResponse();
                Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"exception.response");
                if (response2.getStatus() != Response.Status.FORBIDDEN.getStatusCode()) {
                    logger.error(exception.getMessage(), (Throwable)exception);
                }
            }
            Response response3 = ((WebApplicationException)exception).getResponse();
            Intrinsics.checkExpressionValueIsNotNull((Object)response3, (String)"exception.response");
            response.setErrorCode(response3.getStatus());
            Response.ResponseBuilder responseBuilder = Response.fromResponse((Response)((WebApplicationException)exception).getResponse());
            Response response4 = ((WebApplicationException)exception).getResponse();
            Intrinsics.checkExpressionValueIsNotNull((Object)response4, (String)"exception.response");
            Response response5 = responseBuilder.status(response4.getStatus()).entity(response).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response5, (String)"javax.ws.rs.core.Respons\u2026.entity(response).build()");
            return response5;
        }
        if (exception instanceof MissingRequiredException || exception instanceof InvalidParameterException || exception instanceof ConstraintViolationException || exception instanceof DuplicateEntryException) {
            logger.error(exception.getMessage());
        } else {
            logger.error(exception.getMessage(), (Throwable)exception);
        }
        if (exception instanceof FrogrException && (code = this.getErrorCode((FrogrException)((Object)exception))) > -1) {
            response.setErrorCode(code);
        }
        Response response6 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(response).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response6, (String)"javax.ws.rs.core.Respons\u2026.entity(response).build()");
        return response6;
    }

    private final int getErrorCode(FrogrException e) {
        for (Class<? extends FrogrException> clazz : codes.keySet()) {
            if (!clazz.isAssignableFrom(((Object)((Object)e)).getClass())) continue;
            Integer n = codes.get(clazz);
            if (n == null) {
                Intrinsics.throwNpe();
            }
            return ((Number)n).intValue();
        }
        return -1;
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(ExceptionMapper.class);
        codes = MapsKt.linkedMapOf((Pair[])new Pair[]{new Pair(DuplicateEntryException.class, (Object)602), new Pair(PersistException.class, (Object)601), new Pair(FrogrException.class, (Object)600)});
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R:\u0010\u0003\u001a.\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00070\u0004j\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/whitefrog/frogr/rest/response/ExceptionMapper$Companion;", "", "()V", "codes", "Ljava/util/LinkedHashMap;", "Ljava/lang/Class;", "Lde/whitefrog/frogr/exception/FrogrException;", "", "Lkotlin/collections/LinkedHashMap;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "frogr-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

