/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.repository;

import de.whitefrog.frogr.Service;
import de.whitefrog.frogr.model.Graph;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006J\b\u0010\b\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/whitefrog/frogr/repository/GraphRepository;", "", "service", "Lde/whitefrog/frogr/Service;", "(Lde/whitefrog/frogr/Service;)V", "graph", "Lde/whitefrog/frogr/model/Graph;", "create", "getGraph", "save", "", "frogr-base"})
public final class GraphRepository {
    private Graph graph;
    private final Service service;

    @Nullable
    public final Graph create() {
        return this.getGraph() != null ? this.graph : new Graph();
    }

    @Nullable
    public final Graph getGraph() {
        if (this.graph != null) {
            return this.graph;
        }
        Result results = this.service.graph().execute("match (n:Graph) return n");
        if (results.hasNext()) {
            Object v = results.next().get("n");
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.neo4j.graphdb.Node");
            }
            Node node = (Node)v;
            this.graph = new Graph();
            if (node.hasProperty("version")) {
                Graph graph = this.graph;
                if (graph == null) {
                    Intrinsics.throwNpe();
                }
                Object object = node.getProperty("version");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                graph.setVersion((String)object);
            }
        }
        return this.graph;
    }

    public final void save(@NotNull Graph graph) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)graph), (String)"graph");
        if (this.graph != null) {
            Result results = this.service.graph().execute("match (n:Graph) return n");
            Object v = results.next().get("n");
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.neo4j.graphdb.Node");
            }
            Node node = (Node)v;
            if (graph.getVersion() != null) {
                node.setProperty("version", (Object)graph.getVersion());
            }
        } else {
            Node node = this.service.graph().createNode(new Label[]{Label.label((String)"Graph")});
            if (graph.getVersion() != null) {
                node.setProperty("version", (Object)graph.getVersion());
            }
            this.graph = graph;
        }
    }

    public GraphRepository(@NotNull Service service) {
        Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
        this.service = service;
    }
}

