/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.rest.service;

import com.codahale.metrics.MetricRegistry;
import de.whitefrog.frogr.Service;
import de.whitefrog.frogr.helper.ReflectionUtil;
import de.whitefrog.frogr.model.Base;
import de.whitefrog.frogr.repository.Repository;
import java.lang.reflect.Type;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultRestService<M extends Base> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRestService.class);
    private Repository<M> repository = null;
    private Class repositoryClass;
    private Class modelClass;
    public static final MetricRegistry metrics = new MetricRegistry();
    @Inject
    private Service service;

    public Service service() {
        return this.service;
    }

    public Repository<M> repository() {
        if (this.repository == null) {
            try {
                this.repository = this.service().repository(this.getModelClass());
            }
            catch (ClassNotFoundException e) {
                logger.error("class for service {}", (Object)this.getClass().getName());
            }
        }
        return this.repository;
    }

    private Class getModelClass() throws ClassNotFoundException {
        if (this.modelClass == null) {
            Type[] parameterizedTypes = ReflectionUtil.getParameterizedTypes(this);
            this.modelClass = ReflectionUtil.getClass(parameterizedTypes[0]);
        }
        return this.modelClass;
    }
}

