/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.repository;

import de.whitefrog.frogr.Service;
import de.whitefrog.frogr.exception.RepositoryInstantiationException;
import de.whitefrog.frogr.exception.RepositoryNotFoundException;
import de.whitefrog.frogr.model.relationship.Relationship;
import de.whitefrog.frogr.repository.BaseRepository;
import de.whitefrog.frogr.repository.DefaultModelRepository;
import de.whitefrog.frogr.repository.DefaultRelationshipRepository;
import de.whitefrog.frogr.repository.Repository;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryFactory {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryFactory.class);
    private final Map<String, Class> repositoryCache = new HashMap<String, Class>();
    private final Service service;
    private final Map<String, Repository> cache = new HashMap<String, Repository>(100);

    public RepositoryFactory(Service service) {
        this.service = service;
        if (this.repositoryCache.isEmpty()) {
            ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().setScanners(new Scanner[]{new SubTypesScanner()});
            service.registry().forEach(pkg -> configurationBuilder.addUrls(ClasspathHelper.forPackage((String)pkg, (ClassLoader[])new ClassLoader[0])));
            Reflections reflections = new Reflections((Configuration)configurationBuilder);
            for (Class clazz : reflections.getSubTypesOf(Repository.class)) {
                if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) continue;
                this.repositoryCache.put(clazz.getSimpleName(), clazz);
            }
        }
    }

    public Collection<Class> repositoryClasses() {
        return this.repositoryCache.values();
    }

    public Collection<Repository> cache() {
        return this.cache.values();
    }

    public Repository get(Class modelClass) {
        return this.get(this.service.cache().getModelName(modelClass));
    }

    public Repository get(String name) {
        Repository repository;
        try {
            if (this.cache.containsKey(name)) {
                repository = this.cache.get(name);
            } else if (!this.repositoryCache.containsKey(name + "Repository")) {
                logger.debug("No repository found for {}, creating a default one", (Object)name);
                Class<?> modelClass = this.service.cache().getModel(name);
                if (modelClass == null) {
                    throw new RepositoryNotFoundException(name);
                }
                if (!Relationship.class.isAssignableFrom(modelClass)) {
                    Constructor ctor = DefaultModelRepository.class.getConstructor(String.class);
                    repository = (Repository)ctor.newInstance(name);
                } else {
                    Constructor ctor = DefaultRelationshipRepository.class.getConstructor(String.class);
                    repository = (Repository)ctor.newInstance(name);
                }
                this.setRepositoryService(repository);
                this.cache.put(name, repository);
            } else {
                Class c = this.repositoryCache.get(name + "Repository");
                Constructor ctor = c.getDeclaredConstructor(new Class[0]);
                if (ctor == null) {
                    throw new RepositoryInstantiationException("No constructor " + name + "Repository() found in " + c.getName());
                }
                repository = (Repository)ctor.newInstance(new Object[0]);
                this.setRepositoryService(repository);
                logger.debug("registering " + repository.getClass().getSimpleName() + " for " + name);
            }
            this.cache.put(name, repository);
        }
        catch (ReflectiveOperationException e) {
            throw new RepositoryInstantiationException(e);
        }
        return repository;
    }

    public void setRepositoryService(Repository repository) throws ReflectiveOperationException {
        Field serviceField = BaseRepository.class.getDeclaredField("service");
        serviceField.setAccessible(true);
        serviceField.set(repository, this.service);
        BaseRepository.class.getDeclaredMethod("initialize", new Class[0]).invoke((Object)repository, new Object[0]);
    }

    public void register(String name, Repository repository) {
        this.cache.put(name, repository);
    }
}

