/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.model;

import de.whitefrog.frogr.exception.FrogrException;
import de.whitefrog.frogr.exception.PersistException;
import de.whitefrog.frogr.model.Base;
import de.whitefrog.frogr.model.FBase;
import de.whitefrog.frogr.model.FieldList;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.persistence.AnnotationDescriptor;
import de.whitefrog.frogr.persistence.FieldDescriptor;
import de.whitefrog.frogr.persistence.ModelCache;
import de.whitefrog.frogr.repository.Repository;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tJ\u000b\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\r\u001a\u0002H\u0017\"\b\b\u0001\u0010\u0017*\u00020\u000eH\u0007\u00a2\u0006\u0002\u0010\u0018J\r\u0010\u000f\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0016J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eR\u001a\u0010\b\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/whitefrog/frogr/model/SaveContext;", "T", "Lde/whitefrog/frogr/model/Base;", "", "repository", "Lde/whitefrog/frogr/repository/Repository;", "model", "(Lde/whitefrog/frogr/repository/Repository;Lde/whitefrog/frogr/model/Base;)V", "changedFields", "", "Lde/whitefrog/frogr/persistence/FieldDescriptor;", "fieldMap", "Lde/whitefrog/frogr/model/Base;", "node", "Lorg/neo4j/graphdb/PropertyContainer;", "original", "fieldChanged", "", "field", "Ljava/lang/reflect/Field;", "fieldName", "", "()Lde/whitefrog/frogr/model/Base;", "N", "()Lorg/neo4j/graphdb/PropertyContainer;", "setNode", "", "frogr-base"})
public final class SaveContext<T extends Base> {
    private T original;
    private PropertyContainer node;
    private List<? extends FieldDescriptor<?>> changedFields;
    private final List<FieldDescriptor<?>> fieldMap;
    private final Repository<T> repository;
    private final T model;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FieldDescriptor<?>> changedFields() {
        if (this.changedFields == null) {
            void var3_4;
            List list;
            void $receiver$iv$iv;
            void $receiver$iv;
            if (this.original() != null) {
                this.repository.fetch((Base)this.original(), "all");
            }
            Iterable iterable = this.fieldMap;
            SaveContext saveContext = this;
            void var2_3 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                FieldDescriptor f = (FieldDescriptor)element$iv$iv;
                if (!this.fieldChanged(f.field())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            saveContext.changedFields = list = (List)var3_4;
        }
        List<FieldDescriptor<?>> list = this.changedFields;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list;
    }

    public final boolean fieldChanged(@NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        return this.changedFields().stream().anyMatch(new Predicate<FieldDescriptor<?>>(fieldName){
            final /* synthetic */ String $fieldName;

            public final boolean test(FieldDescriptor<?> f) {
                return Intrinsics.areEqual((Object)f.getName(), (Object)this.$fieldName);
            }
            {
                this.$fieldName = string;
            }
        });
    }

    private final boolean fieldChanged(Field field) {
        ModelCache modelCache = this.repository.cache();
        Class<?> clazz = this.repository().getModelClass();
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"repository().modelClass");
        String string = field.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"field.name");
        AnnotationDescriptor annotation = modelCache.fieldAnnotations(clazz, string);
        try {
            Object value;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if ((value = field.get(this.model)) != null) {
                AnnotationDescriptor annotationDescriptor = annotation;
                if (annotationDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                if (!annotationDescriptor.nullRemove) {
                    if (this.original() == null) {
                        return true;
                    }
                    if (annotation.relatedTo != null && annotation.lazy) {
                        return true;
                    }
                    if (annotation.relatedTo != null) {
                        this.repository().fetch((Base)this.original(), FieldList.Companion.parseFields(field.getName() + "(max)"));
                    }
                    Object originalValue = field.get(this.original());
                    return Intrinsics.areEqual((Object)value, (Object)originalValue) ^ true;
                }
            }
            AnnotationDescriptor annotationDescriptor = annotation;
            if (annotationDescriptor == null) {
                Intrinsics.throwNpe();
            }
            if (annotationDescriptor.nullRemove) {
                return true;
            }
        }
        catch (IllegalAccessException e) {
            throw (Throwable)new FrogrException(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @NotNull
    public final List<FieldDescriptor<?>> fieldMap() {
        return this.fieldMap;
    }

    @NotNull
    public final T model() {
        return this.model;
    }

    @NotNull
    public final Repository<T> repository() {
        return this.repository;
    }

    @NotNull
    public final <N extends PropertyContainer> N node() {
        if (this.node == null) {
            PropertyContainer propertyContainer;
            if (this.original() != null) {
                Entity entity;
                if (this.model instanceof Model) {
                    GraphDatabaseService graphDatabaseService = this.repository.graph();
                    T t = this.original();
                    if (t == null) {
                        Intrinsics.throwNpe();
                    }
                    entity = (Entity)graphDatabaseService.getNodeById(t.getId());
                } else {
                    GraphDatabaseService graphDatabaseService = this.repository.graph();
                    T t = this.original();
                    if (t == null) {
                        Intrinsics.throwNpe();
                    }
                    entity = (Entity)graphDatabaseService.getRelationshipById(t.getId());
                }
                propertyContainer = (PropertyContainer)entity;
            } else {
                if (this.model().getId() > (long)-1) {
                } else {
                    throw (Throwable)((Object)new PersistException("could not resolve model " + this.model));
                }
                propertyContainer = (PropertyContainer)(this.model instanceof Model ? (Entity)this.repository.graph().getNodeById(this.model().getId()) : (Entity)this.repository.graph().getRelationshipById(this.model().getId()));
            }
            this.node = propertyContainer;
        }
        PropertyContainer propertyContainer = this.node;
        if (propertyContainer == null) {
            throw new TypeCastException("null cannot be cast to non-null type N");
        }
        return (N)propertyContainer;
    }

    @Nullable
    public final T original() {
        return this.original;
    }

    public final void setNode(@NotNull PropertyContainer node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        this.node = node;
    }

    public SaveContext(@NotNull Repository<T> repository, @NotNull T model) {
        Intrinsics.checkParameterIsNotNull(repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        this.repository = repository;
        this.model = model;
        if (this.model.getId() > (long)-1) {
            this.original = this.repository.createModel((PropertyContainer)this.node());
        } else if (this.model instanceof FBase && ((FBase)this.model).getUuid() != null) {
            T t = this.original = this.repository.findByUuid(((FBase)this.model).getUuid(), new String[0]);
            if (t == null) {
                Intrinsics.throwNpe();
            }
            this.model.setId(t.getId());
        }
        this.fieldMap = this.repository.cache().fieldMap(this.model.getClass());
    }
}

