/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.service;

import de.whitefrog.frogr.Service;
import de.whitefrog.frogr.cypher.Query;
import de.whitefrog.frogr.exception.FrogrException;
import de.whitefrog.frogr.helper.TimeUtils;
import de.whitefrog.frogr.model.Base;
import de.whitefrog.frogr.model.FieldList;
import de.whitefrog.frogr.model.Filter;
import de.whitefrog.frogr.model.QueryField;
import de.whitefrog.frogr.model.SearchParameter;
import de.whitefrog.frogr.persistence.FieldDescriptor;
import de.whitefrog.frogr.repository.Repository;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Search {
    private static final Logger logger = LoggerFactory.getLogger(Search.class);
    private final Service service;
    private final Repository<? extends Base> repository;
    private SearchParameter params;
    private boolean debugQuery = false;

    public Search(Repository<? extends Base> repository) {
        this.repository = repository;
        this.service = repository.service();
        this.params = new SearchParameter();
    }

    public long count() {
        String id = CollectionUtils.isEmpty((Collection)this.params.returns()) ? "*" : (String)this.params.returns().get(0);
        return this.count(id);
    }

    public long count(String id) {
        Query query = this.repository.queryBuilder().buildSimple(this.params);
        query.query(query.query() + " return count(" + id + ") as c");
        Result result = this.execute(query);
        long count = (Long)result.columnAs("c").next();
        result.close();
        return count;
    }

    public Number sum(String field) {
        Query query = this.repository.queryBuilder().buildSimple(this.params);
        query.query(query.query() + " return sum(" + field + ") as c");
        Result result = this.execute(query);
        long sum = (Long)result.columnAs("c").next();
        result.close();
        return sum;
    }

    public <T extends Base> List<T> list() {
        Stream<? extends Base> stream = this.search(this.params);
        List list = stream.collect(Collectors.toList());
        stream.close();
        return list;
    }

    public <T extends Base> Set<T> set() {
        Stream<? extends Base> stream = this.search(this.params);
        Set set = stream.collect(Collectors.toSet());
        stream.close();
        return set;
    }

    public <T extends Base> T single() {
        Stream<? extends Base> result = this.search(this.params.limit(1));
        Optional<? extends Base> optional = result.findFirst();
        result.close();
        return (T)((Base)optional.orElse(null));
    }

    public Long toLong() {
        Query query = this.repository.queryBuilder().buildSimple(this.params);
        if (this.params.returns().size() > 1) {
            throw new UnsupportedOperationException("more than one return parameter is not supported");
        }
        query.query(query.query() + " return " + (String)this.params.returns().get(0) + " as c");
        Result result = this.execute(query);
        Object o = result.hasNext() ? result.columnAs("c").next() : null;
        result.close();
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).longValue();
        }
        throw new UnsupportedOperationException(o.getClass().getSimpleName() + " cannot be cast to Long");
    }

    public Integer toInt() {
        Query query = this.repository.queryBuilder().buildSimple(this.params);
        if (this.params.returns().size() > 1) {
            throw new UnsupportedOperationException("more than one return parameter is not supported");
        }
        query.query(query.query() + " return " + (String)this.params.returns().get(0) + " as c");
        Result result = this.execute(query);
        Object o = result.hasNext() ? result.columnAs("c").next() : null;
        result.close();
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return ((Long)o).intValue();
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        throw new UnsupportedOperationException(o.getClass().getSimpleName() + " cannot be cast to Integer");
    }

    private Stream<? extends Base> search(SearchParameter params) {
        Stream stream;
        Query query = this.repository.queryBuilder().build(params);
        Result result = this.execute(query);
        if (CollectionUtils.isEmpty((Collection)params.returns()) || params.returns().size() == 1 && params.returns().contains(this.repository.queryIdentifier())) {
            stream = result.stream().map(new ResultMapper<Base>(this.repository, params));
        } else if (params.returns().size() == 1 && !params.returns().contains(this.repository.queryIdentifier())) {
            FieldDescriptor<?> descriptor = this.service.cache().fieldDescriptor(this.repository.getModelClass(), (String)params.returns().get(0));
            Object otherRepository = this.service.repository(descriptor.baseClassName());
            stream = result.stream().map(new ResultMapper(otherRepository, params));
        } else {
            stream = result.stream().map(new ResultMapper<Base>(this.repository, params));
        }
        return (Stream)stream.onClose(() -> ((Result)result).close());
    }

    private Result execute(Query query) {
        Result result;
        long start = 0L;
        if (logger.isDebugEnabled() || this.debugQuery) {
            start = System.nanoTime();
        }
        try {
            result = this.repository.service().graph().execute(query.query(), query.params());
        }
        catch (IllegalStateException e) {
            try {
                logger.error("On query: " + query.query(), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                if (logger.isDebugEnabled()) {
                    logger.debug("\n{}\nQuery: {}\nQueryParams: {}\nTime: {}", new Object[]{this.params, query.query(), query.params(), TimeUtils.formatInterval(System.nanoTime() - start, TimeUnit.NANOSECONDS)});
                } else if (this.debugQuery) {
                    System.out.println(MessageFormat.format("{0}\nQuery: {1}\nQueryParams: {2}\nTime: {3}", this.params, query.query(), query.params(), TimeUtils.formatInterval(System.nanoTime() - start, TimeUnit.NANOSECONDS)));
                }
                throw throwable;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\n{}\nQuery: {}\nQueryParams: {}\nTime: {}", new Object[]{this.params, query.query(), query.params(), TimeUtils.formatInterval(System.nanoTime() - start, TimeUnit.NANOSECONDS)});
        } else if (this.debugQuery) {
            System.out.println(MessageFormat.format("{0}\nQuery: {1}\nQueryParams: {2}\nTime: {3}", this.params, query.query(), query.params(), TimeUtils.formatInterval(System.nanoTime() - start, TimeUnit.NANOSECONDS)));
        }
        return result;
    }

    public Search debug() {
        this.debugQuery = true;
        return this;
    }

    public Search fields(String ... fields) {
        this.params.fields(FieldList.parseFields((String[])fields));
        return this;
    }

    public Search fields(QueryField ... fields) {
        this.params.fields(fields);
        return this;
    }

    public Search fields(FieldList fields) {
        this.params.fields(fields);
        return this;
    }

    public Search filter(String property, String value) {
        this.params.filter(property, value);
        return this;
    }

    public Search filter(Filter filter) {
        this.params.filter(filter);
        return this;
    }

    public Search params(SearchParameter params) {
        this.params = params;
        return this;
    }

    public Search locale(Locale locale) {
        this.params.locale(locale);
        return this;
    }

    public Search query(String query) {
        this.params.query(query);
        return this;
    }

    public Search start(int start) {
        this.params.start(start);
        return this;
    }

    public Search ids(Long ... ids) {
        this.params.ids(ids);
        return this;
    }

    public Search ids(Collection<Long> ids) {
        this.params.ids(ids);
        return this;
    }

    public Search uuids(String ... uuids) {
        this.params.uuids(uuids);
        return this;
    }

    public Search uuids(Collection<String> uuids) {
        this.params.uuids(uuids);
        return this;
    }

    public Search limit(int limit) {
        this.params.limit(limit);
        return this;
    }

    public Search page(int page) {
        this.params.page(page);
        return this;
    }

    public Search orderBy(String field) {
        this.params.orderBy(field);
        return this;
    }

    public Search orderBy(String field, SearchParameter.SortOrder dir) {
        this.params.orderBy(field, dir);
        return this;
    }

    public Search returns(String ... fields) {
        this.params.returns(fields);
        return this;
    }

    static class ResultMapper<T extends Base>
    implements Function<Map<String, Object>, T> {
        private final SearchParameter params;
        private final Repository<T> repository;

        ResultMapper(Repository<T> repository, SearchParameter params) {
            this.repository = repository;
            this.params = params;
        }

        @Override
        public T apply(Map<String, Object> result) {
            String identifier;
            String string = identifier = CollectionUtils.isEmpty((Collection)this.params.returns()) ? this.repository.queryIdentifier() : (String)this.params.returns().get(0);
            if (identifier.contains(".")) {
                identifier = identifier.replace(".", "_");
            }
            PropertyContainer node = (PropertyContainer)result.get(identifier);
            T model = this.repository.createModel(node, this.params.fieldList());
            if (result.size() > 1) {
                for (Map.Entry<String, Object> resultEntry : result.entrySet()) {
                    Object related;
                    if (resultEntry.getKey().equals(identifier)) continue;
                    Object value = result.get(resultEntry.getKey());
                    FieldList fieldList = this.params.fieldList().getOrEmpty(resultEntry.getKey()).subFields();
                    if (value instanceof Collection) {
                        related = new ArrayList(((Collection)value).size());
                        for (PropertyContainer container : (Collection)value) {
                            related.add(this.repository.persistence().get(container, fieldList));
                        }
                        value = related;
                    } else {
                        related = (PropertyContainer)result.get(resultEntry.getKey());
                        value = this.repository.service().persistence().get((PropertyContainer)related, fieldList);
                    }
                    FieldDescriptor<?> field = this.repository.cache().fieldDescriptor(model.getClass(), resultEntry.getKey());
                    try {
                        field.field().set(model, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new FrogrException((Throwable)e);
                    }
                }
            }
            return model;
        }
    }
}

