/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.repository;

import de.whitefrog.frogr.exception.FrogrException;
import de.whitefrog.frogr.exception.PersistException;
import de.whitefrog.frogr.model.Base;
import de.whitefrog.frogr.model.FieldList;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.model.SaveContext;
import de.whitefrog.frogr.repository.BaseRepository;
import de.whitefrog.frogr.repository.RelationshipRepository;
import java.lang.reflect.Constructor;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.reflect.ConstructorUtils;
import org.apache.commons.lang3.Validate;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRelationshipRepository<T extends de.whitefrog.frogr.model.relationship.Relationship>
extends BaseRepository<T>
implements RelationshipRepository<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Constructor constructor;

    public BaseRelationshipRepository() {
    }

    BaseRelationshipRepository(String modelName) {
        super(modelName);
    }

    @Override
    public T createModel(Model from, Model to) {
        try {
            if (this.constructor == null) {
                this.constructor = ConstructorUtils.getMatchingAccessibleConstructor(this.getModelClass(), (Class[])new Class[]{from.getClass(), to.getClass()});
            }
            return (T)((de.whitefrog.frogr.model.relationship.Relationship)this.constructor.newInstance(from, to));
        }
        catch (ReflectiveOperationException e) {
            throw new FrogrException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public T createModel(PropertyContainer node, FieldList fields) {
        return (T)(this.getModelClass().isInterface() ? (de.whitefrog.frogr.model.relationship.Relationship)this.service().persistence().get(node, fields) : (de.whitefrog.frogr.model.relationship.Relationship)this.service().persistence().get(node, fields, this.getModelClass()));
    }

    public T find(long id, FieldList fields) {
        try {
            T model = this.createModel((PropertyContainer)this.graph().getRelationshipById(id), fields);
            if (CollectionUtils.isNotEmpty((Collection)fields)) {
                this.fetch((Base)model, fields);
            }
            return model;
        }
        catch (IllegalStateException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    @Override
    public Relationship getRelationship(de.whitefrog.frogr.model.relationship.Relationship model) {
        Validate.notNull((Object)model, (String)"The model is null", (Object[])new Object[0]);
        try {
            return this.service().graph().getRelationshipById(model.getId());
        }
        catch (NotFoundException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void remove(T model) throws PersistException {
        this.relationships().delete(model);
        this.logger.info("{} deleted", model);
    }

    @Override
    public void save(SaveContext<T> context) throws PersistException {
        if (this.getModelClass().isInterface()) {
            throw new PersistException("cannot save in interface repository");
        }
        this.validateModel(context);
        boolean create = !((de.whitefrog.frogr.model.relationship.Relationship)context.model()).isPersisted();
        this.service().persistence().relationships().save(context);
        this.logger().info("{} {}", context.model(), (Object)(create ? "created" : "updated"));
    }
}

