/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.repository;

import de.whitefrog.frogr.exception.FrogrException;
import de.whitefrog.frogr.exception.PersistException;
import de.whitefrog.frogr.exception.TypeMismatchException;
import de.whitefrog.frogr.model.Base;
import de.whitefrog.frogr.model.FieldList;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.model.SaveContext;
import de.whitefrog.frogr.model.relationship.FRelationship;
import de.whitefrog.frogr.repository.BaseRepository;
import de.whitefrog.frogr.repository.ModelRepository;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;

public abstract class BaseModelRepository<T extends Model>
extends BaseRepository<T>
implements ModelRepository<T> {
    private final Label label;
    private Set<Label> labels;

    public BaseModelRepository() {
        this.label = Label.label((String)this.getType());
    }

    public BaseModelRepository(String modelName) {
        super(modelName);
        this.label = Label.label((String)modelName);
    }

    @Override
    public T createModel() {
        try {
            return (T)((Model)this.getModelClass().newInstance());
        }
        catch (ReflectiveOperationException e) {
            throw new FrogrException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public T createModel(PropertyContainer node, FieldList fields) {
        if (node instanceof Node && !this.checkType((Node)node)) {
            throw new TypeMismatchException((Node)node, this.label());
        }
        return (T)(this.getModelClass().isInterface() ? (Model)this.service().persistence().get(node, fields) : (Model)this.service().persistence().get(node, fields, this.getModelClass()));
    }

    private boolean checkType(Node node) {
        return node.hasLabel(this.label());
    }

    private Set<String> getModelInterfaces(Class<?> clazz) {
        Class<?>[] interfaces;
        HashSet<String> output = new HashSet<String>();
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            if (!Model.class.isAssignableFrom(i) || i.equals(Model.class)) continue;
            output.add(i.getSimpleName());
            output.addAll(this.getModelInterfaces(i));
        }
        for (Class<?> parent = clazz.getSuperclass(); !(parent == null || Modifier.isAbstract(parent.getModifiers()) || Model.class.isAssignableFrom(parent) || FRelationship.class.isAssignableFrom(parent)); parent = parent.getSuperclass()) {
            output.add(parent.getSimpleName());
        }
        return output;
    }

    public T find(long id, FieldList fields) {
        try {
            T model = this.createModel((PropertyContainer)this.graph().getNodeById(id), fields);
            if (CollectionUtils.isNotEmpty((Collection)fields)) {
                this.fetch((Base)model, fields);
            }
            return model;
        }
        catch (IllegalStateException e) {
            this.logger().warn(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    @Override
    public Node getNode(Model model) {
        Validate.notNull((Object)model, (String)"The model is null", (Object[])new Object[0]);
        try {
            return this.service().graph().getNodeById(model.getId());
        }
        catch (NotFoundException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public Label label() {
        return this.label;
    }

    @Override
    public Set<Label> labels() {
        if (this.labels == null) {
            this.labels = this.getModelInterfaces(this.getModelClass()).stream().map(Label::label).collect(Collectors.toSet());
        }
        return this.labels;
    }

    @Override
    public void remove(T model) throws PersistException {
        this.service().persistence().delete(model);
        this.logger().info("{} deleted", model);
    }

    @Override
    public void save(SaveContext<T> context) throws PersistException {
        if (this.getModelClass().isInterface()) {
            throw new PersistException("cannot save in interface repository");
        }
        this.validateModel(context);
        boolean create = !((Model)context.model()).isPersisted();
        this.service().persistence().save(this, context);
        this.logger().info("{} {}", context.model(), (Object)(create ? "created" : "updated"));
    }
}

