/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.persistence;

import de.whitefrog.frogr.Service;
import de.whitefrog.frogr.exception.FrogrException;
import de.whitefrog.frogr.exception.PersistException;
import de.whitefrog.frogr.exception.RelatedNotPersistedException;
import de.whitefrog.frogr.exception.RepositoryInstantiationException;
import de.whitefrog.frogr.exception.RepositoryNotFoundException;
import de.whitefrog.frogr.model.Base;
import de.whitefrog.frogr.model.FBase;
import de.whitefrog.frogr.model.FieldList;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.model.QueryField;
import de.whitefrog.frogr.model.SaveContext;
import de.whitefrog.frogr.model.annotation.RelatedTo;
import de.whitefrog.frogr.persistence.AnnotationDescriptor;
import de.whitefrog.frogr.persistence.FieldDescriptor;
import de.whitefrog.frogr.persistence.Persistence;
import de.whitefrog.frogr.repository.DefaultRelationshipRepository;
import de.whitefrog.frogr.repository.ModelRepository;
import de.whitefrog.frogr.repository.RelationshipRepository;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 @2\u00020\u0001:\u0001@B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J7\u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u0002H\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0011J%\u0010\u0012\u001a\u00020\b\"\u0010\b\u0000\u0010\u0013*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u0002H\u0013\u00a2\u0006\u0002\u0010\u0016J5\u0010\u0012\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u0002H\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001bJ'\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJA\u0010 \u001a\b\u0012\u0004\u0012\u0002H\"0!\"\b\b\u0000\u0010\"*\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b'J%\u0010(\u001a\u00020)\"\u0010\b\u0000\u0010\u0013*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u0002H\u0013\u00a2\u0006\u0002\u0010*J?\u0010(\u001a\u0004\u0018\u0001H\u0013\"\u0010\b\u0000\u0010\u0013*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00142\u0006\u0010\u000b\u001a\u00020\n2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0004\b+\u0010,J?\u0010-\u001a\u0004\u0018\u0001H\t\"\u0010\b\u0000\u0010\t*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00142\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010.\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u001a\u00a2\u0006\u0002\u00100J(\u0010-\u001a\u0004\u0018\u00010)2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010.\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u001aJK\u00101\u001a\b\u0012\u0004\u0012\u0002H\u00130!\"\u0010\b\u0000\u0010\u0013*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00142\u0006\u0010\u000b\u001a\u00020\n2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b2J&\u00103\u001a\u0002042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010.\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u001e\u00105\u001a\u00020\b2\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00142\u0006\u00106\u001a\u000207J7\u00108\u001a\u00020\b\"\u0010\b\u0000\u0010\t*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00142\u0006\u0010\u000b\u001a\u00020\n2\u0006\u00109\u001a\u0002H\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010:J+\u00108\u001a\u0002H\t\"\u0010\b\u0000\u0010\t*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00142\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H\t0<\u00a2\u0006\u0002\u0010=J1\u0010>\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H\t0<2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0001\u00a2\u0006\u0002\b?R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lde/whitefrog/frogr/persistence/Relationships;", "", "service", "Lde/whitefrog/frogr/Service;", "persistence", "Lde/whitefrog/frogr/persistence/Persistence;", "(Lde/whitefrog/frogr/Service;Lde/whitefrog/frogr/persistence/Persistence;)V", "addRelationship", "", "T", "Lde/whitefrog/frogr/model/Model;", "model", "node", "Lorg/neo4j/graphdb/Node;", "annotation", "Lde/whitefrog/frogr/model/annotation/RelatedTo;", "_foreignModel", "(Lde/whitefrog/frogr/model/Model;Lorg/neo4j/graphdb/Node;Lde/whitefrog/frogr/model/annotation/RelatedTo;Lde/whitefrog/frogr/model/Model;)V", "delete", "R", "Lde/whitefrog/frogr/model/relationship/Relationship;", "relationship", "(Lde/whitefrog/frogr/model/relationship/Relationship;)V", "type", "Lorg/neo4j/graphdb/RelationshipType;", "direction", "Lorg/neo4j/graphdb/Direction;", "(Lde/whitefrog/frogr/model/Model;Lorg/neo4j/graphdb/RelationshipType;Lorg/neo4j/graphdb/Direction;Lde/whitefrog/frogr/model/Model;)V", "getRelatedModel", "fields", "Lde/whitefrog/frogr/model/FieldList;", "getRelatedModel$frogr_base", "getRelatedModels", "", "M", "descriptor", "Lde/whitefrog/frogr/persistence/FieldDescriptor;", "queryField", "Lde/whitefrog/frogr/model/QueryField;", "getRelatedModels$frogr_base", "getRelationship", "Lorg/neo4j/graphdb/Relationship;", "(Lde/whitefrog/frogr/model/relationship/Relationship;)Lorg/neo4j/graphdb/Relationship;", "getRelationship$frogr_base", "(Lde/whitefrog/frogr/model/Model;Lde/whitefrog/frogr/persistence/FieldDescriptor;Lde/whitefrog/frogr/model/FieldList;)Lde/whitefrog/frogr/model/relationship/Relationship;", "getRelationshipBetween", "other", "dir", "(Lde/whitefrog/frogr/model/Model;Lde/whitefrog/frogr/model/Model;Lorg/neo4j/graphdb/RelationshipType;Lorg/neo4j/graphdb/Direction;)Lde/whitefrog/frogr/model/relationship/Relationship;", "getRelationships", "getRelationships$frogr_base", "hasRelationshipTo", "", "removeProperty", "property", "", "save", "relModel", "(Lde/whitefrog/frogr/model/Model;Lde/whitefrog/frogr/model/relationship/Relationship;Lde/whitefrog/frogr/model/annotation/RelatedTo;)V", "context", "Lde/whitefrog/frogr/model/SaveContext;", "(Lde/whitefrog/frogr/model/SaveContext;)Lde/whitefrog/frogr/model/relationship/Relationship;", "saveField", "saveField$frogr_base", "Companion", "frogr-base"})
public final class Relationships {
    private final Service service;
    private final Persistence persistence;
    private static final Logger logger;
    public static final Companion Companion;

    private final <T extends Model> void addRelationship(T model, Node node, RelatedTo annotation, Model _foreignModel) {
        Object t;
        RelationshipRepository repository;
        Model foreignModel = _foreignModel;
        if (foreignModel.getId() == -1L) {
            if (foreignModel instanceof FBase && ((FBase)foreignModel).getUuid() != null) {
                Object t2 = this.service.repository(((Base)foreignModel).getClass()).findByUuid(((FBase)foreignModel).getUuid(), new String[0]);
                if (t2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type de.whitefrog.frogr.model.Model");
                }
                foreignModel = (Model)t2;
            } else {
                throw (Throwable)((Object)new RelatedNotPersistedException("the related field " + foreignModel + " is not yet persisted"));
            }
        }
        Node foreignNode = this.persistence.getNode(foreignModel);
        RelationshipType relationshipType = RelationshipType.withName((String)annotation.type());
        if (!annotation.multiple()) {
            RelationshipType relationshipType2 = relationshipType;
            Intrinsics.checkExpressionValueIsNotNull((Object)relationshipType2, (String)"relationshipType");
            if (this.hasRelationshipTo(node, foreignNode, relationshipType2, annotation.direction())) {
                return;
            }
        }
        try {
            Object r = this.service.repository(relationshipType.name());
            Intrinsics.checkExpressionValueIsNotNull(r, (String)"service.repository(relationshipType.name())");
            repository = (RelationshipRepository)r;
        }
        catch (RepositoryNotFoundException e) {
            String string = relationshipType.name();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"relationshipType.name()");
            repository = new DefaultRelationshipRepository(string);
            try {
                this.service.repositoryFactory().setRepositoryService(repository);
                this.service.repositoryFactory().register(relationshipType.name(), repository);
            }
            catch (ReflectiveOperationException ex) {
                Throwable throwable = ex.getCause();
                if (throwable == null) {
                    Intrinsics.throwNpe();
                }
                throw (Throwable)((Object)new RepositoryInstantiationException(throwable));
            }
        }
        if (Intrinsics.areEqual((Object)annotation.direction(), (Object)Direction.OUTGOING)) {
            Object t3 = repository.createModel(model, foreignModel);
            t = t3;
            Intrinsics.checkExpressionValueIsNotNull(t3, (String)"repository.createModel(model, foreignModel)");
        } else if (Intrinsics.areEqual((Object)annotation.direction(), (Object)Direction.INCOMING)) {
            Object t4 = repository.createModel(foreignModel, model);
            t = t4;
            Intrinsics.checkExpressionValueIsNotNull(t4, (String)"repository.createModel(foreignModel, model)");
        } else {
            Object t5 = repository.createModel(model, foreignModel);
            t = t5;
            Intrinsics.checkExpressionValueIsNotNull(t5, (String)"repository.createModel(model, foreignModel)");
        }
        Object relationship = t;
        repository.save((Base)relationship);
    }

    @Nullable
    public final <T extends de.whitefrog.frogr.model.relationship.Relationship<?, ?>> T getRelationshipBetween(@NotNull Model model, @NotNull Model other, @NotNull RelationshipType type, @NotNull Direction dir) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Relationship relationship = this.getRelationshipBetween(this.persistence.getNode(model), this.persistence.getNode(other), type, dir);
        return (T)(relationship == null ? null : (de.whitefrog.frogr.model.relationship.Relationship)Persistence.get$default(this.persistence, (PropertyContainer)relationship, null, null, 6, null));
    }

    @Nullable
    public final Relationship getRelationshipBetween(@NotNull Node node, @NotNull Node other, @NotNull RelationshipType type, @NotNull Direction dir) {
        Object v1;
        block1: {
            Iterable relationships;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            Iterable iterable = relationships = node.getRelationships(dir, new RelationshipType[]{type});
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"relationships");
            Iterable $receiver$iv = iterable;
            for (Object element$iv : $receiver$iv) {
                Relationship it = (Relationship)element$iv;
                if (!Intrinsics.areEqual((Object)it.getOtherNode(node), (Object)other)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Model getRelatedModel$frogr_base(@NotNull Model model, @NotNull RelatedTo annotation, @NotNull FieldList fields) {
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
            Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
            Intrinsics.checkParameterIsNotNull((Object)fields, (String)"fields");
            Validate.notNull((Object)model);
            Validate.notNull((Object)annotation.type());
            try {
                Relationship relationship = this.persistence.getNode(model).getSingleRelationship(RelationshipType.withName((String)annotation.type()), annotation.direction());
                if (relationship != null) {
                    Node node = this.persistence.getNode(model);
                    Node other = relationship.getOtherNode(node);
                    Object object = other.getProperty("type");
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    String type = (String)object;
                    ModelRepository repository = (ModelRepository)this.service.repository(type);
                    return (Model)repository.createModel((PropertyContainer)other, fields);
                }
            }
            catch (NotFoundException e) {
                void $receiver$iv;
                String string = e.getMessage();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if (!StringsKt.startsWith$default((String)string, (String)"More than", (boolean)false, (int)2, null)) break block6;
                Relationships.Companion.getLogger().error(e.getMessage());
                Relationships.Companion.getLogger().error("Relationships are:");
                Iterable iterable = this.persistence.getNode(model).getRelationships(RelationshipType.withName((String)annotation.type()), annotation.direction());
                Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"persistence.getNode(mode\u2026e), annotation.direction)");
                Iterable node = iterable;
                for (Object element$iv : $receiver$iv) {
                    Relationship rel = (Relationship)element$iv;
                    Relationships.Companion.getLogger().error(rel.toString());
                }
                throw (Throwable)e;
            }
        }
        return null;
    }

    @NotNull
    public final <M extends Model> Set<M> getRelatedModels$frogr_base(@NotNull Model model, @NotNull FieldDescriptor<?> descriptor, @NotNull QueryField queryField, @NotNull FieldList fields) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull(descriptor, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)queryField, (String)"queryField");
        Intrinsics.checkParameterIsNotNull((Object)fields, (String)"fields");
        RelatedTo relatedTo = descriptor.annotations().relatedTo;
        if (relatedTo == null) {
            Intrinsics.throwNpe();
        }
        RelatedTo annotation = relatedTo;
        Validate.notNull((Object)model);
        Validate.notNull((Object)annotation.type());
        Iterator iterator = this.persistence.getNode(model).getRelationships(annotation.direction(), new RelationshipType[]{RelationshipType.withName((String)annotation.type())}).iterator();
        if (iterator == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.neo4j.graphdb.ResourceIterator<org.neo4j.graphdb.Relationship>");
        }
        ResourceIterator iterator2 = (ResourceIterator)iterator;
        HashSet models = new HashSet();
        Node node = this.persistence.getNode(model);
        long count = 0L;
        while (iterator2.hasNext()) {
            long l;
            if (count < (long)queryField.skip()) {
                iterator2.next();
                l = count;
                count = l + 1L;
                continue;
            }
            l = count;
            count = l + 1L;
            if (l == (long)(queryField.skip() + queryField.limit())) break;
            Relationship relationship = (Relationship)iterator2.next();
            Node other = relationship.getOtherNode(node);
            Object object = other.getProperty("type");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String type = (String)object;
            if (annotation.restrictType() && Intrinsics.areEqual((Object)type, (Object)this.persistence.cache().getModelName(descriptor.baseClass())) ^ true) {
                long l2 = count;
                count = l2 + -1L;
                continue;
            }
            ModelRepository repository = (ModelRepository)this.service.repository(type);
            models.add(repository.createModel((PropertyContainer)other, fields));
        }
        iterator2.close();
        return models;
    }

    @NotNull
    public final <R extends de.whitefrog.frogr.model.relationship.Relationship<?, ?>> Relationship getRelationship(@NotNull R relationship) {
        Intrinsics.checkParameterIsNotNull(relationship, (String)"relationship");
        if (relationship.getId() <= (long)-1) {
            throw (Throwable)new UnsupportedOperationException("cant find relationship without id");
        }
        Relationship relationship2 = this.service.graph().getRelationshipById(relationship.getId());
        Intrinsics.checkExpressionValueIsNotNull((Object)relationship2, (String)"service.graph().getRelat\u2026shipById(relationship.id)");
        return relationship2;
    }

    @Nullable
    public final <R extends de.whitefrog.frogr.model.relationship.Relationship<?, ?>> R getRelationship$frogr_base(@NotNull Model model, @NotNull FieldDescriptor<?> descriptor, @NotNull FieldList fields) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull(descriptor, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)fields, (String)"fields");
        RelatedTo relatedTo = descriptor.annotations().relatedTo;
        if (relatedTo == null) {
            Intrinsics.throwNpe();
        }
        RelatedTo annotation = relatedTo;
        Validate.notNull((Object)model);
        Validate.notNull((Object)annotation.type());
        Iterator iterator = this.persistence.getNode(model).getRelationships(annotation.direction(), new RelationshipType[]{RelationshipType.withName((String)annotation.type())}).iterator();
        if (iterator == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.neo4j.graphdb.ResourceIterator<org.neo4j.graphdb.Relationship>");
        }
        ResourceIterator iterator2 = (ResourceIterator)iterator;
        de.whitefrog.frogr.model.relationship.Relationship relationshipModel = null;
        if (iterator2.hasNext()) {
            Relationship relationship;
            Relationship relationship2 = relationship = (Relationship)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)relationship2, (String)"relationship");
            relationshipModel = (de.whitefrog.frogr.model.relationship.Relationship)Persistence.get$default(this.persistence, (PropertyContainer)relationship2, fields, null, 4, null);
        }
        iterator2.close();
        return (R)relationshipModel;
    }

    @NotNull
    public final <R extends de.whitefrog.frogr.model.relationship.Relationship<?, ?>> Set<R> getRelationships$frogr_base(@NotNull Model model, @NotNull FieldDescriptor<?> descriptor, @Nullable QueryField queryField, @NotNull FieldList fields) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull(descriptor, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)fields, (String)"fields");
        RelatedTo relatedTo = descriptor.annotations().relatedTo;
        if (relatedTo == null) {
            Intrinsics.throwNpe();
        }
        RelatedTo annotation = relatedTo;
        Validate.notNull((Object)model);
        Validate.notNull((Object)annotation.type());
        Iterator iterator = this.persistence.getNode(model).getRelationships(annotation.direction(), new RelationshipType[]{RelationshipType.withName((String)annotation.type())}).iterator();
        if (iterator == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.neo4j.graphdb.ResourceIterator<org.neo4j.graphdb.Relationship>");
        }
        ResourceIterator iterator2 = (ResourceIterator)iterator;
        HashSet<Base> models = new HashSet<Base>();
        long count = 0L;
        while (iterator2.hasNext()) {
            Relationship relationship;
            long l;
            if (queryField != null && count < (long)queryField.skip()) {
                iterator2.next();
                l = count;
                count = l + 1L;
                continue;
            }
            if (queryField != null) {
                l = count;
                count = l + 1L;
                if (l == (long)(queryField.skip() + queryField.limit())) break;
            }
            Relationship relationship2 = relationship = (Relationship)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)relationship2, (String)"relationship");
            models.add(Persistence.get$default(this.persistence, (PropertyContainer)relationship2, fields, null, 4, null));
        }
        iterator2.close();
        return models;
    }

    public final boolean hasRelationshipTo(@NotNull Node node, @NotNull Node other, @NotNull RelationshipType type, @NotNull Direction direction) {
        boolean bl;
        block3: {
            Iterable relationships;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)direction, (String)"direction");
            Iterable iterable = relationships = node.getRelationships(direction, new RelationshipType[]{type});
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"relationships");
            Iterable $receiver$iv = iterable;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Relationship it = (Relationship)element$iv;
                    if (!Intrinsics.areEqual((Object)it.getOtherNode(node), (Object)other)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final <T extends de.whitefrog.frogr.model.relationship.Relationship<?, ?>> T save(@NotNull SaveContext<T> context) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        de.whitefrog.frogr.model.relationship.Relationship model = (de.whitefrog.frogr.model.relationship.Relationship)context.model();
        boolean create = false;
        if (!model.isPersisted()) {
            Relationship relationship;
            create = true;
            if (!model.getFrom().isPersisted()) {
                throw (Throwable)new FrogrException("the model " + model.getFrom() + " is not yet persisted, but used as 'from' in relationship " + model);
            }
            if (!model.getTo().isPersisted()) {
                throw (Throwable)new FrogrException("the model " + model.getTo() + " is not yet persisted, but used as 'to' in relationship " + model);
            }
            Node node = this.persistence.getNode(model.getFrom());
            Node toNode = this.persistence.getNode(model.getTo());
            RelationshipType relType = RelationshipType.withName((String)context.repository().getType());
            Relationship relationship2 = relationship = node.createRelationshipTo(toNode, relType);
            Intrinsics.checkExpressionValueIsNotNull((Object)relationship2, (String)"relationship");
            context.setNode((PropertyContainer)relationship2);
            model.setId(relationship.getId());
            if (model instanceof FBase) {
                ((FBase)model).setCreated(Long.valueOf(System.currentTimeMillis()));
            }
        } else if (model instanceof FBase) {
            ((FBase)model).updateLastModified();
        }
        Iterator<Object> iterator = model.getRemoveProperties().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = string = (String)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"property");
            this.removeProperty(model, string2);
        }
        for (FieldDescriptor fieldDescriptor : context.fieldMap()) {
            this.persistence.saveField$frogr_base(context, fieldDescriptor, create);
        }
        model.getCheckedFields().clear();
        Logger logger = Relationships.Companion.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
        if (logger.isInfoEnabled()) {
            Relationships.Companion.getLogger().info("Relationship {}({}, {}) {}", new Object[]{this.persistence.cache().getModelName(model.getClass()), model.getFrom(), model.getTo(), create ? "created" : "updated"});
        }
        return (T)model;
    }

    private final <T extends de.whitefrog.frogr.model.relationship.Relationship<?, ?>> void save(Model model, T relModel, RelatedTo annotation) {
        if (!relModel.getFrom().isPersisted()) {
            throw (Throwable)((Object)new RelatedNotPersistedException("the 'from' model " + relModel.getFrom() + " (" + annotation.type() + ") is not yet persisted"));
        }
        if (!relModel.getTo().isPersisted()) {
            throw (Throwable)((Object)new RelatedNotPersistedException("the 'to' model " + relModel.getTo() + " (" + annotation.type() + ") is not yet persisted"));
        }
        Object repository = this.service.repository(relModel.getClass());
        if (Intrinsics.areEqual((Object)annotation.direction(), (Object)Direction.INCOMING)) {
            if (Intrinsics.areEqual((Object)relModel.getTo(), (Object)model) ^ true) {
                throw (Throwable)((Object)new PersistException(relModel.toString() + " should have " + model + " as 'to' field set"));
            }
        } else if (Intrinsics.areEqual((Object)annotation.direction(), (Object)Direction.OUTGOING)) {
            if (Intrinsics.areEqual((Object)relModel.getFrom(), (Object)model) ^ true) {
                throw (Throwable)((Object)new PersistException(relModel.toString() + " should have " + model + " as 'from' field set"));
            }
        } else if (Intrinsics.areEqual((Object)annotation.direction(), (Object)Direction.BOTH) && Intrinsics.areEqual((Object)relModel.getFrom(), (Object)model) ^ true && Intrinsics.areEqual((Object)relModel.getTo(), (Object)model) ^ true) {
            throw (Throwable)((Object)new PersistException(relModel.toString() + "should have " + model + " either set as 'from' or 'to' field"));
        }
        repository.save((Base)((Base)relModel));
    }

    public final <T extends Model> void saveField$frogr_base(@NotNull SaveContext<T> context, @NotNull FieldDescriptor<?> descriptor) throws IllegalAccessException {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull(descriptor, (String)"descriptor");
        AnnotationDescriptor annotations = descriptor.annotations();
        Model model = (Model)context.model();
        Node node = (Node)context.node();
        RelatedTo relatedTo = annotations.relatedTo;
        if (relatedTo == null) {
            Intrinsics.throwNpe();
        }
        RelatedTo relatedTo2 = relatedTo;
        Object value = descriptor.field().get(model);
        if (!descriptor.isCollection()) {
            Relationship existing;
            Relationship relationship = existing = node.getSingleRelationship(RelationshipType.withName((String)relatedTo2.type()), relatedTo2.direction());
            if (relationship != null) {
                relationship.delete();
            }
            if (descriptor.isModel()) {
                Object object = value;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type de.whitefrog.frogr.model.Model");
                }
                Model foreignModel = (Model)object;
                this.addRelationship(model, node, relatedTo2, foreignModel);
            } else {
                Object object = value;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type de.whitefrog.frogr.model.relationship.Relationship<*, *>");
                }
                de.whitefrog.frogr.model.relationship.Relationship relModel = (de.whitefrog.frogr.model.relationship.Relationship)object;
                this.save(model, relModel, relatedTo2);
            }
        } else {
            Object object = value;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<*>");
            }
            Collection collection = (Collection)object;
            if (!annotations.lazy) {
                RelationshipType relationshipType = RelationshipType.withName((String)relatedTo2.type());
                for (Relationship relationship : node.getRelationships(relatedTo2.direction(), new RelationshipType[]{relationshipType})) {
                    Node node2 = relationship.getOtherNode(node);
                    Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"relationship.getOtherNode(node)");
                    Base other = Persistence.get$default(this.persistence, (PropertyContainer)node2, null, null, 6, null);
                    if (collection.contains(other)) continue;
                    relationship.delete();
                    Relationships.Companion.getLogger().info("{}: relationship to {} removed", (Object)model, (Object)other);
                }
            }
            if (descriptor.isModel()) {
                for (Model foreignModel : (Collection)value) {
                    this.addRelationship(model, node, relatedTo2, foreignModel);
                }
            } else {
                for (de.whitefrog.frogr.model.relationship.Relationship relModel : (Collection)value) {
                    this.save(model, relModel, relatedTo2);
                }
            }
        }
    }

    public final void removeProperty(@NotNull de.whitefrog.frogr.model.relationship.Relationship<?, ?> model, @NotNull String property) {
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Relationship node = this.getRelationship(model);
        node.removeProperty(property);
        try {
            Field field;
            Field field2 = field = model.getClass().getDeclaredField(property);
            Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"field");
            if (!field2.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(model, null);
        }
        catch (ReflectiveOperationException e) {
            throw (Throwable)new FrogrException("field " + property + " could not be found on " + model, (Throwable)e);
        }
    }

    public final <R extends de.whitefrog.frogr.model.relationship.Relationship<?, ?>> void delete(@NotNull R relationship) {
        Intrinsics.checkParameterIsNotNull(relationship, (String)"relationship");
        Relationship neoRel = this.getRelationship(relationship);
        neoRel.delete();
        Relationships.Companion.getLogger().info("relationship {} between {} and {} removed", new Object[]{neoRel.getType(), relationship.getFrom(), relationship.getTo()});
    }

    public final <T extends Model> void delete(@NotNull T model, @NotNull RelationshipType type, @NotNull Direction direction, @NotNull Model _foreignModel) {
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)direction, (String)"direction");
        Intrinsics.checkParameterIsNotNull((Object)_foreignModel, (String)"_foreignModel");
        Model foreignModel = _foreignModel;
        if (foreignModel.getId() == -1L) {
            if (foreignModel instanceof FBase && ((FBase)foreignModel).getUuid() != null) {
                Object t = this.service.repository(((Base)foreignModel).getClass()).findByUuid(((FBase)foreignModel).getUuid(), new String[0]);
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type de.whitefrog.frogr.model.Model");
                }
                foreignModel = (Model)t;
            } else {
                throw (Throwable)((Object)new RelatedNotPersistedException("the related field " + foreignModel + " is not yet persisted"));
            }
        }
        Node node = this.persistence.getNode(model);
        Node foreignNode = this.persistence.getNode(foreignModel);
        for (Relationship relationship : node.getRelationships(type, direction)) {
            if (!Intrinsics.areEqual((Object)relationship.getOtherNode(node), (Object)foreignNode)) continue;
            relationship.delete();
            Relationships.Companion.getLogger().info("relationship {} between {} and {} removed", new Object[]{type.name(), model, foreignModel});
        }
    }

    public Relationships(@NotNull Service service, @NotNull Persistence persistence) {
        Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
        Intrinsics.checkParameterIsNotNull((Object)persistence, (String)"persistence");
        this.service = service;
        this.persistence = persistence;
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(Relationships.class);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lde/whitefrog/frogr/persistence/Relationships$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "frogr-base"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

