/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.persistence;

import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.TimeBasedGenerator;
import de.whitefrog.frogr.Service;
import de.whitefrog.frogr.exception.FieldNotFoundException;
import de.whitefrog.frogr.exception.FrogrException;
import de.whitefrog.frogr.exception.MissingRequiredException;
import de.whitefrog.frogr.exception.PersistException;
import de.whitefrog.frogr.helper.KotlinHelper;
import de.whitefrog.frogr.helper.ReflectionUtil;
import de.whitefrog.frogr.model.Base;
import de.whitefrog.frogr.model.FBase;
import de.whitefrog.frogr.model.FieldList;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.model.QueryField;
import de.whitefrog.frogr.model.SaveContext;
import de.whitefrog.frogr.model.annotation.IndexType;
import de.whitefrog.frogr.model.annotation.Indexed;
import de.whitefrog.frogr.persistence.FieldDescriptor;
import de.whitefrog.frogr.persistence.ModelCache;
import de.whitefrog.frogr.persistence.Relationships;
import de.whitefrog.frogr.repository.ModelRepository;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.reflect.ConstructorUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0004\u001a\u00020\u0005J\u001d\u0010\f\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010\u0011J%\u0010\u0012\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u00132\u0006\u0010\u0010\u001a\u0002H\u000e2\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J-\u0010\u0012\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u00132\u0006\u0010\u0010\u001a\u0002H\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J1\u0010\u0012\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u00132\u0006\u0010\u0010\u001a\u0002H\u000e2\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a\"\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ;\u0010\u001d\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u0002H\u000e2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\u0014\u001a\u00020\u0015H\u0003\u00a2\u0006\u0002\u0010\"J'\u0010#\u001a\u0004\u0018\u0001H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\u001bH\u0002J<\u0010(\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010)\u001a\u00020\u00152\u0010\b\u0002\u0010*\u001a\n\u0012\u0004\u0012\u0002H\u000e\u0018\u00010+H\u0087\u0002\u00a2\u0006\u0002\u0010,J\u0016\u0010-\u001a\b\u0012\u0002\b\u0003\u0018\u00010+2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010.\u001a\u00020/2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u00100\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u001bH\u0002J3\u00102\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u00103\u001a\b\u0012\u0004\u0012\u0002H\u000e042\f\u00105\u001a\b\u0012\u0004\u0012\u0002H\u000e06H\u0007\u00a2\u0006\u0002\u00107J9\u00108\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u00132\f\u00105\u001a\b\u0012\u0004\u0012\u0002H\u000e062\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u00109\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b:R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lde/whitefrog/frogr/persistence/Persistence;", "", "service", "Lde/whitefrog/frogr/Service;", "cache", "Lde/whitefrog/frogr/persistence/ModelCache;", "(Lde/whitefrog/frogr/Service;Lde/whitefrog/frogr/persistence/ModelCache;)V", "relationships", "Lde/whitefrog/frogr/persistence/Relationships;", "uuidGenerator", "Lcom/fasterxml/uuid/impl/TimeBasedGenerator;", "kotlin.jvm.PlatformType", "delete", "", "T", "Lde/whitefrog/frogr/model/Model;", "model", "(Lde/whitefrog/frogr/model/Model;)V", "fetch", "Lde/whitefrog/frogr/model/Base;", "fields", "Lde/whitefrog/frogr/model/FieldList;", "(Lde/whitefrog/frogr/model/Base;Lde/whitefrog/frogr/model/FieldList;)V", "refetch", "", "(Lde/whitefrog/frogr/model/Base;Lde/whitefrog/frogr/model/FieldList;Z)V", "", "", "(Lde/whitefrog/frogr/model/Base;[Ljava/lang/String;)V", "fetchField", "node", "Lorg/neo4j/graphdb/PropertyContainer;", "descriptor", "Lde/whitefrog/frogr/persistence/FieldDescriptor;", "(Lorg/neo4j/graphdb/PropertyContainer;Lde/whitefrog/frogr/model/Base;Lde/whitefrog/frogr/persistence/FieldDescriptor;Lde/whitefrog/frogr/model/FieldList;)V", "findByUuid", "label", "uuid", "(Ljava/lang/String;Ljava/lang/String;)Lde/whitefrog/frogr/model/Model;", "generateUuid", "get", "_fields", "_clazz", "Ljava/lang/Class;", "(Lorg/neo4j/graphdb/PropertyContainer;Lde/whitefrog/frogr/model/FieldList;Ljava/lang/Class;)Lde/whitefrog/frogr/model/Base;", "getClass", "getNode", "Lorg/neo4j/graphdb/Node;", "removeProperty", "property", "save", "repository", "Lde/whitefrog/frogr/repository/ModelRepository;", "context", "Lde/whitefrog/frogr/model/SaveContext;", "(Lde/whitefrog/frogr/repository/ModelRepository;Lde/whitefrog/frogr/model/SaveContext;)Lde/whitefrog/frogr/model/Model;", "saveField", "created", "saveField$frogr_base", "Companion", "frogr-base"})
public final class Persistence {
    private final Relationships relationships;
    private final TimeBasedGenerator uuidGenerator;
    private final Service service;
    private final ModelCache cache;
    private static final Logger logger;
    public static final Companion Companion;

    @NotNull
    public final ModelCache cache() {
        return this.cache;
    }

    @NotNull
    public final Relationships relationships() {
        return this.relationships;
    }

    public final <T extends Model> void delete(@NotNull T model) {
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        Node node = this.getNode(model);
        for (Relationship relationship : node.getRelationships()) {
            relationship.delete();
        }
        node.delete();
    }

    @NotNull
    public final <T extends Model> T save(@NotNull ModelRepository<T> repository, @NotNull SaveContext<T> context) throws MissingRequiredException {
        Intrinsics.checkParameterIsNotNull(repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Model model = (Model)context.model();
        Label label = repository.label();
        boolean create = false;
        if (!model.isPersisted()) {
            Node node;
            create = true;
            Node node2 = node = this.service.graph().createNode(new Label[]{label});
            Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"node");
            context.setNode((PropertyContainer)node2);
            repository.labels().stream().filter((Predicate)new Predicate<Label>(node){
                final /* synthetic */ Node $node;

                public final boolean test(Label l) {
                    return !this.$node.hasLabel(l);
                }
                {
                    this.$node = node;
                }
            }).forEach((Consumer)new Consumer<Label>(node){
                final /* synthetic */ Node $node;

                public final void accept(Label it) {
                    this.$node.addLabel(it);
                }
                {
                    this.$node = node;
                }
            });
            model.setId(node.getId());
            if (model instanceof FBase) {
                ((FBase)model).setCreated(Long.valueOf(System.currentTimeMillis()));
            }
            model.setType(label.name());
        } else {
            if (model.getType() == null) {
                model.setType(label.name());
            }
            if (model instanceof FBase) {
                ((FBase)model).updateLastModified();
            }
        }
        for (String string : ((Model)context.model()).getRemoveProperties()) {
            Model model2 = (Model)context.model();
            String string2 = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"property");
            this.removeProperty(model2, string2);
        }
        for (FieldDescriptor fieldDescriptor : context.fieldMap()) {
            this.saveField$frogr_base(context, fieldDescriptor, create);
        }
        model.getCheckedFields().clear();
        model.getRemoveProperties().clear();
        Persistence.Companion.getLogger().info("{} {}", (Object)model, (Object)(create ? "created" : "updated"));
        return (T)model;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final <T extends Base> void saveField$frogr_base(@NotNull SaveContext<T> context, @NotNull FieldDescriptor<?> descriptor, boolean created) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull(descriptor, (String)"descriptor");
        field = descriptor.field();
        annotations = descriptor.annotations();
        model = context.model();
        node = context.node();
        value = null;
        try {
            value = field.get(model);
            if (created && annotations.required && (value == null || value instanceof String && (var9_9 = (CharSequence)value).length() == 0)) {
                throw (Throwable)new MissingRequiredException((Base)model, field);
            }
            if (created) ** GOTO lbl-1000
            v0 = field.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"field.name");
            if (context.fieldChanged(v0)) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = valueChanged = false;
            }
            if (!annotations.notPersistent && !annotations.blob) {
                if (created && annotations.uuid && field.get(model) == null) {
                    uuid = this.generateUuid();
                    field.set(model, uuid);
                    value = uuid;
                    valueChanged = true;
                }
                if (value != null) {
                    if (annotations.relatedTo != null && valueChanged && model instanceof Model) {
                        this.relationships.saveField$frogr_base(context, descriptor);
                    } else if (!(value instanceof Collection) && !(value instanceof Model)) {
                        if (value.getClass().isEnum()) {
                            if (!node.hasProperty(field.getName()) || Intrinsics.areEqual((Object)((Enum)value).name(), (Object)node.getProperty(field.getName())) ^ true) {
                                node.setProperty(field.getName(), (Object)((Enum)value).name());
                                de.whitefrog.frogr.persistence.Persistence$Companion.access$getLogger$p(Persistence.Companion).info("{}: set enum value \"{}\" to \"{}\"", new Object[]{model, field.getName(), ((Enum)value).name()});
                            }
                        } else if (value instanceof Date) {
                            node.setProperty(field.getName(), (Object)((Date)value).getTime());
                            de.whitefrog.frogr.persistence.Persistence$Companion.access$getLogger$p(Persistence.Companion).info("{}: set date value \"{}\" to \"{}\"", new Object[]{model, field.getName(), ((Date)value).getTime()});
                        } else if (valueChanged) {
                            node.setProperty(field.getName(), value);
                            de.whitefrog.frogr.persistence.Persistence$Companion.access$getLogger$p(Persistence.Companion).info("{}: set value \"{}\" to \"{}\"", new Object[]{model, field.getName(), value});
                            if (value instanceof String) {
                                v2 = annotations.indexed;
                                if (Intrinsics.areEqual((Object)(v2 != null ? v2.type() : null), (Object)IndexType.LowerCase)) {
                                    var10_14 = (String)value;
                                    var12_16 = field.getName() + "_lower";
                                    var11_18 /* !! */  = node;
                                    v3 = var10_14.toLowerCase();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"(this as java.lang.String).toLowerCase()");
                                    var13_20 = v3;
                                    var11_18 /* !! */ .setProperty(var12_16, (Object)var13_20);
                                    v4 = new Object[3];
                                    v4[0] = model;
                                    v4[1] = field.getName() + "_lower";
                                    var10_14 = (String)value;
                                    var15_22 = 2;
                                    var14_23 = v4;
                                    var13_20 = v4;
                                    var12_16 = "{}: set value \"{}\" to \"{}\"";
                                    var11_18 /* !! */  = de.whitefrog.frogr.persistence.Persistence$Companion.access$getLogger$p(Persistence.Companion);
                                    v5 = var10_14.toLowerCase();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"(this as java.lang.String).toLowerCase()");
                                    var16_25 = v5;
                                    var14_23[var15_22] = var16_25;
                                    var11_18 /* !! */ .info(var12_16, var13_20);
                                }
                            }
                        }
                    }
                } else if (valueChanged && annotations.nullRemove) {
                    de.whitefrog.frogr.persistence.Persistence$Companion.access$getLogger$p(Persistence.Companion).info("{}: removed value \"{}\"", model, (Object)field.getName());
                    node.removeProperty(field.getName());
                    v6 = annotations.indexed;
                    if (Intrinsics.areEqual((Object)(v6 != null ? v6.type() : null), (Object)IndexType.LowerCase)) {
                        node.removeProperty(field.getName() + "_lower");
                    }
                }
            }
        }
        catch (ReflectiveOperationException e) {
            de.whitefrog.frogr.persistence.Persistence$Companion.access$getLogger$p(Persistence.Companion).error("Could not get property on {}: {}", new Object[]{model, e.getMessage(), e});
        }
        catch (ConstraintViolationException e) {
            v7 = new StringBuilder().append("A ");
            v8 = model.getClass().getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"model.javaClass.simpleName");
            var10_15 = v8;
            var13_21 = v7;
            var12_17 = v9;
            var11_19 = v9;
            v10 = var10_15;
            if (v10 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            v11 = v10.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"(this as java.lang.String).toLowerCase()");
            var14_24 = v11;
            var12_17(var13_21.append(var14_24).append(" with the ").append(field.getName()).append(" \"").append(value).append("\" already exists").toString(), (Base)model, field);
            throw (Throwable)var11_19;
        }
        catch (IllegalArgumentException e) {
            de.whitefrog.frogr.persistence.Persistence$Companion.access$getLogger$p(Persistence.Companion).error("Could not store property {} on {}: {}", new Object[]{field.getName(), model, e.getMessage()});
        }
    }

    @JvmOverloads
    @NotNull
    public final <T extends Base> T get(@NotNull PropertyContainer node, @NotNull FieldList _fields, @Nullable Class<T> _clazz) throws PersistException {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)_fields, (String)"_fields");
        FieldList fields = _fields;
        Validate.notNull((Object)node, (String)"node can't be null");
        try {
            Base model;
            Class<Object> clazz = _clazz;
            if (clazz == null && (clazz = this.getClass(node)) == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<T>");
            }
            Class<T> clazz2 = clazz;
            if (node instanceof Node) {
                T t = clazz2.newInstance();
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"clazz.newInstance()");
                model = (Base)t;
                model.setId(((Node)node).getId());
            } else {
                Relationship rel = (Relationship)node;
                Node node2 = rel.getStartNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"rel.startNode");
                Model from = (Model)Persistence.get$default(this, (PropertyContainer)node2, fields.getOrEmpty("from").subFields(), null, 4, null);
                Node node3 = rel.getEndNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)node3, (String)"rel.endNode");
                Model to = (Model)Persistence.get$default(this, (PropertyContainer)node3, fields.getOrEmpty("to").subFields(), null, 4, null);
                Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(clazz2, (Class[])new Class[]{from.getClass(), to.getClass()});
                Object t = constructor.newInstance(from, to);
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type T");
                }
                model = (Base)t;
                model.setId(rel.getId());
                fields = new FieldList(fields);
                fields.remove((Object)new QueryField("from"));
                fields.remove((Object)new QueryField("to"));
            }
            this.service.repository(clazz2).fetch(model, fields);
            return (T)model;
        }
        catch (IllegalStateException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            Exception exception = e;
            if (!(exception instanceof PersistException)) {
                exception = null;
            }
            PersistException persistException = (PersistException)((Object)exception);
            throw persistException != null ? (Throwable)((Object)persistException) : (Throwable)((Object)new PersistException(e));
        }
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Base get$default(Persistence persistence, PropertyContainer propertyContainer, FieldList fieldList, Class clazz, int n, Object object) throws PersistException {
        if ((n & 2) != 0) {
            fieldList = new FieldList();
        }
        if ((n & 4) != 0) {
            clazz = null;
        }
        return persistence.get(propertyContainer, fieldList, clazz);
    }

    @JvmOverloads
    @NotNull
    public final <T extends Base> T get(@NotNull PropertyContainer node, @NotNull FieldList _fields) throws PersistException {
        return (T)Persistence.get$default(this, node, _fields, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final <T extends Base> T get(@NotNull PropertyContainer node) throws PersistException {
        return (T)Persistence.get$default(this, node, null, null, 6, null);
    }

    private final Class<?> getClass(PropertyContainer node) {
        String string;
        if (node instanceof Relationship) {
            string = ((Relationship)node).getType().name();
        } else {
            Object object = node.getProperty("type");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            string = (String)object;
        }
        String className = string;
        ModelCache modelCache = this.cache();
        String string2 = className;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"className");
        return modelCache.getModel(string2);
    }

    private final String generateUuid() {
        UUID uuid = this.uuidGenerator.generate();
        StringBuilder stringBuilder = new StringBuilder();
        UUID uUID = uuid;
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"uuid");
        return stringBuilder.append(Long.toHexString(uUID.getMostSignificantBits())).append(Long.toHexString(uuid.getLeastSignificantBits())).toString();
    }

    private final void removeProperty(Model model, String property) {
        FieldDescriptor<?> fieldDescriptor = this.cache().fieldDescriptor(model.getClass(), property);
        if (fieldDescriptor == null) {
            throw (Throwable)((Object)new FieldNotFoundException(property, (Base)model));
        }
        FieldDescriptor<?> descriptor = fieldDescriptor;
        Node node = this.getNode(model);
        node.removeProperty(property);
        Indexed indexed = descriptor.annotations().indexed;
        if (Intrinsics.areEqual((Object)(indexed != null ? indexed.type() : null), (Object)IndexType.LowerCase)) {
            node.removeProperty(property + "_lower");
        }
        try {
            Field field;
            Field field2 = field = ReflectionUtil.getSuperField(model.getClass(), property);
            Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"field");
            if (!field2.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(model, null);
        }
        catch (ReflectiveOperationException e) {
            throw (Throwable)((Object)new FieldNotFoundException(property, (Base)model));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Node getNode(@NotNull Model model) {
        Node node;
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Validate.notNull((Object)model);
        if (model.getId() > (long)-1) {
            Node node2 = this.service.graph().getNodeById(model.getId());
            node = node2;
            Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"service.graph().getNodeById(model.id)");
        } else if (model instanceof FBase && ((FBase)model).getUuid() != null && model.getType() != null) {
            void var2_2;
            Node node3;
            GraphDatabaseService graphDatabaseService = this.service.graph();
            String string = model.getType();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Node node4 = node3 = graphDatabaseService.findNode(Label.label((String)string), "uuid", (Object)((FBase)model).getUuid());
            Intrinsics.checkExpressionValueIsNotNull((Object)node4, (String)"node");
            model.setId(node4.getId());
            node = var2_2;
        } else {
            throw (Throwable)new UnsupportedOperationException("cant get a node without id or uuid");
        }
        return node;
    }

    public final <T extends Base> void fetch(@NotNull T model, String ... fields) {
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)fields, (String)"fields");
        List<String> list = Arrays.asList(Arrays.copyOf(fields, fields.length));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(*fields)");
        this.fetch(model, FieldList.Companion.parseFields(list), false);
    }

    public final <T extends Base> void fetch(@NotNull T model, @NotNull FieldList fields) {
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)fields, (String)"fields");
        this.fetch(model, fields, false);
    }

    public final <T extends Base> void fetch(@NotNull T model, @NotNull FieldList fields, boolean refetch) {
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)fields, (String)"fields");
        Validate.notNull(model, (String)"model cannot be null");
        if (!model.isPersisted()) {
            throw (Throwable)new FrogrException("the model " + model + " is not persisted yet");
        }
        try {
            PropertyContainer propertyContainer;
            if (model instanceof de.whitefrog.frogr.model.relationship.Relationship) {
                de.whitefrog.frogr.model.relationship.Relationship relModel = (de.whitefrog.frogr.model.relationship.Relationship)model;
                propertyContainer = (PropertyContainer)this.relationships.getRelationship(relModel);
            } else {
                propertyContainer = (PropertyContainer)this.getNode((Model)model);
            }
            PropertyContainer node = propertyContainer;
            for (FieldDescriptor<?> descriptor : this.cache.fieldMap(model.getClass())) {
                boolean fetch;
                if (Intrinsics.areEqual((Object)descriptor.getName(), (Object)"id") && descriptor.annotations().notPersistent || !(fetch = descriptor.annotations().fetch || fields.containsField("all") || fields.containsField(descriptor.getName()))) continue;
                if (!refetch && model.getFetchedFields().contains(descriptor.getName()) && fields.containsField(descriptor.getName())) {
                    QueryField queryField = fields.get(descriptor.getName());
                    if (queryField == null) {
                        Intrinsics.throwNpe();
                    }
                    if (queryField.subFields().isEmpty()) continue;
                }
                this.fetchField(node, model, descriptor, fields);
            }
        }
        catch (ReflectiveOperationException e) {
            Persistence.Companion.getLogger().error("could not load relations for {}: {}", new Object[]{model, e.getMessage(), e});
        }
    }

    /*
     * Unable to fully structure code
     */
    private final <T extends Base> void fetchField(PropertyContainer node, T model, FieldDescriptor<?> descriptor, FieldList fields) throws ReflectiveOperationException {
        annotations = descriptor.annotations();
        field = descriptor.field();
        field.setAccessible(true);
        if (node instanceof Relationship) {
            v0 = model;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type de.whitefrog.frogr.model.relationship.Relationship<*, *>");
            }
            relModel = (de.whitefrog.frogr.model.relationship.Relationship)v0;
            if (Intrinsics.areEqual((Object)field.getName(), (Object)"from") && fields.containsField("from")) {
                v1 = fields.get("from");
                if (v1 == null) {
                    Intrinsics.throwNpe();
                }
                if (!v1.subFields().isEmpty()) {
                    v2 = this.service.repository(relModel.getFrom().getClass());
                    v3 = (Base)relModel.getFrom();
                    v4 = fields.get("from");
                    if (v4 == null) {
                        Intrinsics.throwNpe();
                    }
                    v2.fetch(v3, v4.subFields());
                }
            }
            if (Intrinsics.areEqual((Object)field.getName(), (Object)"to") && fields.containsField("to")) {
                v5 = fields.get("to");
                if (v5 == null) {
                    Intrinsics.throwNpe();
                }
                if (!v5.subFields().isEmpty()) {
                    v6 = this.service.repository(relModel.getTo().getClass());
                    v7 = (Base)relModel.getTo();
                    v8 = fields.get("to");
                    if (v8 == null) {
                        Intrinsics.throwNpe();
                    }
                    v6.fetch(v7, v8.subFields());
                }
            }
        }
        if (!(node instanceof Node) || annotations.relationshipCount == null) ** GOTO lbl-1000
        v9 = field.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"field.name");
        if (fields.containsField(v9)) {
            v10 = annotations.relationshipCount;
            if (v10 == null) {
                Intrinsics.throwNpe();
            }
            count = v10;
            field.set(model, Iterables.count((Iterable)((Node)node).getRelationships(count.direction(), new RelationshipType[]{RelationshipType.withName((String)count.type())})));
        } else if (model instanceof Model && annotations.relatedTo != null) {
            if (!annotations.fetch) {
                v11 = field.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"field.name");
                if (!fields.containsField(v11)) {
                    return;
                }
            }
            v12 = field.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"field.name");
            if (fields.containsField(v12)) {
                v13 = field.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"field.name");
                v14 = fields.get(v13);
                if (v14 == null) {
                    Intrinsics.throwNpe();
                }
                v15 = v14.subFields();
            } else {
                v15 = new FieldList();
            }
            subFields = v15;
            v16 = field.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"field.name");
            if (fields.containsField(v16)) {
                v17 = field.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"field.name");
                v18 = fields.get(v17);
                if (v18 == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                v19 = field.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)v19, (String)"field.name");
                v18 = fieldDescriptor = new QueryField(v19);
            }
            if (descriptor.isCollection()) {
                related = descriptor.isModel() != false ? (Collection)this.relationships.getRelatedModels$frogr_base((Model)model, descriptor, fieldDescriptor, subFields) : (Collection)this.relationships.getRelationships$frogr_base((Model)model, descriptor, fieldDescriptor, subFields);
                field.set(model, Set.class.isAssignableFrom(field.getType()) != false ? related : (Collection)new ArrayList<E>(related));
            } else {
                if (descriptor.isModel()) {
                    v20 = (Model)model;
                    v21 = annotations.relatedTo;
                    if (v21 == null) {
                        Intrinsics.throwNpe();
                    }
                    v22 = (Base)this.relationships.getRelatedModel$frogr_base(v20, v21, subFields);
                } else {
                    v22 = (Base)this.relationships.getRelationship$frogr_base((Model)model, descriptor, subFields);
                }
                related = v22;
                field.set(model, related);
            }
        } else if (node.hasProperty(field.getName())) {
            if (Enum.class.isAssignableFrom(field.getType())) {
                v23 = field.getType();
                if (v23 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<kotlin.Enum<*>>");
                }
                v24 = node.getProperty(field.getName());
                if (v24 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                field.set(model, KotlinHelper.getEnumValue(v23, (String)v24));
            } else if (Date.class.isAssignableFrom(field.getType())) {
                v25 = node.getProperty(field.getName());
                if (v25 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
                }
                field.set(model, new Date((Long)v25));
            } else {
                field.set(model, node.getProperty(field.getName()));
            }
        }
        model.getFetchedFields().add(field.getName());
    }

    @Nullable
    public final <T extends Model> T findByUuid(@NotNull String label, @NotNull String uuid) {
        Model model;
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        ResourceIterator iterator = this.service.graph().findNodes(Label.label((String)label), "uuid", (Object)uuid);
        if (iterator.hasNext()) {
            Object object = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"iterator.next()");
            model = (Model)Persistence.get$default(this, (PropertyContainer)object, null, null, 6, null);
        } else {
            model = null;
        }
        return (T)model;
    }

    public Persistence(@NotNull Service service, @NotNull ModelCache cache) {
        Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
        Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
        this.service = service;
        this.cache = cache;
        this.relationships = new Relationships(this.service, this);
        this.uuidGenerator = Generators.timeBasedGenerator();
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(Persistence.class);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lde/whitefrog/frogr/persistence/Persistence$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "frogr-base"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

