/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.patch;

import de.whitefrog.frogr.Service;
import de.whitefrog.frogr.patch.Version;

public abstract class Patch
implements Comparable<Patch> {
    private Service service;
    private final com.github.zafarkhaja.semver.Version version;
    private final int priority;

    public Patch(Service service) {
        this.service = service;
        this.version = com.github.zafarkhaja.semver.Version.valueOf((String)this.getClass().getAnnotation(Version.class).value());
        this.priority = this.getClass().getAnnotation(Version.class).priority();
    }

    public int getPriority() {
        return this.priority;
    }

    public Service getService() {
        return this.service;
    }

    public abstract void update();

    public com.github.zafarkhaja.semver.Version getVersion() {
        return this.version;
    }

    @Override
    public int compareTo(Patch o) {
        if (this.getVersion().greaterThan(o.getVersion()) || this.getPriority() < o.getPriority()) {
            return 1;
        }
        if (this.getVersion().equals((Object)o.getVersion()) && this.getPriority() == o.getPriority()) {
            return 0;
        }
        return -1;
    }
}

