/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.rest.service;

import com.codahale.metrics.MetricRegistry;
import de.whitefrog.frogr.Service;
import de.whitefrog.frogr.helper.ReflectionUtil;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.repository.Repository;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public abstract class RestService<Repo extends Repository<M>, M extends Model> {
    private static final Logger logger = LoggerFactory.getLogger(RestService.class);
    private Repo repository = null;
    private Class modelClass;
    public static final MetricRegistry metrics = new MetricRegistry();
    @Inject
    private Service service;

    public Service service() {
        return this.service;
    }

    public Repo repository() {
        if (this.repository == null) {
            try {
                this.repository = this.service().repository(this.getModelClass());
            }
            catch (ClassNotFoundException e) {
                logger.error("class for service {}", (Object)this.getClass().getName());
            }
        }
        return this.repository;
    }

    private Class getModelClass() throws ClassNotFoundException {
        if (this.modelClass == null) {
            Type[] parameterizedTypes = ReflectionUtil.getParameterizedTypes(this);
            this.modelClass = ReflectionUtil.getClass(parameterizedTypes[1]);
        }
        return this.modelClass;
    }
}

