/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.rest.service;

import com.codahale.metrics.Timer;
import com.fasterxml.jackson.annotation.JsonView;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.model.SaveContext;
import de.whitefrog.frogr.model.SearchParameter;
import de.whitefrog.frogr.rest.Views;
import de.whitefrog.frogr.rest.request.SearchParam;
import de.whitefrog.frogr.rest.response.Response;
import de.whitefrog.frogr.rest.service.DefaultRestService;
import io.dropwizard.validation.Validated;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.neo4j.graphdb.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json"})
public abstract class DefaultCRUDService<M extends Model>
extends DefaultRestService<M> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCRUDService.class);

    @POST
    public javax.ws.rs.core.Response create(List<M> models) {
        try (Transaction tx = this.service().beginTx();){
            for (Model model : models) {
                if (model.getPersisted()) {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                try {
                    this.repository().save(model);
                }
                catch (Exception e) {
                    logger.error("failed to save {}", (Object)model);
                    throw e;
                }
            }
            tx.success();
        }
        return javax.ws.rs.core.Response.status((Response.Status)Response.Status.CREATED).entity(Response.build(models)).build();
    }

    @PUT
    public List<M> update(List<M> models) {
        try (Transaction tx = this.service().beginTx();){
            for (Model model : models) {
                SaveContext<Model> context = new SaveContext<Model>(this.repository(), model);
                try {
                    this.repository().save(context);
                }
                catch (Exception e) {
                    logger.error("failed to update {}", (Object)model);
                    throw e;
                }
            }
            tx.success();
        }
        return models;
    }

    @GET
    @Path(value="{uuid: [a-zA-Z0-9]+}")
    @JsonView(value={Views.Public.class})
    public Model read(@PathParam(value="uuid") String uuid, @SearchParam SearchParameter params) {
        return (Model)this.search(params.uuids(uuid)).singleton();
    }

    @GET
    @JsonView(value={Views.Public.class})
    public Response<M> search(@SearchParam SearchParameter params) {
        Timer.Context timer = metrics.timer(this.repository().getModelClass().getSimpleName().toLowerCase() + ".search").time();
        Response response = new Response();
        try (Transaction ignored = this.service().beginTx();){
            SearchParameter paramsClone = params.clone();
            if (params.limit() > 0) {
                List list = this.repository().search().params(params).list();
                response.setData(list);
            }
            timer.stop();
            response.setSuccess(true);
            if (params.count()) {
                response.setTotal(this.repository().search().params(paramsClone).count());
            }
        }
        return response;
    }

    @POST
    @Path(value="search")
    @JsonView(value={Views.Public.class})
    public Response<M> searchPost(SearchParameter params) {
        return this.search(params);
    }

    @DELETE
    @Path(value="{uuid: [a-zA-Z0-9]+}")
    public void delete(@PathParam(value="uuid") String uuid) {
        try (Transaction tx = this.service().beginTx();){
            Model model = (Model)this.repository().findByUuid(uuid, new String[0]);
            if (model == null) {
                throw new NotFoundException();
            }
            this.repository().remove(model);
            tx.success();
        }
    }

    @POST
    @Path(value="authorize")
    public void authorize(@Validated Model model) {
    }
}

