/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.repository;

import de.whitefrog.frogr.Service;
import de.whitefrog.frogr.model.Graph;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;

public class GraphRepository {
    private Service service;
    private Graph graph = null;

    public GraphRepository(Service service) {
        this.service = service;
    }

    public Graph create() {
        if (this.getGraph() != null) {
            return this.graph;
        }
        return new Graph();
    }

    public Graph getGraph() {
        if (this.graph != null) {
            return this.graph;
        }
        Result results = this.service.graph().execute("match (n:Graph) return n");
        if (results.hasNext()) {
            Node node = (Node)results.next().get("n");
            this.graph = new Graph();
            if (node.hasProperty("version")) {
                this.graph.setVersion((String)node.getProperty("version"));
            }
        }
        return this.graph;
    }

    public void save(Graph graph) {
        if (this.graph != null) {
            Result results = this.service.graph().execute("match (n:Graph) return n");
            Node node = (Node)results.next().get("n");
            if (graph.getVersion() != null) {
                node.setProperty("version", (Object)graph.getVersion());
            }
        } else {
            Node node = this.service.graph().createNode(new Label[]{Label.label((String)"Graph")});
            if (graph.getVersion() != null) {
                node.setProperty("version", (Object)graph.getVersion());
            }
            this.graph = graph;
        }
    }
}

