/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.persistence;

import de.whitefrog.frogr.helper.ReflectionUtil;
import de.whitefrog.frogr.model.Base;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.model.annotation.Blob;
import de.whitefrog.frogr.model.annotation.Fetch;
import de.whitefrog.frogr.model.annotation.Indexed;
import de.whitefrog.frogr.model.annotation.Lazy;
import de.whitefrog.frogr.model.annotation.NotPersistent;
import de.whitefrog.frogr.model.annotation.NullRemove;
import de.whitefrog.frogr.model.annotation.RelatedTo;
import de.whitefrog.frogr.model.annotation.RelationshipCount;
import de.whitefrog.frogr.model.annotation.Required;
import de.whitefrog.frogr.model.annotation.Unique;
import de.whitefrog.frogr.model.annotation.Uuid;
import de.whitefrog.frogr.model.relationship.Relationship;
import de.whitefrog.frogr.persistence.AnnotationDescriptor;
import java.lang.reflect.Field;
import java.util.Collection;

public class FieldDescriptor<T extends Base> {
    private AnnotationDescriptor annotations;
    private Field field;
    private boolean collection;
    private boolean relationship;
    private Class<T> baseClass;

    FieldDescriptor(Field field) {
        field.setAccessible(true);
        this.field = field;
        this.collection = Collection.class.isAssignableFrom(field.getType());
        AnnotationDescriptor descriptor = new AnnotationDescriptor();
        descriptor.indexed = field.getAnnotation(Indexed.class);
        descriptor.notPersistent = field.isAnnotationPresent(NotPersistent.class);
        descriptor.relatedTo = field.getAnnotation(RelatedTo.class);
        descriptor.unique = field.isAnnotationPresent(Unique.class);
        descriptor.fetch = field.isAnnotationPresent(Fetch.class);
        descriptor.required = field.isAnnotationPresent(Required.class);
        descriptor.nullRemove = field.isAnnotationPresent(NullRemove.class);
        descriptor.blob = field.isAnnotationPresent(Blob.class);
        descriptor.uuid = field.isAnnotationPresent(Uuid.class);
        descriptor.lazy = field.isAnnotationPresent(Lazy.class);
        descriptor.relationshipCount = field.getAnnotation(RelationshipCount.class);
        this.annotations = descriptor;
        this.baseClass = this.collection ? ReflectionUtil.getGenericClass(field) : field.getType();
        this.relationship = Relationship.class.isAssignableFrom(this.baseClass);
    }

    public AnnotationDescriptor annotations() {
        return this.annotations;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public Class<T> baseClass() {
        return this.baseClass;
    }

    public Field field() {
        return this.field;
    }

    public String getName() {
        return this.field.getName();
    }

    public boolean isModel() {
        return Model.class.isAssignableFrom(this.baseClass);
    }

    public boolean isRelationship() {
        return this.relationship;
    }

    public String toString() {
        return "Field: \"" + this.getName() + "\"";
    }
}

