/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.model.relationship;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import de.whitefrog.frogr.exception.FrogrException;
import de.whitefrog.frogr.model.Base;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.model.annotation.Fetch;
import de.whitefrog.frogr.model.annotation.NotPersistent;
import de.whitefrog.frogr.model.annotation.Unique;
import de.whitefrog.frogr.model.annotation.Uuid;
import de.whitefrog.frogr.model.relationship.Relationship;
import de.whitefrog.frogr.rest.Views;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0016\u0018\u0000 N*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004:\u0001NB\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0007B\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u000bH\u0016J+\u0010;\u001a\u0002H<\"\b\b\u0002\u0010<*\u00020=2\u0012\u0010>\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0?\"\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010@J%\u0010;\u001a\u0002H<\"\b\b\u0002\u0010<*\u00020=2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u000b0AH\u0016\u00a2\u0006\u0002\u0010BJ\u0013\u0010C\u001a\u00020&2\b\u0010D\u001a\u0004\u0018\u00010EH\u0096\u0002J\u000f\u0010F\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010G\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u0002092\u0006\u0010J\u001a\u00020\u000bH\u0016J\b\u0010K\u001a\u000209H\u0016J\b\u0010L\u001a\u00020\u000bH\u0016J\n\u00100\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010M\u001a\u000209H\u0016R$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u000fR\u001c\u0010\u0005\u001a\u00028\u0000X\u0086.\u00a2\u0006\u0010\n\u0002\u0010\u001e\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR&\u0010 \u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00118V@VX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0012\u0010%\u001a\u00020&8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0014\u0010(\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R$\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\r\"\u0004\b-\u0010\u000fR\u001c\u0010\u0006\u001a\u00028\u0001X\u0086.\u00a2\u0006\u0010\n\u0002\u0010\u001e\u001a\u0004\b.\u0010\u001b\"\u0004\b/\u0010\u001dR \u00100\u001a\u0004\u0018\u00010\u000b8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R \u00105\u001a\u0004\u0018\u00010\u000b8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00102\"\u0004\b7\u00104\u00a8\u0006O"}, d2={"Lde/whitefrog/frogr/model/relationship/BaseRelationship;", "From", "Lde/whitefrog/frogr/model/Model;", "To", "Lde/whitefrog/frogr/model/relationship/Relationship;", "from", "to", "(Lde/whitefrog/frogr/model/Model;Lde/whitefrog/frogr/model/Model;)V", "()V", "checkedFields", "Ljava/util/HashSet;", "", "getCheckedFields", "()Ljava/util/HashSet;", "setCheckedFields", "(Ljava/util/HashSet;)V", "created", "", "getCreated", "()Ljava/lang/Long;", "setCreated", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "fetchedFields", "getFetchedFields", "setFetchedFields", "getFrom", "()Lde/whitefrog/frogr/model/Model;", "setFrom", "(Lde/whitefrog/frogr/model/Model;)V", "Lde/whitefrog/frogr/model/Model;", "value", "id", "getId", "()J", "setId", "(J)V", "initialId", "", "lastModified", "persisted", "getPersisted", "()Z", "removeProperties", "getRemoveProperties", "setRemoveProperties", "getTo", "setTo", "type", "getType", "()Ljava/lang/String;", "setType", "(Ljava/lang/String;)V", "uuid", "getUuid", "setUuid", "addCheckedField", "", "field", "clone", "T", "Lde/whitefrog/frogr/model/Base;", "fields", "", "([Ljava/lang/String;)Lde/whitefrog/frogr/model/Base;", "", "(Ljava/util/List;)Lde/whitefrog/frogr/model/Base;", "equals", "other", "", "getLastModified", "hashCode", "", "removeProperty", "property", "resetId", "toString", "updateLastModified", "Companion", "frogr-base"})
public class BaseRelationship<From extends Model, To extends Model>
implements Relationship<From, To> {
    @NotNull
    public From from;
    @NotNull
    public To to;
    @JsonView(value={Views.Hidden.class})
    private long id;
    @Uuid
    @Unique
    @Fetch
    @Nullable
    private String uuid;
    @Fetch
    @Nullable
    private String type;
    @Nullable
    private Long created;
    @JsonView(value={Views.Secure.class})
    private Long lastModified;
    @NotPersistent
    private boolean initialId;
    @NotPersistent
    @JsonIgnore
    @NotNull
    private HashSet<String> checkedFields;
    @NotPersistent
    @JsonIgnore
    @NotNull
    private HashSet<String> fetchedFields;
    @NotPersistent
    @JsonIgnore
    @NotNull
    private HashSet<String> removeProperties;
    @NotNull
    public static final String AllFields = "all";
    @NotNull
    public static final String IdProperty = "id";
    @NotNull
    public static final String LastModified = "lastModified";
    @NotNull
    public static final String Created = "created";
    @NotNull
    public static final String Type = "type";
    @NotNull
    public static final String Uuid = "uuid";
    private static final Random random;
    public static final Companion Companion;

    @Override
    @NotNull
    public final From getFrom() {
        From From = this.from;
        if (From == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"from");
        }
        return From;
    }

    @Override
    public final void setFrom(@NotNull From From) {
        Intrinsics.checkParameterIsNotNull(From, (String)"<set-?>");
        this.from = From;
    }

    @Override
    @NotNull
    public final To getTo() {
        To To = this.to;
        if (To == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"to");
        }
        return To;
    }

    @Override
    public final void setTo(@NotNull To To) {
        Intrinsics.checkParameterIsNotNull(To, (String)"<set-?>");
        this.to = To;
    }

    @Override
    public long getId() {
        return this.initialId ? -1L : this.id;
    }

    @Override
    public void setId(long value) {
        this.id = value;
        this.initialId = false;
    }

    @Override
    @Nullable
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public void setUuid(@Nullable String string) {
        this.uuid = string;
    }

    @Override
    @Nullable
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(@Nullable String string) {
        this.type = string;
    }

    @Override
    @Nullable
    public Long getCreated() {
        return this.created;
    }

    @Override
    public void setCreated(@Nullable Long l) {
        this.created = l;
    }

    @Override
    @NotNull
    public HashSet<String> getCheckedFields() {
        return this.checkedFields;
    }

    @Override
    public void setCheckedFields(@NotNull HashSet<String> hashSet) {
        Intrinsics.checkParameterIsNotNull(hashSet, (String)"<set-?>");
        this.checkedFields = hashSet;
    }

    @Override
    @NotNull
    public HashSet<String> getFetchedFields() {
        return this.fetchedFields;
    }

    @Override
    public void setFetchedFields(@NotNull HashSet<String> hashSet) {
        Intrinsics.checkParameterIsNotNull(hashSet, (String)"<set-?>");
        this.fetchedFields = hashSet;
    }

    @Override
    @NotNull
    public HashSet<String> getRemoveProperties() {
        return this.removeProperties;
    }

    @Override
    public void setRemoveProperties(@NotNull HashSet<String> hashSet) {
        Intrinsics.checkParameterIsNotNull(hashSet, (String)"<set-?>");
        this.removeProperties = hashSet;
    }

    @Override
    public void resetId() {
        this.setId(BaseRelationship.Companion.getRandom().nextLong());
        this.initialId = true;
    }

    @Override
    @Nullable
    public String type() {
        return this.getType();
    }

    @Override
    public void addCheckedField(@NotNull String field) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        this.getCheckedFields().add(field);
    }

    @Override
    public void removeProperty(@NotNull String property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        this.getRemoveProperties().add(property);
    }

    @Override
    @Nullable
    public Long getLastModified() {
        return this.lastModified;
    }

    @Override
    public void updateLastModified() {
        this.lastModified = System.currentTimeMillis();
    }

    @Override
    public boolean getPersisted() {
        return this.getId() > (long)-1 || this.getUuid() != null;
    }

    @Override
    @NotNull
    public <T extends Base> T clone(String ... fields) {
        Intrinsics.checkParameterIsNotNull((Object)fields, (String)"fields");
        List<String> list = Arrays.asList(Arrays.copyOf(fields, fields.length));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(*fields)");
        return this.clone(list);
    }

    @Override
    @NotNull
    public <T extends Base> T clone(@NotNull List<String> fields) {
        Base base;
        Intrinsics.checkParameterIsNotNull(fields, (String)"fields");
        try {
            Object obj = this.getClass().newInstance();
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            base = (Base)obj;
        }
        catch (ReflectiveOperationException e) {
            throw (Throwable)new FrogrException(e.getMessage(), e);
        }
        base.setType(this.type());
        if (fields.isEmpty() || fields.contains(IdProperty) && this.getId() > (long)-1) {
            base.setId(this.getId());
        }
        return (T)base;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Relationship)) {
            return false;
        }
        BaseRelationship base = (BaseRelationship)other;
        if (this.getUuid() != null && base.getUuid() != null && Intrinsics.areEqual((Object)this.getUuid(), (Object)base.getUuid()) ^ true) {
            return false;
        }
        if (this.initialId) {
            return false;
        }
        if (this.getId() != base.getId()) {
            return false;
        }
        return !(Intrinsics.areEqual(this.getClass(), base.getClass()) ^ true);
    }

    public int hashCode() {
        return new HashCodeBuilder(21, 41).append(this.getId()).toHashCode();
    }

    @NotNull
    public String toString() {
        String typeName = this.type() != null ? this.type() : this.getClass().getSimpleName();
        return "" + typeName + " (" + this.getId() + ')';
    }

    public BaseRelationship() {
        this.id = BaseRelationship.Companion.getRandom().nextLong();
        this.initialId = true;
        this.checkedFields = new HashSet();
        this.fetchedFields = new HashSet();
        this.removeProperties = new HashSet();
    }

    public BaseRelationship(@NotNull From from, @NotNull To to) {
        Intrinsics.checkParameterIsNotNull(from, (String)"from");
        Intrinsics.checkParameterIsNotNull(to, (String)"to");
        this();
        this.from = from;
        this.to = to;
    }

    static {
        Companion = new Companion(null);
        random = new Random();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lde/whitefrog/frogr/model/relationship/BaseRelationship$Companion;", "", "()V", "AllFields", "", "Created", "IdProperty", "LastModified", "Type", "Uuid", "random", "Ljava/util/Random;", "getRandom", "()Ljava/util/Random;", "frogr-base"})
    public static final class Companion {
        private final Random getRandom() {
            return random;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

