/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.cypher;

import de.whitefrog.frogr.cypher.FieldParser;
import de.whitefrog.frogr.cypher.MatchBuilder;
import de.whitefrog.frogr.cypher.Query;
import de.whitefrog.frogr.helper.ReflectionUtil;
import de.whitefrog.frogr.model.Filter;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.model.SearchParameter;
import de.whitefrog.frogr.model.relationship.Relationship;
import de.whitefrog.frogr.persistence.AnnotationDescriptor;
import de.whitefrog.frogr.persistence.FieldDescriptor;
import de.whitefrog.frogr.persistence.ModelCache;
import de.whitefrog.frogr.persistence.Persistence;
import de.whitefrog.frogr.repository.RelationshipRepository;
import de.whitefrog.frogr.repository.Repository;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.neo4j.graphdb.Direction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(QueryBuilder.class);
    private Repository repository;
    private final Map<String, Object> queryParams = new HashMap<String, Object>();
    private SearchParameter params;
    private final String type;
    private final Map<String, String> matches = new HashMap<String, String>();
    private final List<String> queryFields = new ArrayList<String>();
    private final Persistence persistence;
    private final FieldParser fieldParser;

    public QueryBuilder(Repository repository) {
        this.repository = repository;
        this.persistence = repository.service().persistence();
        this.type = repository.getModelClass().getSimpleName();
        this.fieldParser = new FieldParser(repository);
        this.persistence.cache().fieldMap(repository.getModelClass()).forEach(descriptor -> {
            if (descriptor.annotations().indexed != null || descriptor.annotations().unique) {
                this.queryFields.add(descriptor.field().getName());
            }
        });
    }

    public Repository repository() {
        return this.repository;
    }

    public String id() {
        return this.repository().queryIdentifier();
    }

    private StringBuilder match() {
        for (SearchParameter.OrderBy order : this.params.orderBy()) {
            if (order.field().contains(".") || this.matches.keySet().contains(order.field())) continue;
            AnnotationDescriptor descriptor = this.persistence.cache().fieldAnnotations(this.repository().getModelClass(), order.field());
            if (descriptor.relationshipCount == null) continue;
            MatchBuilder match = new MatchBuilder().relationship(order.field()).relationshipType(descriptor.relationshipCount.type());
            if (descriptor.relationshipCount.direction().equals((Object)Direction.OUTGOING) || descriptor.relationshipCount.direction().equals((Object)Direction.BOTH)) {
                match.from(this.id()).fromLabel(this.type);
                if (!descriptor.relationshipCount.otherModel().equals(Model.class)) {
                    match.toLabel(descriptor.relationshipCount.otherModel().getSimpleName());
                }
            } else {
                match.to(this.id()).toLabel(this.type);
                if (!descriptor.relationshipCount.otherModel().equals(Model.class)) {
                    match.fromLabel(descriptor.relationshipCount.otherModel().getSimpleName());
                }
            }
            if (descriptor.relationshipCount.direction().equals((Object)Direction.BOTH)) {
                match.undirected();
            }
            this.matches.put(order.field(), match.build());
        }
        for (Filter filter : this.params.filters()) {
            String fieldName = filter.getProperty();
            if (fieldName.contains(".")) {
                fieldName = fieldName.substring(0, fieldName.indexOf("."));
            }
            if (this.matches.keySet().contains(fieldName)) continue;
            this.generateFilterMatch(filter, this.repository().getModelClass(), this.id(), fieldName);
        }
        for (String returns : this.params.returns()) {
            AnnotationDescriptor descriptor;
            String returnsKey = returns.contains(" ") ? returns.substring(0, returns.indexOf(" ")) : returns;
            if (this.matches.containsKey(returnsKey) || (descriptor = this.persistence.cache().fieldAnnotations(this.repository().getModelClass(), returnsKey)) == null || descriptor.relatedTo == null) continue;
            boolean isRelationship = false;
            try {
                Field field = ModelCache.getField(this.repository().getModelClass(), returnsKey);
                isRelationship = Collection.class.isAssignableFrom(field.getType()) ? Relationship.class.isAssignableFrom(ReflectionUtil.getGenericClass(field)) : Relationship.class.isAssignableFrom(field.getType());
            }
            catch (NoSuchFieldException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            MatchBuilder match = new MatchBuilder().relationshipType(descriptor.relatedTo.type());
            if (isRelationship) {
                match.relationship(returnsKey);
            }
            if (descriptor.relatedTo.direction().equals((Object)Direction.OUTGOING) || descriptor.relatedTo.direction().equals((Object)Direction.BOTH)) {
                match.from(this.id()).fromLabel(this.type);
                if (!isRelationship) {
                    match.to(returnsKey);
                }
            } else {
                match.to(this.id()).toLabel(this.type);
                if (!isRelationship) {
                    match.from(returnsKey);
                }
            }
            if (descriptor.relatedTo.direction().equals((Object)Direction.BOTH)) {
                match.undirected();
            }
            this.matches.put(returnsKey, match.build());
        }
        if (this.matches.isEmpty()) {
            if (this.repository() instanceof RelationshipRepository) {
                return new StringBuilder("match ()-[" + this.id() + ":" + this.type + "]-() ");
            }
            return new StringBuilder("match (" + this.id() + ":" + this.type + ") ");
        }
        return new StringBuilder("match ").append(StringUtils.join(this.matches.values(), (String)", ")).append(" ");
    }

    private void generateFilterMatch(Filter filter, Class<?> clazz, String id, String fieldName) {
        MatchBuilder match = new MatchBuilder();
        FieldDescriptor descriptor = this.persistence.cache().fieldDescriptor(clazz, fieldName);
        if (descriptor == null) {
            for (Class sub : this.persistence.cache().subTypesOf(clazz)) {
                descriptor = this.persistence.cache().fieldDescriptor(sub, fieldName);
                if (descriptor == null) continue;
                break;
            }
            if (descriptor == null) {
                logger.warn("the field for filter {} could not be found", (Object)filter.getProperty());
                return;
            }
        }
        AnnotationDescriptor annotations = descriptor.annotations();
        String className = descriptor.baseClass().getSimpleName();
        if (annotations.relatedTo != null) {
            String sub;
            if (annotations.relatedTo.direction().equals((Object)Direction.OUTGOING) || annotations.relatedTo.direction().equals((Object)Direction.BOTH)) {
                match.from(id);
                if (id.equals(this.id())) {
                    match.fromLabel(this.type);
                }
                if (descriptor.isRelationship()) {
                    match.to(fieldName + "_to");
                } else {
                    match.to(fieldName).toLabel(className);
                }
            } else {
                match.to(id);
                if (id.equals(this.id())) {
                    match.toLabel(this.type);
                }
                if (descriptor.isRelationship()) {
                    match.from(fieldName + "_from");
                } else {
                    match.from(fieldName).fromLabel(className);
                }
            }
            if (annotations.relatedTo.direction().equals((Object)Direction.BOTH)) {
                match.undirected();
            }
            match.relationshipType(annotations.relatedTo.type());
            if (descriptor.isRelationship()) {
                match.relationship(fieldName);
            }
            if ((sub = filter.getProperty().substring(fieldName.length() + filter.getProperty().indexOf(fieldName) + 1)).contains(".")) {
                this.generateFilterMatch(filter, descriptor.baseClass(), fieldName, sub.substring(0, sub.indexOf(".")));
            }
            this.matches.put(fieldName, match.build());
        }
    }

    private StringBuilder where() {
        LinkedList<String> wheres = new LinkedList<String>();
        if (this.params.isFiltered()) {
            int i = 0;
            for (Filter filter : this.params.filters()) {
                String including;
                String where;
                String lookup = filter.getProperty();
                boolean lowerCaseIndex = this.fieldParser.isLowerCase(lookup);
                if (lookup.contains(".to.") && this.persistence.cache().fieldDescriptor(this.repository().getModelClass(), "to") == null) {
                    lookup = lookup.replace(".to", "_to");
                }
                if (lookup.contains(".from.") && this.persistence.cache().fieldDescriptor(this.repository().getModelClass(), "from") == null) {
                    lookup = lookup.replace(".from", "_from");
                }
                String[] split = lookup.split("\\.");
                String string = lookup = !lookup.contains(".") ? this.id() + "." + lookup : split[split.length - 2] + "." + split[split.length - 1];
                if (lowerCaseIndex) {
                    lookup = lookup + "_lower";
                }
                String marker = filter.getProperty().replaceAll("\\.", "") + i;
                Object value = filter.getValue();
                if (value != null && value instanceof Date) {
                    value = ((Date)value).getTime();
                }
                if (value != null && value instanceof String && lowerCaseIndex) {
                    value = ((String)value).toLowerCase();
                }
                if (filter instanceof Filter.Equals) {
                    if (value == null) {
                        wheres.add(lookup + " IS NULL");
                    } else {
                        where = "(";
                        if (value instanceof Boolean) {
                            where = value == Boolean.TRUE ? where + lookup + " IS NOT NULL AND " : where + lookup + " IS NULL OR ";
                        }
                        where = where + lookup + " = {" + marker + "})";
                        wheres.add(where);
                        this.queryParams.put(marker, value);
                    }
                } else if (filter instanceof Filter.StartsWith) {
                    wheres.add(lookup + " starts with {" + marker + "}");
                    this.queryParams.put(marker, value);
                } else if (filter instanceof Filter.EndsWith) {
                    wheres.add(lookup + " ends with {" + marker + "}");
                    this.queryParams.put(marker, value);
                } else if (filter instanceof Filter.Contains) {
                    wheres.add(lookup + " contains {" + marker + "}");
                    this.queryParams.put(marker, value);
                } else if (filter instanceof Filter.NotEquals) {
                    if (value == null) {
                        wheres.add(lookup + " IS NOT NULL");
                    } else {
                        where = "(" + lookup + " <> {" + marker + "}";
                        if (value instanceof Boolean) {
                            where = where + "OR " + lookup + " IS " + (value == Boolean.FALSE ? "NOT" : "") + " NULL";
                        }
                        wheres.add(where + ")");
                        this.queryParams.put(marker, value);
                    }
                } else if (filter instanceof Filter.GreaterThan) {
                    including = ((Filter.GreaterThan)filter).isIncluding() ? "=" : "";
                    wheres.add(lookup + " >" + including + " {" + marker + "}");
                    this.queryParams.put(marker, value);
                } else if (filter instanceof Filter.LessThan) {
                    including = ((Filter.LessThan)filter).isIncluding() ? "=" : "";
                    wheres.add(lookup + " <" + including + " {" + marker + "}");
                    this.queryParams.put(marker, value);
                } else if (filter instanceof Filter.Range) {
                    including = ((Filter.Range)filter).isIncluding() ? "=" : "";
                    Filter.Range range = (Filter.Range)filter;
                    wheres.add(lookup + " >" + including + " {" + marker + "_from}");
                    wheres.add(lookup + " <" + including + " {" + marker + "_to}");
                    this.queryParams.put(marker + "_from", range.getFrom());
                    this.queryParams.put(marker + "_to", range.getTo());
                }
                ++i;
            }
        }
        if (this.params.query() != null) {
            if (this.params.query().contains(":")) {
                String[] split = this.params.query().split(":", 2);
                String field = split[0].trim();
                String query = split[1].trim();
                if (this.fieldParser.isLowerCase(field)) {
                    field = field + "_lower";
                }
                if (query.isEmpty()) {
                    throw new IllegalArgumentException("empty queries not allowed: \"" + this.params.query() + "\"");
                }
                String comparator = this.getQueryComparator(query);
                wheres.add(MessageFormat.format("{0}.{1} {2} '{'query'}'", this.id(), field, comparator));
                this.queryParams.put("query", query.replaceAll("\\*", ""));
            } else {
                if (this.params.query().isEmpty()) {
                    throw new IllegalArgumentException("empty queries not allowed: \"" + this.params.query() + "\"");
                }
                String comparator = this.getQueryComparator(this.params.query());
                LinkedList<String> queries = new LinkedList<String>();
                for (String queryField : this.queryFields) {
                    if (this.fieldParser.isLowerCase(queryField)) {
                        queryField = queryField + "_lower";
                    }
                    queries.add(MessageFormat.format("{0}.{1} {2} '{'query'}'", this.id(), queryField, comparator));
                }
                wheres.add("(" + StringUtils.join(queries, (String)" OR ") + ")");
                this.queryParams.put("query", this.params.query().replaceAll("\\*", ""));
            }
        }
        if (!CollectionUtils.isEmpty(this.params.ids())) {
            LinkedList<String> queries = new LinkedList<String>();
            int index = 1;
            for (Long id : this.params.ids()) {
                queries.add("id(" + this.id() + ") = {id_" + index + "}");
                this.queryParams.put("id_" + index++, id);
            }
            wheres.add("(" + StringUtils.join(queries, (String)" OR ") + ")");
        }
        if (!CollectionUtils.isEmpty(this.params.uuids())) {
            LinkedList<String> queries = new LinkedList<String>();
            int index = 1;
            for (String uuid : this.params.uuids()) {
                queries.add(this.id() + ".uuid = {uuid_" + index + "}");
                this.queryParams.put("uuid_" + index++, uuid);
            }
            wheres.add("(" + StringUtils.join(queries, (String)" OR ") + ")");
        }
        if (!wheres.isEmpty()) {
            return new StringBuilder("where ").append(StringUtils.join(wheres, (String)" AND ")).append(" ");
        }
        return new StringBuilder();
    }

    private String getQueryComparator(String query) {
        if (query.startsWith("*") && !query.endsWith("*")) {
            return "ends with";
        }
        if (query.startsWith("*") && query.endsWith("*")) {
            return "contains";
        }
        if (query.endsWith("*")) {
            return "starts with";
        }
        return "=";
    }

    private StringBuilder orderBy() {
        StringBuilder query = new StringBuilder();
        if (!this.params.orderBy().isEmpty()) {
            LinkedList<String> orders = new LinkedList<String>();
            for (SearchParameter.OrderBy order : this.params.orderBy()) {
                if (!order.field().contains(".") && this.persistence.cache().fieldAnnotations(this.repository().getModelClass(), (String)order.field()).relationshipCount != null) {
                    orders.add("count(" + order.field() + ") " + order.dir());
                    continue;
                }
                if (order.field().contains(".")) {
                    orders.add(order.field() + " " + order.dir());
                    continue;
                }
                orders.add(this.id() + "." + order.field() + " " + order.dir());
            }
            query.append(" order by ").append(StringUtils.join(orders, (String)", ")).append(" ");
        }
        return query;
    }

    private StringBuilder returns() {
        LinkedList<String> ret = new LinkedList<String>();
        if (CollectionUtils.isEmpty(this.params.returns())) {
            ret.add(this.id());
        } else {
            ArrayList<String> returns = new ArrayList<String>(this.params.returns());
            List parsed = returns.stream().map(r -> {
                if (r.contains(".")) {
                    return r.replace(".", "_");
                }
                FieldDescriptor descriptor = this.persistence.cache().fieldDescriptor(this.repository().getModelClass(), (String)r);
                if (!this.id().equals(r) && descriptor.isCollection() && returns.size() > 1) {
                    r = "collect(" + r + ") as " + r;
                }
                return r;
            }).collect(Collectors.toList());
            ret.add(StringUtils.join(parsed, (String)","));
        }
        for (SearchParameter.OrderBy order : this.params.orderBy()) {
            if (order.field().contains(".")) continue;
            AnnotationDescriptor descriptor = this.persistence.cache().fieldAnnotations(this.repository().getModelClass(), order.field());
            if (descriptor.relationshipCount == null) continue;
            ret.add("count(" + order.field() + ") as " + order.field() + "_c");
        }
        return new StringBuilder("return ").append(StringUtils.join(ret, (String)", ")).append(" ");
    }

    private StringBuilder paging() {
        StringBuilder query = new StringBuilder();
        if (this.params.page() > 1) {
            query.append("skip {skip} ");
            this.queryParams.put("skip", (this.params.page() - 1) * this.params.limit());
        }
        if (this.params.limit() < Integer.MAX_VALUE) {
            query.append("limit {limit}");
            this.queryParams.put("limit", this.params.limit());
        }
        return query;
    }

    public Query build(SearchParameter params) {
        this.params = params;
        StringBuilder query = this.match().append((CharSequence)this.where()).append((CharSequence)this.returns()).append((CharSequence)this.orderBy()).append((CharSequence)this.paging());
        return new Query(query.toString(), this.queryParams);
    }

    public Query buildSimple(SearchParameter params) {
        this.params = params;
        StringBuilder query = this.match().append((CharSequence)this.where());
        return new Query(query.toString(), this.queryParams);
    }
}

