/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr;

import de.whitefrog.frogr.Application;
import de.whitefrog.frogr.exception.FrogrException;
import de.whitefrog.frogr.model.Base;
import de.whitefrog.frogr.model.Graph;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.model.annotation.IndexType;
import de.whitefrog.frogr.patch.Patcher;
import de.whitefrog.frogr.persistence.AnnotationDescriptor;
import de.whitefrog.frogr.persistence.FieldDescriptor;
import de.whitefrog.frogr.persistence.Persistence;
import de.whitefrog.frogr.repository.GraphRepository;
import de.whitefrog.frogr.repository.ModelRepository;
import de.whitefrog.frogr.repository.Repository;
import de.whitefrog.frogr.repository.RepositoryFactory;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Service
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Service.class);
    private static final String snapshotSuffix = "-SNAPSHOT";
    public static final String noVersion = "0.0.0";
    private GraphDatabaseService graphDb;
    private GraphRepository graphRepository;
    private Graph graph;
    private RepositoryFactory repositoryFactory;
    private Set<String> packageRegistry = new HashSet<String>();
    private Validator validator;
    private String neo4jConfig = "config/neo4j.properties";
    private State state = State.Started;
    private Persistence persistence;
    private String directory;

    public Service() {
        Locale.setDefault(Locale.GERMAN);
        this.register("de.whitefrog.frogr.model");
        this.register("de.whitefrog.frogr.repository");
    }

    public Transaction beginTx() {
        return this.graph().beginTx();
    }

    public void connect() {
        if (this.isConnected()) {
            throw new FrogrException("already running");
        }
        this.state = State.Connecting;
        this.graphDb = this.createGraphDatabase();
        this.persistence = new Persistence(this);
        this.repositoryFactory = new RepositoryFactory(this);
        this.graphRepository = new GraphRepository(this);
        String version = this.getManifestVersion();
        try (Transaction tx = this.beginTx();){
            this.graph = this.graphRepository.getGraph();
            if (logger.isInfoEnabled()) {
                String outputVersion = this.graph == null ? version : (this.graph.getVersion() != null ? this.graph.getVersion() : "");
                logger.info("Creating database instance {}", (Object)outputVersion);
                if (this.directory != null) {
                    logger.info("Graph location: {}", (Object)new File(this.directory).getAbsolutePath());
                }
            }
            tx.success();
        }
        this.initializeSchema();
        Patcher.patch(this);
        tx = this.beginTx();
        var3_3 = null;
        try {
            if (this.graph == null) {
                this.graph = this.graphRepository.create();
            }
            this.graph.setVersion(version);
            this.graphRepository.save(this.graph);
            logger.debug("graph node created");
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Service.registerShutdownHook(this);
        this.state = State.Running;
    }

    protected GraphDatabaseService createGraphDatabase() {
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(this.neo4jConfig);
            this.directory = config.containsKey("graph.location") ? config.getString("graph.location") : "graph.db";
            File file = new File(this.directory);
            GraphDatabaseBuilder builder = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(file).loadPropertiesFromURL(config.getURL());
            return builder.newGraphDatabase();
        }
        catch (ConfigurationException e) {
            if (!e.getMessage().startsWith("Cannot locate")) {
                throw new FrogrException(e.getMessage(), e);
            }
            this.directory = "graph.db";
            File file = new File(this.directory);
            logger.info("No neo4j.properties found, creating graph in {}", (Object)file.getAbsolutePath());
            GraphDatabaseBuilder builder = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(file);
            return builder.newGraphDatabase();
        }
    }

    public boolean isConnected() {
        return Arrays.asList(State.Connecting, State.Running, State.ShuttingDown).contains((Object)this.state);
    }

    public void setConfig(String configFile) {
        this.neo4jConfig = configFile;
    }

    public String getVersion() {
        return this.graph != null ? this.graph.getVersion() : noVersion;
    }

    public void setVersion(String version) {
        if (this.graph == null) {
            return;
        }
        try (Transaction tx = this.beginTx();){
            this.graph.setVersion(version);
            this.graphRepository.save(this.graph);
            tx.success();
        }
    }

    public State getState() {
        return this.state;
    }

    public Persistence persistence() {
        return this.persistence;
    }

    public Set<String> registry() {
        return this.packageRegistry;
    }

    public void register(String name) {
        this.packageRegistry.add(name);
    }

    private static void registerShutdownHook(Service service) {
        Runtime.getRuntime().addShutdownHook(new Thread(service::shutdown));
    }

    public <R extends Repository<T>, T extends Base> R repository(Class<T> clazz) {
        if (!this.isConnected()) {
            throw new FrogrException("service is not running");
        }
        return (R)this.repositoryFactory().get(clazz);
    }

    public <R extends Repository> R repository(String name) {
        if (!this.isConnected()) {
            throw new FrogrException("service is not running");
        }
        return (R)this.repositoryFactory().get(name);
    }

    public RepositoryFactory repositoryFactory() {
        if (!this.isConnected()) {
            throw new FrogrException("service is not running");
        }
        return this.repositoryFactory;
    }

    public GraphDatabaseService graph() {
        if (!this.isConnected()) {
            throw new FrogrException("service is not running");
        }
        return this.graphDb;
    }

    public synchronized String getManifestVersion() {
        String version = null;
        if (this.getMainClass() != null) {
            version = this.getMainClass().getPackage().getImplementationVersion();
        }
        if (version == null) {
            version = System.getProperty("version", noVersion);
        }
        if (version.endsWith(snapshotSuffix)) {
            version = version.replace(snapshotSuffix, "");
        }
        return version;
    }

    private Class getMainClass() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = stackTrace.length - 1; i >= 0; --i) {
            try {
                Class<?> caller = Class.forName(stackTrace[i].getClassName());
                if (Application.class.isAssignableFrom(caller)) {
                    return caller;
                }
                if (!Service.class.isAssignableFrom(caller)) continue;
                return caller;
            }
            catch (ClassNotFoundException e) {
                logger.debug("error reading stack trace", (Throwable)e);
            }
        }
        return this.getClass();
    }

    private void initializeSchema() {
        try (Transaction tx = this.beginTx();){
            Schema schema = this.graph().schema();
            for (Class modelClass : this.persistence.cache().getAllModels()) {
                if (!Model.class.isAssignableFrom(modelClass) || Modifier.isAbstract(modelClass.getModifiers())) continue;
                if (!Base.class.isAssignableFrom(modelClass)) {
                    throw new FrogrException("model class " + modelClass.getName() + " is not of type Base");
                }
                ModelRepository repository = (ModelRepository)this.repository(modelClass);
                List constraints = Iterables.asList((Iterable)schema.getConstraints(repository.label()));
                List indices = Iterables.asList((Iterable)schema.getIndexes(repository.label()));
                for (FieldDescriptor descriptor : this.persistence.cache().fieldMap(modelClass)) {
                    AnnotationDescriptor annotations = descriptor.annotations();
                    ConstraintDefinition existingConstraint = null;
                    String indexName = descriptor.getName() + (annotations.indexed != null && annotations.indexed.type().equals((Object)IndexType.LowerCase) ? "_lower" : "");
                    for (ConstraintDefinition constraint : constraints) {
                        String property = (String)Iterables.single((Iterable)constraint.getPropertyKeys());
                        if (!property.equals(indexName)) continue;
                        existingConstraint = constraint;
                        break;
                    }
                    IndexDefinition existingIndex = null;
                    for (IndexDefinition index : indices) {
                        String property = (String)Iterables.single((Iterable)index.getPropertyKeys());
                        if (!property.equals(indexName)) continue;
                        existingIndex = index;
                        break;
                    }
                    if (annotations.unique && existingConstraint == null) {
                        schema.constraintFor(repository.label()).assertPropertyIsUnique(indexName).create();
                        logger.debug("created unique constraint on field \"{}\" for model \"{}\"", (Object)descriptor.getName(), (Object)repository.getModelClass().getSimpleName());
                    } else if (!annotations.unique && existingConstraint != null) {
                        existingConstraint.drop();
                        logger.debug("dropped unique constraint on field \"{}\" for model \"{}\"", (Object)descriptor.getName(), (Object)repository.getModelClass().getSimpleName());
                    }
                    if (annotations.indexed != null && !annotations.unique && existingIndex == null) {
                        schema.indexFor(repository.label()).on(indexName).create();
                        logger.debug("created {} index on field \"{}\" for model \"{}\"", new Object[]{annotations.indexed.type(), descriptor.getName(), repository.getModelClass().getSimpleName()});
                        continue;
                    }
                    if (annotations.indexed != null || annotations.unique || existingIndex == null) continue;
                    existingIndex.drop();
                    logger.debug("dropped index on field \"{}\" for model \"{}\"", (Object)descriptor.getName(), (Object)repository.getModelClass().getSimpleName());
                }
            }
            tx.success();
        }
    }

    public Validator validator() {
        if (this.validator == null) {
            this.validator = Validation.buildDefaultValidatorFactory().getValidator();
        }
        return this.validator;
    }

    @Override
    public void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.state = State.ShuttingDown;
        this.repositoryFactory().cache().forEach(Repository::dispose);
        if (this.graphDb != null) {
            this.graphDb.shutdown();
        }
        this.state = State.Started;
    }

    public static enum State {
        Started,
        Connecting,
        Running,
        ShuttingDown;

    }
}

