/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.rest.request;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.whitefrog.frogr.model.FieldList;
import de.whitefrog.frogr.model.Filter;
import de.whitefrog.frogr.model.SearchParameter;
import de.whitefrog.frogr.rest.request.SearchParam;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.model.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SearchParameterResolver
extends AbstractValueFactoryProvider {
    private static final Logger logger = LoggerFactory.getLogger(SearchParameterResolver.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private SearchParameterValueFactory factory = new SearchParameterValueFactory();
    public static final String ParameterName = "params";

    @Inject
    public SearchParameterResolver(MultivaluedParameterExtractorProvider mpep, ServiceLocator injector) {
        super(mpep, injector, new Parameter.Source[]{Parameter.Source.UNKNOWN});
    }

    public AbstractContainerRequestValueFactory<?> createValueFactory(Parameter parameter) {
        Class classType = parameter.getRawType();
        SearchParam annotation = (SearchParam)parameter.getAnnotation(SearchParam.class);
        if (annotation != null && classType.isAssignableFrom(SearchParameter.class)) {
            return this.factory;
        }
        return null;
    }

    public static SearchParameter resolve(String params) {
        try {
            params = MimeUtility.decodeText((String)params);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            String[] splits;
            if (params.startsWith("{")) {
                return (SearchParameter)mapper.readValue(params, SearchParameter.class);
            }
            SearchParameter searchParamter = new SearchParameter();
            for (String split : splits = params.split(";")) {
                String[] splitted = split.split(":");
                SearchParameterResolver.resolveParameter(searchParamter, splitted[0], splitted[1]);
            }
            return searchParamter;
        }
        catch (IOException | ArrayIndexOutOfBoundsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(params + " is not parsable");
        }
    }

    public static void resolveParameter(SearchParameter params, String key, String value) {
        switch (key) {
            case "q": {
                params.query(value);
                break;
            }
            case "uuids": {
                String[] split = value.split(",");
                params.uuids(Arrays.asList(split));
                break;
            }
            case "count": {
                params.count(true);
                break;
            }
            case "start": {
                params.start(Integer.parseInt(value));
                break;
            }
            case "limit": {
                params.limit(Integer.parseInt(value));
                break;
            }
            case "page": {
                params.page(Integer.parseInt(value));
                break;
            }
            case "locale": {
                params.locale(new Locale(value));
                break;
            }
            case "order": 
            case "orderBy": 
            case "sort": {
                SearchParameterResolver.resolveOrder(params, value);
                break;
            }
            case "filter": 
            case "filters": {
                SearchParameterResolver.resolveFilter(params, value);
                break;
            }
            case "fields": {
                params.fields(SearchParameterResolver.resolveFields(value));
                break;
            }
            case "returns": 
            case "return": {
                params.returns(value);
            }
        }
    }

    private static FieldList resolveFields(String value) {
        return FieldList.parseFields(value);
    }

    private static void resolveOrder(SearchParameter params, String value) {
        String[] splits;
        for (String split : splits = value.split(",")) {
            SearchParameter.SortOrder dir = SearchParameter.SortOrder.ASC;
            if (split.startsWith("-")) {
                dir = SearchParameter.SortOrder.DESC;
                split = split.substring(1);
            } else if (split.startsWith("+") || split.startsWith(" ")) {
                split = split.substring(1);
            }
            params.orderBy(split, dir);
        }
    }

    private static void resolveFilter(SearchParameter params, String filterString) {
        String[] splits;
        for (String split : splits = filterString.split(",")) {
            Filter.Default filter;
            String[] splitted = split.split(":");
            String field = splitted[0];
            String value = splitted[1];
            if (value.startsWith("!")) {
                filter = new Filter.NotEquals(field, SearchParameterResolver.guessType(value.substring(1)));
            } else if (value.startsWith("<")) {
                if (value.substring(1, 2).equals("=")) {
                    filter = new Filter.LessThan(field, Long.parseLong(value.substring(2)));
                    ((Filter.LessThan)filter).setIncluding(true);
                } else {
                    filter = new Filter.LessThan(field, Long.parseLong(value.substring(1)));
                    ((Filter.LessThan)filter).setIncluding(false);
                }
            } else if (value.startsWith(">")) {
                if (value.substring(1, 2).equals("=")) {
                    filter = new Filter.GreaterThan(field, Long.parseLong(value.substring(2)));
                    ((Filter.GreaterThan)filter).setIncluding(true);
                } else {
                    filter = new Filter.GreaterThan(field, Long.parseLong(value.substring(1)));
                    ((Filter.GreaterThan)filter).setIncluding(false);
                }
            } else if (value.startsWith("(") && value.contains("-") && value.endsWith(")")) {
                String[] range = value.substring(1, value.length() - 1).split("-");
                filter = new Filter.Range(field, Long.parseLong(range[0]), Long.parseLong(range[1]));
            } else {
                filter = value.startsWith("=") ? new Filter.Equals(field, SearchParameterResolver.guessType(value.substring(1))) : new Filter.Equals(field, SearchParameterResolver.guessType(value));
            }
            params.filter(filter);
        }
    }

    private static Object guessType(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                return Boolean.parseBoolean(value);
            }
            if (value.equalsIgnoreCase("null")) {
                return null;
            }
            return value;
        }
    }

    static {
        mapper.setVisibility(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public static final class SearchParameterValueFactory
    extends AbstractContainerRequestValueFactory<SearchParameter> {
        @Context
        private ResourceContext context;

        public void setContext(ResourceContext context) {
            this.context = context;
        }

        public SearchParameter provide() {
            SearchParameter params;
            HttpServletRequest request = (HttpServletRequest)this.context.getResource(HttpServletRequest.class);
            if (request.getHeader(SearchParameterResolver.ParameterName) != null) {
                params = SearchParameterResolver.resolve(request.getHeader(SearchParameterResolver.ParameterName));
            } else {
                Enumeration keys = request.getParameterNames();
                params = new SearchParameter();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    SearchParameterResolver.resolveParameter(params, key, request.getParameter(key));
                }
            }
            if (params.page() != 1 && params.start() == 0) {
                params.start((params.page() - 1) * params.limit());
            }
            return params;
        }
    }
}

