/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.persistence;

import de.whitefrog.frogr.Service;
import de.whitefrog.frogr.exception.FrogrException;
import de.whitefrog.frogr.exception.PersistException;
import de.whitefrog.frogr.exception.RelatedNotPersistedException;
import de.whitefrog.frogr.exception.RepositoryInstantiationException;
import de.whitefrog.frogr.exception.RepositoryNotFoundException;
import de.whitefrog.frogr.model.FieldList;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.model.QueryField;
import de.whitefrog.frogr.model.SaveContext;
import de.whitefrog.frogr.model.annotation.RelatedTo;
import de.whitefrog.frogr.model.relationship.BaseRelationship;
import de.whitefrog.frogr.persistence.AnnotationDescriptor;
import de.whitefrog.frogr.persistence.FieldDescriptor;
import de.whitefrog.frogr.persistence.Persistence;
import de.whitefrog.frogr.repository.DefaultRelationshipRepository;
import de.whitefrog.frogr.repository.ModelRepository;
import de.whitefrog.frogr.repository.RelationshipRepository;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Relationships {
    private static final Logger logger = LoggerFactory.getLogger(Relationships.class);
    private Service service;
    private Persistence persistence;

    Relationships(Service service, Persistence persistence) {
        this.service = service;
        this.persistence = persistence;
    }

    private <T extends Model> void addRelationship(T model, Node node, RelatedTo annotation, Model foreignModel) {
        DefaultRelationshipRepository<BaseRelationship> repository;
        if (foreignModel.getId() == -1L) {
            if (foreignModel.getUuid() != null) {
                foreignModel = (Model)this.service.repository(foreignModel.getClass()).findByUuid(foreignModel.getUuid(), new String[0]);
            } else {
                throw new RelatedNotPersistedException("the related field " + foreignModel + " is not yet persisted");
            }
        }
        Node foreignNode = this.persistence.getNode(foreignModel);
        RelationshipType relationshipType = RelationshipType.withName((String)annotation.type());
        if (!annotation.multiple() && this.hasRelationshipTo(node, foreignNode, relationshipType, annotation.direction())) {
            return;
        }
        try {
            repository = (DefaultRelationshipRepository<BaseRelationship>)this.service.repository(relationshipType.name());
        }
        catch (RepositoryNotFoundException e) {
            repository = new DefaultRelationshipRepository<BaseRelationship>(relationshipType.name());
            try {
                this.service.repositoryFactory().setRepositoryService(repository);
                this.service.repositoryFactory().register(relationshipType.name(), repository);
            }
            catch (ReflectiveOperationException ex) {
                throw new RepositoryInstantiationException(ex.getCause());
            }
        }
        BaseRelationship relationship = annotation.direction() == Direction.OUTGOING ? (BaseRelationship)repository.createModel(model, foreignModel) : (annotation.direction() == Direction.INCOMING ? (BaseRelationship)repository.createModel(foreignModel, model) : (BaseRelationship)repository.createModel(model, foreignModel));
        repository.save(relationship);
    }

    public <T extends BaseRelationship> T getRelationshipBetween(Model model, Model other, RelationshipType type, Direction dir) {
        Relationship relationship = this.getRelationshipBetween(this.persistence.getNode(model), this.persistence.getNode(other), type, dir);
        return (T)(relationship == null ? null : (BaseRelationship)this.persistence.get((PropertyContainer)relationship));
    }

    public Relationship getRelationshipBetween(Node node, Node other, RelationshipType type, Direction dir) {
        Iterable relationships = node.getRelationships(dir, new RelationshipType[]{type});
        for (Relationship relationship : relationships) {
            if (!relationship.getOtherNode(node).equals(other)) continue;
            return relationship;
        }
        return null;
    }

    Model getRelatedModel(Model model, RelatedTo annotation, FieldList fields) {
        block3: {
            Validate.notNull((Object)model);
            Validate.notNull((Object)annotation.type());
            try {
                Relationship relationship = this.persistence.getNode(model).getSingleRelationship(RelationshipType.withName((String)annotation.type()), annotation.direction());
                if (relationship != null) {
                    Node node = this.persistence.getNode(model);
                    Node other = relationship.getOtherNode(node);
                    String type = (String)other.getProperty("type");
                    ModelRepository repository = (ModelRepository)this.service.repository(type);
                    return (Model)repository.createModel((PropertyContainer)other, fields);
                }
            }
            catch (NotFoundException e) {
                if (!e.getMessage().startsWith("More than")) break block3;
                logger.error(e.getMessage());
                logger.error("Relationships are:");
                this.persistence.getNode(model).getRelationships(RelationshipType.withName((String)annotation.type()), annotation.direction()).forEach(rel -> logger.error(rel.toString()));
                throw e;
            }
        }
        return null;
    }

    <M extends Model> Set<M> getRelatedModels(Model model, FieldDescriptor descriptor, QueryField fieldDescriptor, FieldList fields) {
        RelatedTo annotation = descriptor.annotations().relatedTo;
        Validate.notNull((Object)model);
        Validate.notNull((Object)annotation.type());
        ResourceIterator iterator = (ResourceIterator)this.persistence.getNode(model).getRelationships(annotation.direction(), new RelationshipType[]{RelationshipType.withName((String)annotation.type())}).iterator();
        HashSet models = new HashSet();
        Node node = this.persistence.getNode(model);
        long count = 0L;
        while (iterator.hasNext()) {
            if (count < (long)fieldDescriptor.skip()) {
                iterator.next();
                ++count;
                continue;
            }
            if (count++ == (long)(fieldDescriptor.skip() + fieldDescriptor.limit())) break;
            Relationship relationship = (Relationship)iterator.next();
            Node other = relationship.getOtherNode(node);
            String type = (String)other.getProperty("type");
            if (annotation.restrictType() && !type.equals(descriptor.baseClass().getSimpleName())) {
                --count;
                continue;
            }
            ModelRepository repository = (ModelRepository)this.service.repository(type);
            models.add(repository.createModel((PropertyContainer)other, fields));
        }
        iterator.close();
        return models;
    }

    public <R extends de.whitefrog.frogr.model.relationship.Relationship> Relationship getRelationship(R relationship) {
        if (relationship.getId() > -1L) {
            return this.service.graph().getRelationshipById(relationship.getId());
        }
        throw new UnsupportedOperationException("cant find relationship without id");
    }

    <R extends BaseRelationship> R getRelationship(Model model, FieldDescriptor descriptor, FieldList fields) {
        RelatedTo annotation = descriptor.annotations().relatedTo;
        Validate.notNull((Object)model);
        Validate.notNull((Object)annotation.type());
        ResourceIterator iterator = (ResourceIterator)this.persistence.getNode(model).getRelationships(annotation.direction(), new RelationshipType[]{RelationshipType.withName((String)annotation.type())}).iterator();
        BaseRelationship relationshipModel = null;
        if (iterator.hasNext()) {
            Relationship relationship = (Relationship)iterator.next();
            relationshipModel = (BaseRelationship)this.persistence.get((PropertyContainer)relationship, fields);
        }
        iterator.close();
        return (R)relationshipModel;
    }

    <R extends BaseRelationship> Set<R> getRelationships(Model model, FieldDescriptor descriptor, QueryField queryField, FieldList fields) {
        RelatedTo annotation = descriptor.annotations().relatedTo;
        Validate.notNull((Object)model);
        Validate.notNull((Object)annotation.type());
        ResourceIterator iterator = (ResourceIterator)this.persistence.getNode(model).getRelationships(annotation.direction(), new RelationshipType[]{RelationshipType.withName((String)annotation.type())}).iterator();
        HashSet models = new HashSet();
        long count = 0L;
        while (iterator.hasNext()) {
            if (queryField != null && count < (long)queryField.skip()) {
                iterator.next();
                ++count;
                continue;
            }
            if (queryField != null && count++ == (long)(queryField.skip() + queryField.limit())) break;
            Relationship relationship = (Relationship)iterator.next();
            models.add(this.persistence.get((PropertyContainer)relationship, fields));
        }
        iterator.close();
        return models;
    }

    public boolean hasRelationshipTo(Node node, Node other, RelationshipType type, Direction direction) {
        Iterable relationships = node.getRelationships(direction, new RelationshipType[]{type});
        for (Relationship relationship : relationships) {
            if (!relationship.getOtherNode(node).equals(other)) continue;
            return true;
        }
        return false;
    }

    public <T extends de.whitefrog.frogr.model.relationship.Relationship> T save(SaveContext<T> context) {
        de.whitefrog.frogr.model.relationship.Relationship model = (de.whitefrog.frogr.model.relationship.Relationship)context.model();
        boolean create = false;
        if (!model.getPersisted()) {
            create = true;
            if (!model.getFrom().getPersisted()) {
                throw new FrogrException("the model " + model.getFrom() + " is not yet persisted, but used as 'from' in relationship " + model);
            }
            if (!model.getTo().getPersisted()) {
                throw new FrogrException("the model " + model.getTo() + " is not yet persisted, but used as 'to' in relationship " + model);
            }
            Node fromNode = this.persistence.getNode((Model)model.getFrom());
            Node toNode = this.persistence.getNode((Model)model.getTo());
            RelationshipType relType = RelationshipType.withName((String)context.repository().getType());
            Relationship relationship = fromNode.createRelationshipTo(toNode, relType);
            context.setNode((PropertyContainer)relationship);
            model.setId(relationship.getId());
            model.setCreated(System.currentTimeMillis());
            model.setType(model.getClass().getSimpleName());
        } else {
            if (model.getType() == null) {
                model.setType(context.repository().getType());
            }
            model.updateLastModified();
        }
        for (String property : model.getRemoveProperties()) {
            this.removeProperty(model, property);
        }
        for (FieldDescriptor field : context.fieldMap()) {
            this.persistence.saveField(context, field, create);
        }
        model.getCheckedFields().clear();
        if (logger.isInfoEnabled()) {
            logger.info("Relationship {}({}, {}) {}", new Object[]{model.getType(), model.getFrom(), model.getTo(), create ? "created" : "updated"});
        }
        return (T)model;
    }

    private <T extends BaseRelationship> void save(Model model, T relModel, RelatedTo annotation) {
        if (!relModel.getFrom().getPersisted()) {
            throw new RelatedNotPersistedException("the 'from' model " + relModel.getFrom() + " (" + annotation.type() + ") is not yet persisted");
        }
        if (!relModel.getTo().getPersisted()) {
            throw new RelatedNotPersistedException("the 'to' model " + relModel.getTo() + " (" + annotation.type() + ") is not yet persisted");
        }
        RelationshipRepository repository = (RelationshipRepository)this.service.repository(relModel.getClass());
        if (annotation.direction().equals((Object)Direction.INCOMING)) {
            if (!relModel.getTo().equals(model)) {
                throw new PersistException(relModel + " should have " + model + " as 'to' field set");
            }
        } else if (annotation.direction().equals((Object)Direction.OUTGOING)) {
            if (!relModel.getFrom().equals(model)) {
                throw new PersistException(relModel + " should have " + model + " as 'from' field set");
            }
        } else if (annotation.direction().equals((Object)Direction.BOTH) && !relModel.getFrom().equals(model) && !relModel.getTo().equals(model)) {
            throw new PersistException(relModel + "should have " + model + " either set as 'from' or 'to' field");
        }
        repository.save(relModel);
    }

    <T extends Model> void saveField(SaveContext<T> context, FieldDescriptor descriptor) throws IllegalAccessException {
        AnnotationDescriptor annotations = descriptor.annotations();
        Model model = (Model)context.model();
        Node node = (Node)context.node();
        RelatedTo relatedTo = annotations.relatedTo;
        Object value = descriptor.field().get(model);
        if (!descriptor.isCollection()) {
            Relationship existing = node.getSingleRelationship(RelationshipType.withName((String)relatedTo.type()), relatedTo.direction());
            if (existing != null) {
                existing.delete();
            }
            if (descriptor.isModel()) {
                Model foreignModel = (Model)value;
                this.addRelationship(model, node, relatedTo, foreignModel);
            } else {
                BaseRelationship relModel = (BaseRelationship)value;
                this.save(model, relModel, relatedTo);
            }
        } else {
            Collection collection = (Collection)value;
            if (!annotations.lazy) {
                RelationshipType relationshipType = RelationshipType.withName((String)relatedTo.type());
                for (Relationship relationship : node.getRelationships(relatedTo.direction(), new RelationshipType[]{relationshipType})) {
                    Object other = this.persistence.get((PropertyContainer)relationship.getOtherNode(node));
                    if (collection.contains(other)) continue;
                    relationship.delete();
                    logger.info("relationship between {} and {} removed", (Object)model, other);
                }
            }
            if (descriptor.isModel()) {
                for (Model foreignModel : (Collection)value) {
                    this.addRelationship(model, node, relatedTo, foreignModel);
                }
            } else {
                for (BaseRelationship relModel : (Collection)value) {
                    this.save(model, relModel, relatedTo);
                }
            }
        }
    }

    public void removeProperty(de.whitefrog.frogr.model.relationship.Relationship model, String property) {
        Relationship node = this.getRelationship(model);
        node.removeProperty(property);
        try {
            Field field = model.getClass().getDeclaredField(property);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(model, null);
        }
        catch (ReflectiveOperationException e) {
            throw new FrogrException("field " + property + " could not be found on " + model, e);
        }
    }

    public <R extends BaseRelationship> void delete(R relationship) {
        this.getRelationship(relationship).delete();
        logger.info("relationship {} between {} and {} removed", new Object[]{relationship.type(), relationship.getFrom(), relationship.getTo()});
    }

    public <T extends Model> void delete(T model, RelationshipType type, Direction direction, Model foreignModel) {
        if (foreignModel.getId() == -1L) {
            if (foreignModel.getUuid() != null) {
                foreignModel = (Model)this.service.repository(foreignModel.getClass()).findByUuid(foreignModel.getUuid(), new String[0]);
            } else {
                throw new RelatedNotPersistedException("the related field " + foreignModel + " is not yet persisted");
            }
        }
        Node node = this.persistence.getNode(model);
        Node foreignNode = this.persistence.getNode(foreignModel);
        for (Relationship relationship : node.getRelationships(type, direction)) {
            if (!relationship.getOtherNode(node).equals(foreignNode)) continue;
            relationship.delete();
            logger.info("relationship {} between {} and {} removed", new Object[]{type.name(), model, foreignModel});
        }
    }
}

