/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.persistence;

import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.TimeBasedGenerator;
import de.whitefrog.frogr.Service;
import de.whitefrog.frogr.exception.DuplicateEntryException;
import de.whitefrog.frogr.exception.FieldNotFoundException;
import de.whitefrog.frogr.exception.FrogrException;
import de.whitefrog.frogr.exception.MissingRequiredException;
import de.whitefrog.frogr.exception.PersistException;
import de.whitefrog.frogr.model.Base;
import de.whitefrog.frogr.model.FieldList;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.model.QueryField;
import de.whitefrog.frogr.model.SaveContext;
import de.whitefrog.frogr.model.annotation.RelationshipCount;
import de.whitefrog.frogr.model.relationship.BaseRelationship;
import de.whitefrog.frogr.persistence.AnnotationDescriptor;
import de.whitefrog.frogr.persistence.FieldDescriptor;
import de.whitefrog.frogr.persistence.ModelCache;
import de.whitefrog.frogr.persistence.Relationships;
import de.whitefrog.frogr.repository.ModelRepository;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.reflect.ConstructorUtils;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Persistence {
    private static final Logger logger = LoggerFactory.getLogger(Persistence.class);
    private Service service;
    private ModelCache cache;
    private Relationships relationships;

    public Persistence(Service service) {
        this.service = service;
        this.cache = new ModelCache();
        this.cache.scan(service.registry());
        this.relationships = new Relationships(service, this);
    }

    public ModelCache cache() {
        return this.cache;
    }

    public Relationships relationships() {
        return this.relationships;
    }

    public <T extends Model> void delete(T model) {
        Node node = this.getNode(model);
        for (Relationship relationship : node.getRelationships()) {
            relationship.delete();
        }
        node.delete();
    }

    public <T extends Model> T save(ModelRepository<T> repository, SaveContext<T> context) throws MissingRequiredException {
        Model model = (Model)context.model();
        Label label = repository.label();
        boolean create = false;
        if (!model.getPersisted()) {
            create = true;
            Node node = this.service.graph().createNode(new Label[]{label});
            context.setNode((PropertyContainer)node);
            repository.labels().stream().filter(l -> !node.hasLabel(l)).forEach(arg_0 -> ((Node)node).addLabel(arg_0));
            model.setId(node.getId());
            model.setCreated(System.currentTimeMillis());
            model.setType(label.name());
        } else {
            if (model.getType() == null) {
                model.setType(label.name());
            }
            model.updateLastModified();
        }
        for (String property : ((Model)context.model()).getRemoveProperties()) {
            this.removeProperty((Model)context.model(), property);
        }
        for (FieldDescriptor field : context.fieldMap()) {
            this.saveField(context, field, create);
        }
        model.getCheckedFields().clear();
        logger.info("{} {}", (Object)model, (Object)(create ? "created" : "updated"));
        return (T)model;
    }

    <T extends Base> void saveField(SaveContext<T> context, FieldDescriptor descriptor, boolean created) {
        Field field = descriptor.field();
        AnnotationDescriptor annotations = descriptor.annotations();
        T model = context.model();
        Object node = context.node();
        Object value = null;
        try {
            boolean valueChanged;
            value = field.get(model);
            if (created && annotations.required && (value == null || value instanceof String && ((String)value).isEmpty())) {
                throw new MissingRequiredException((Base)model, field);
            }
            boolean bl = valueChanged = created || context.fieldChanged(field.getName());
            if (!annotations.notPersistent && !annotations.blob) {
                if (created && annotations.uuid && field.get(model) == null) {
                    String uuid = this.generateUuid();
                    field.set(model, uuid);
                    value = uuid;
                    valueChanged = true;
                }
                if (value != null) {
                    if (annotations.relatedTo != null && valueChanged && model instanceof Model) {
                        this.relationships.saveField(context, descriptor);
                        logger.info("{}: updated relationships \"{}\"", model, (Object)field.getName());
                    } else if (!(value instanceof Collection) && !(value instanceof Model)) {
                        if (value.getClass().isEnum()) {
                            if (!node.hasProperty(field.getName()) || !((Enum)value).name().equals(node.getProperty(field.getName()))) {
                                node.setProperty(field.getName(), (Object)((Enum)value).name());
                                logger.info("{}: set enum value \"{}\" to \"{}\"", new Object[]{model, field.getName(), ((Enum)value).name()});
                            }
                        } else if (value instanceof Date) {
                            node.setProperty(field.getName(), (Object)((Date)value).getTime());
                            logger.info("{}: set date value \"{}\" to \"{}\"", new Object[]{model, field.getName(), ((Date)value).getTime()});
                        } else if (valueChanged) {
                            node.setProperty(field.getName(), value);
                            logger.info("{}: set value \"{}\" to \"{}\"", new Object[]{model, field.getName(), value});
                        }
                    }
                } else if (valueChanged && annotations.nullRemove) {
                    logger.info("{}: removed value \"{}\"", model, (Object)field.getName());
                    node.removeProperty(field.getName());
                }
            }
        }
        catch (ReflectiveOperationException e) {
            logger.error("Could not get property on {}: {}", new Object[]{model, e.getMessage(), e});
        }
        catch (ConstraintViolationException e) {
            throw new DuplicateEntryException("A " + model.getClass().getSimpleName().toLowerCase() + " with the " + field.getName() + " \"" + value + "\" already exists", (Base)model, field);
        }
        catch (IllegalArgumentException e) {
            logger.error("Could not store property {} on {}: {}", new Object[]{field.getName(), model, e.getMessage()});
        }
    }

    public <T extends Base> T get(PropertyContainer node) throws PersistException {
        return this.get(node, new FieldList());
    }

    public <T extends Base> T get(PropertyContainer node, FieldList fields) throws PersistException {
        Validate.notNull((Object)node, (String)"node can't be null");
        try {
            Base model;
            Class clazz = this.getClass(node);
            if (clazz == null) {
                Class clazz2 = clazz = node instanceof Node ? Model.class : BaseRelationship.class;
            }
            if (node instanceof Node) {
                model = (Base)clazz.newInstance();
                model.setId(((Node)node).getId());
            } else {
                Relationship rel = (Relationship)node;
                Model from = (Model)this.get((PropertyContainer)rel.getStartNode());
                if (fields.get("from") != null && !fields.get("from").subFields().isEmpty()) {
                    this.service.repository(from.getClass()).fetch((Base)from, fields.get("from").subFields());
                }
                Model to = (Model)this.get((PropertyContainer)rel.getEndNode());
                if (fields.get("to") != null && !fields.get("to").subFields().isEmpty()) {
                    this.service.repository(to.getClass()).fetch((Base)to, fields.get("to").subFields());
                }
                Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)clazz, (Class[])new Class[]{from.getClass(), to.getClass()});
                model = (Base)constructor.newInstance(from, to);
                model.setId(rel.getId());
                fields.remove(new QueryField("from"));
                fields.remove(new QueryField("to"));
            }
            this.service.repository(clazz).fetch(model, fields);
            return (T)model;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e instanceof PersistException ? (PersistException)e : new PersistException(e);
        }
    }

    private Class getClass(PropertyContainer node) {
        String className = node instanceof Relationship ? ((Relationship)node).getType().name() : (String)node.getProperty(node.hasProperty(Model.Companion.getModel()) ? "model" : "type");
        return this.cache().getModel(className);
    }

    private String generateUuid() {
        TimeBasedGenerator uuidGenerator = Generators.timeBasedGenerator();
        UUID uuid = uuidGenerator.generate();
        return Long.toHexString(uuid.getMostSignificantBits()) + Long.toHexString(uuid.getLeastSignificantBits());
    }

    private void removeProperty(Model model, String property) {
        Node node = this.getNode(model);
        node.removeProperty(property);
        try {
            Field field = model.getClass().getDeclaredField(property);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(model, null);
        }
        catch (ReflectiveOperationException e) {
            throw new FieldNotFoundException(property, model);
        }
    }

    public Node getNode(Model model) {
        Validate.notNull((Object)model);
        if (model.getId() > -1L) {
            return this.service.graph().getNodeById(model.getId());
        }
        if (model.getUuid() != null && model.getType() != null) {
            Node node = this.service.graph().findNode(Label.label((String)model.getType()), "uuid", (Object)model.getUuid());
            model.setId(node.getId());
            return node;
        }
        throw new UnsupportedOperationException("cant get a node without id or uuid");
    }

    public <T extends Base> void fetch(T model, String ... fields) {
        this.fetch(model, FieldList.parseFields(Arrays.asList(fields)), false);
    }

    public <T extends Base> void fetch(T model, FieldList fields) {
        this.fetch(model, fields, false);
    }

    public <T extends Base> void fetch(T model, FieldList fields, boolean refetch) {
        Validate.notNull(model, (String)"model cannot be null");
        if (!model.getPersisted()) {
            throw new FrogrException("the model " + model + " is not persisted yet");
        }
        try {
            Node node;
            if (model instanceof de.whitefrog.frogr.model.relationship.Relationship) {
                BaseRelationship relModel = (BaseRelationship)model;
                node = this.relationships.getRelationship(relModel);
            } else {
                node = this.getNode((Model)model);
            }
            for (FieldDescriptor descriptor : this.cache.fieldMap(model.getClass())) {
                boolean fetch;
                if (descriptor.getName().equals("id") && descriptor.annotations().notPersistent || !(fetch = descriptor.annotations().fetch || descriptor.getName().equals("type") || descriptor.getName().equals("uuid") || fields.containsField("all") || fields.containsField(descriptor.getName())) || !refetch && model.getFetchedFields().contains(descriptor.getName()) && fields.containsField(descriptor.getName()) && fields.get(descriptor.getName()).subFields().isEmpty()) continue;
                this.fetchField((PropertyContainer)node, model, descriptor, fields);
            }
        }
        catch (ReflectiveOperationException e) {
            logger.error("could not load relations for {}: {}", new Object[]{model, e.getMessage(), e});
        }
    }

    private <T extends Base> void fetchField(PropertyContainer node, T model, FieldDescriptor descriptor, FieldList fields) throws ReflectiveOperationException {
        AnnotationDescriptor annotations = descriptor.annotations();
        Field field = descriptor.field();
        field.setAccessible(true);
        if (node instanceof Relationship) {
            de.whitefrog.frogr.model.relationship.Relationship relModel = (de.whitefrog.frogr.model.relationship.Relationship)model;
            if (field.getName().equals("from") && fields.containsField("from") && !fields.get("from").subFields().isEmpty()) {
                this.service.repository(relModel.getFrom().getClass()).fetch((Base)relModel.getFrom(), fields.get("from").subFields());
            }
            if (field.getName().equals("to") && fields.containsField("to") && !fields.get("to").subFields().isEmpty()) {
                this.service.repository(relModel.getTo().getClass()).fetch((Base)relModel.getTo(), fields.get("to").subFields());
            }
        }
        if (node instanceof Node && annotations.relationshipCount != null && fields.containsField(field.getName())) {
            RelationshipCount count = annotations.relationshipCount;
            field.set(model, Iterables.count((Iterable)((Node)node).getRelationships(count.direction(), new RelationshipType[]{RelationshipType.withName((String)count.type())})));
        } else if (model instanceof Model && annotations.relatedTo != null) {
            QueryField fieldDescriptor;
            if (!annotations.fetch && !fields.containsField(field.getName())) {
                return;
            }
            FieldList subFields = fields.containsField(field.getName()) ? fields.get(field.getName()).subFields() : new FieldList();
            QueryField queryField = fieldDescriptor = fields.containsField(field.getName()) ? fields.get(field.getName()) : new QueryField(field.getName());
            if (descriptor.isCollection()) {
                Set<Object> related = descriptor.isModel() ? this.relationships.getRelatedModels((Model)model, descriptor, fieldDescriptor, subFields) : this.relationships.getRelationships((Model)model, descriptor, fieldDescriptor, subFields);
                field.set(model, Set.class.isAssignableFrom(field.getType()) ? related : new ArrayList(related));
            } else {
                Object related = descriptor.isModel() ? this.relationships.getRelatedModel((Model)model, annotations.relatedTo, subFields) : this.relationships.getRelationship((Model)model, descriptor, subFields);
                field.set(model, related);
            }
        } else if (node.hasProperty(field.getName())) {
            if (Enum.class.isAssignableFrom(field.getType())) {
                field.set(model, Enum.valueOf(field.getType(), (String)node.getProperty(field.getName())));
            } else if (Date.class.isAssignableFrom(field.getType())) {
                field.set(model, new Date((Long)node.getProperty(field.getName())));
            } else {
                field.set(model, node.getProperty(field.getName()));
            }
        }
        model.getFetchedFields().add(field.getName());
    }

    public <T extends Model> T findByUuid(String label, String uuid) {
        ResourceIterator iterator = this.service.graph().findNodes(Label.label((String)label), "uuid", (Object)uuid);
        return (T)(iterator.hasNext() ? (Model)this.get((PropertyContainer)iterator.next()) : null);
    }
}

