/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.persistence;

import de.whitefrog.frogr.model.Base;
import de.whitefrog.frogr.persistence.AnnotationDescriptor;
import de.whitefrog.frogr.persistence.FieldDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelCache {
    private static final Logger logger = LoggerFactory.getLogger(ModelCache.class);
    private Map<Class, List<FieldDescriptor>> cache = new HashMap<Class, List<FieldDescriptor>>();
    private Map<String, Class> modelCache = new HashMap<String, Class>();
    private List<String> ignoreFields = Arrays.asList("id", "initialId", "checkedFields", "fetchedFields");
    private Reflections reflections;

    public void scan(Collection<String> packages) {
        this.modelCache.clear();
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().setScanners(new Scanner[]{new SubTypesScanner()});
        packages.forEach(pkg -> configurationBuilder.addUrls(ClasspathHelper.forPackage((String)pkg, (ClassLoader[])new ClassLoader[0])));
        this.reflections = new Reflections((Configuration)configurationBuilder);
        for (Class clazz : this.reflections.getSubTypesOf(Base.class)) {
            this.modelCache.put(clazz.getSimpleName(), clazz);
            ArrayList<FieldDescriptor> descriptors = new ArrayList<FieldDescriptor>();
            for (Class traverse = clazz; traverse != null && Base.class.isAssignableFrom(traverse); traverse = traverse.getSuperclass()) {
                for (Field field : traverse.getDeclaredFields()) {
                    if (this.ignoreFields.contains(field.getName()) || Modifier.isStatic(field.getModifiers()) || this.containsField(descriptors, field.getName())) continue;
                    descriptors.add(new FieldDescriptor(field));
                }
            }
            this.cache.put(clazz, descriptors);
        }
        this.validateAnnotations();
    }

    private void validateAnnotations() {
        for (Class modelClass : this.cache.keySet()) {
            for (FieldDescriptor descriptor : this.cache.get(modelClass)) {
                AnnotationDescriptor annotations = descriptor.annotations();
                if (annotations.indexed != null && annotations.relatedTo != null) {
                    logger.warn("annotations @Indexed and @RelatedTo should not be used together ({}->{})", (Object)modelClass.getSimpleName(), (Object)descriptor.getName());
                }
                if (!annotations.nullRemove || !annotations.required) continue;
                logger.warn("annotations @NullRemove and @Required should not be used together ({}->{})", (Object)modelClass.getSimpleName(), (Object)descriptor.getName());
            }
        }
    }

    public List<Class> subTypesOf(Class<?> baseClass) {
        return new ArrayList<Class>(this.reflections.getSubTypesOf(baseClass));
    }

    public AnnotationDescriptor fieldAnnotations(Class clazz, String fieldName) {
        FieldDescriptor descriptor = this.fieldDescriptor(clazz, fieldName);
        return descriptor != null ? descriptor.annotations() : null;
    }

    public FieldDescriptor fieldDescriptor(Class clazz, String fieldName) {
        String firstField = fieldName.contains(".") ? fieldName.substring(0, fieldName.indexOf(".")) : fieldName;
        FieldDescriptor descriptor = null;
        for (FieldDescriptor subDescriptor : this.fieldMap(clazz)) {
            if (!firstField.equals(subDescriptor.field().getName())) continue;
            descriptor = subDescriptor;
            break;
        }
        if (descriptor != null && firstField.length() < fieldName.length()) {
            return this.fieldDescriptor(descriptor.baseClass(), fieldName.substring(fieldName.indexOf(".") + 1, fieldName.length()));
        }
        return descriptor;
    }

    public FieldDescriptor fieldDescriptor(Field field) {
        return this.fieldDescriptor(field.getDeclaringClass(), field.getName());
    }

    public List<FieldDescriptor> fieldMap(Class clazz) {
        return this.cache.get(clazz);
    }

    private <M extends Base> boolean containsField(List<FieldDescriptor> descriptors, String fieldName) {
        for (FieldDescriptor descriptor : descriptors) {
            if (!descriptor.field().getName().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    public static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        Class<?> tmpClass = clazz;
        while (true) {
            try {
                return tmpClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                if ((tmpClass = tmpClass.getSuperclass()) != null) continue;
                throw new NoSuchFieldException("Field '" + fieldName + "' not found on class " + clazz);
            }
            break;
        }
    }

    public boolean containsModel(String name) {
        return this.modelCache.containsKey(name);
    }

    public Collection<Class> getAllModels() {
        return this.modelCache.values();
    }

    public Class getModel(String name) {
        return this.modelCache.get(name);
    }
}

