/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.model;

import de.whitefrog.frogr.exception.FrogrException;
import de.whitefrog.frogr.model.Base;
import de.whitefrog.frogr.model.FieldList;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.persistence.AnnotationDescriptor;
import de.whitefrog.frogr.persistence.FieldDescriptor;
import de.whitefrog.frogr.repository.Repository;
import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.graphdb.PropertyContainer;

public class SaveContext<T extends Base> {
    private T model;
    private T original;
    private Repository<T> repository;
    private PropertyContainer node;
    private List<FieldDescriptor> changedFields;
    private List<FieldDescriptor> fieldMap;

    public SaveContext(Repository<T> repository, T model) {
        this.repository = repository;
        this.model = model;
        if (model.getId() > -1L) {
            this.original = repository.createModel((PropertyContainer)this.node());
        } else if (model.getUuid() != null) {
            this.original = repository.findByUuid(model.getUuid(), new String[0]);
            model.setId(this.original.getId());
        }
        this.fieldMap = repository.service().persistence().cache().fieldMap(model.getClass());
    }

    public List<FieldDescriptor> changedFields() {
        if (this.changedFields == null) {
            if (this.original() != null) {
                this.repository.fetch((Base)this.original(), "all");
            }
            this.changedFields = this.fieldMap.stream().filter(f -> this.fieldChanged(f.field())).collect(Collectors.toList());
        }
        return this.changedFields;
    }

    public boolean fieldChanged(String fieldName) {
        return this.changedFields().stream().anyMatch(f -> f.getName().equals(fieldName));
    }

    private boolean fieldChanged(Field field) {
        AnnotationDescriptor annotation = this.repository.service().persistence().cache().fieldAnnotations(this.repository().getModelClass(), field.getName());
        try {
            Object value;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if ((value = field.get(this.model)) != null && !annotation.nullRemove) {
                Object originalValue;
                if (this.original() == null) {
                    return true;
                }
                if (annotation.relatedTo != null && annotation.lazy) {
                    return true;
                }
                if (annotation.relatedTo != null) {
                    this.repository().fetch((Base)this.original(), FieldList.parseFields(field.getName() + "(max)"));
                }
                return !value.equals(originalValue = field.get(this.original()));
            }
            if (annotation.nullRemove) {
                return true;
            }
        }
        catch (IllegalAccessException e) {
            throw new FrogrException(e.getMessage(), e);
        }
        return false;
    }

    public List<FieldDescriptor> fieldMap() {
        return this.fieldMap;
    }

    public T model() {
        return this.model;
    }

    public Repository<T> repository() {
        return this.repository;
    }

    public <N extends PropertyContainer> N node() {
        if (this.node == null && this.original() != null) {
            this.node = this.model instanceof Model ? this.repository.graph().getNodeById(this.original().getId()) : this.repository.graph().getRelationshipById(this.original().getId());
        } else if (this.node == null && this.model().getId() > -1L) {
            this.node = this.model instanceof Model ? this.repository.graph().getNodeById(this.model().getId()) : this.repository.graph().getRelationshipById(this.model().getId());
        }
        return (N)this.node;
    }

    public T original() {
        return this.original;
    }

    public void setNode(PropertyContainer node) {
        this.node = node;
    }
}

