/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Date;
import java.util.function.Predicate;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Equals.class, name="eq"), @JsonSubTypes.Type(value=NotEquals.class, name="neq"), @JsonSubTypes.Type(value=LessThan.class, name="lt"), @JsonSubTypes.Type(value=GreaterThan.class, name="gt"), @JsonSubTypes.Type(value=Range.class, name="range")})
public interface Filter
extends Predicate<Object> {
    public Object getValue();

    public void setValue(Object var1);

    public String getProperty();

    public void setProperty(String var1);

    public static class Range
    extends Default
    implements Filter,
    Predicate<Object> {
        private boolean including = true;
        private long from;
        private long to;

        @JsonCreator
        public Range(@JsonProperty(value="property") String property, @JsonProperty(value="from") long from, @JsonProperty(value="to") long to) {
            super(property, from);
            this.from = from;
            this.to = to;
        }

        public Range(String property, Date from, Date to) {
            super(property, from);
            this.from = from.getTime();
            this.to = to.getTime();
        }

        @Override
        public Long getValue() {
            return this.from;
        }

        @Override
        public void setValue(Object value) {
        }

        public long getFrom() {
            return this.from;
        }

        public void setFrom(long from) {
            this.from = from;
        }

        public long getTo() {
            return this.to;
        }

        public void setTo(long to) {
            this.to = to;
        }

        public boolean isIncluding() {
            return this.including;
        }

        public void setIncluding(boolean value) {
            this.including = value;
        }

        @Override
        public boolean test(Object other) {
            Long otherLong = other instanceof Integer ? new Long(((Integer)other).intValue()) : (Long)other;
            if (this.isIncluding()) {
                return otherLong <= this.getFrom() && otherLong >= this.getTo();
            }
            return otherLong < this.getFrom() && otherLong > this.getTo();
        }
    }

    public static class Contains
    extends Default
    implements Filter,
    Predicate<Object> {
        @JsonCreator
        public Contains(@JsonProperty(value="property") String property, @JsonProperty(value="value") Object value) {
            super(property, value);
        }

        @Override
        public String getValue() {
            return (String)super.getValue();
        }

        @Override
        public boolean test(Object other) {
            return other instanceof String && ((String)other).contains(this.getValue());
        }
    }

    public static class EndsWith
    extends Default
    implements Filter,
    Predicate<Object> {
        @JsonCreator
        public EndsWith(@JsonProperty(value="property") String property, @JsonProperty(value="value") Object value) {
            super(property, value);
        }

        @Override
        public String getValue() {
            return (String)super.getValue();
        }

        @Override
        public boolean test(Object other) {
            return other instanceof String && ((String)other).endsWith(this.getValue());
        }
    }

    public static class StartsWith
    extends Default
    implements Filter,
    Predicate<Object> {
        @JsonCreator
        public StartsWith(@JsonProperty(value="property") String property, @JsonProperty(value="value") Object value) {
            super(property, value);
        }

        @Override
        public String getValue() {
            return (String)super.getValue();
        }

        @Override
        public boolean test(Object other) {
            return other instanceof String && ((String)other).startsWith(this.getValue());
        }
    }

    public static class LessThan
    extends Default
    implements Filter,
    Predicate<Object> {
        private boolean including = false;

        @JsonCreator
        public LessThan(@JsonProperty(value="property") String property, @JsonProperty(value="value") Object value) {
            super(property, value);
        }

        public LessThan(String property, Object value, boolean including) {
            super(property, value);
            this.including = including;
        }

        @Override
        public Long getValue() {
            if (super.getValue() instanceof Integer) {
                return ((Integer)super.getValue()).longValue();
            }
            if (super.getValue() instanceof Date) {
                return ((Date)super.getValue()).getTime();
            }
            return (Long)super.getValue();
        }

        public boolean isIncluding() {
            return this.including;
        }

        public void setIncluding(boolean value) {
            this.including = value;
        }

        @Override
        public boolean test(Object other) {
            Long otherLong = other instanceof Integer ? new Long(((Integer)other).intValue()) : (Long)other;
            return this.isIncluding() ? otherLong <= this.getValue() : otherLong < this.getValue();
        }
    }

    public static class GreaterThan
    extends Default
    implements Filter,
    Predicate<Object> {
        private boolean including = false;

        @JsonCreator
        public GreaterThan(@JsonProperty(value="property") String property, @JsonProperty(value="value") Object value) {
            super(property, value);
        }

        public GreaterThan(String property, Object value, boolean including) {
            super(property, value);
            this.including = including;
        }

        @Override
        public Long getValue() {
            if (super.getValue() instanceof Integer) {
                return ((Integer)super.getValue()).longValue();
            }
            if (super.getValue() instanceof Date) {
                return ((Date)super.getValue()).getTime();
            }
            return (Long)super.getValue();
        }

        public boolean isIncluding() {
            return this.including;
        }

        public void setIncluding(boolean value) {
            this.including = value;
        }

        @Override
        public boolean test(Object other) {
            Long otherLong = other instanceof Integer ? new Long(((Integer)other).intValue()) : (Long)other;
            return this.isIncluding() ? otherLong >= this.getValue() : otherLong > this.getValue();
        }
    }

    public static class NotEquals
    extends Default
    implements Filter,
    Predicate<Object> {
        @JsonCreator
        public NotEquals(@JsonProperty(value="property") String property, @JsonProperty(value="value") Object value) {
            super(property, value);
        }

        @Override
        public boolean test(Object other) {
            return !other.equals(this.getValue());
        }
    }

    public static class Equals
    extends Default
    implements Filter,
    Predicate<Object> {
        @JsonCreator
        public Equals(@JsonProperty(value="property") String property, @JsonProperty(value="value") Object value) {
            super(property, value);
        }

        @Override
        public boolean test(Object other) {
            return other.equals(this.getValue());
        }
    }

    public static abstract class Default
    implements Filter {
        private Object value;
        private String property;

        @JsonCreator
        public Default(@JsonProperty(value="property") String property, @JsonProperty(value="value") Object value) {
            this.property = property;
            this.value = value;
        }

        @Override
        public String getProperty() {
            return this.property;
        }

        @Override
        public void setProperty(String property) {
            this.property = property;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void setValue(Object value) {
            this.value = value;
        }
    }
}

