/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import de.whitefrog.frogr.exception.FrogrException;
import de.whitefrog.frogr.model.Base;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.model.annotation.Fetch;
import de.whitefrog.frogr.model.annotation.NotPersistent;
import de.whitefrog.frogr.model.annotation.Unique;
import de.whitefrog.frogr.model.annotation.Uuid;
import de.whitefrog.frogr.rest.Views;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\n\b&\u0018\u0000 G2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001GB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0007H\u0016J+\u00103\u001a\u0002H4\"\b\b\u0000\u00104*\u00020\u00032\u0012\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000706\"\u00020\u0007H\u0016\u00a2\u0006\u0002\u00107J%\u00103\u001a\u0002H4\"\b\b\u0000\u00104*\u00020\u00032\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000708H\u0016\u00a2\u0006\u0002\u00109J\u0011\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u0003H\u0096\u0002J\u0013\u0010=\u001a\u00020\u001d2\b\u0010<\u001a\u0004\u0018\u00010>H\u0096\u0002J\u000f\u0010?\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010@\u001a\u00020;H\u0016J\u0010\u0010A\u001a\u0002012\u0006\u0010B\u001a\u00020\u0007H\u0016J\b\u0010C\u001a\u000201H\u0016J\u000e\u0010D\u001a\u0002012\u0006\u0010\u001e\u001a\u00020\rJ\b\u0010E\u001a\u00020\u0007H\u0016J\n\u0010*\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010F\u001a\u000201H\u0016R$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\"\u0010\f\u001a\u0004\u0018\u00010\r8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\t\"\u0004\b\u0015\u0010\u000bR&\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r8V@VX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u001d8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\u0004\u0018\u00010\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R \u0010\u001f\u001a\u0004\u0018\u00010\u00078\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u001d8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R$\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\t\"\u0004\b)\u0010\u000bR \u0010*\u001a\u0004\u0018\u00010\u00078\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010!\"\u0004\b,\u0010#R \u0010-\u001a\u0004\u0018\u00010\u00078\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010!\"\u0004\b/\u0010#\u00a8\u0006H"}, d2={"Lde/whitefrog/frogr/model/Entity;", "Lde/whitefrog/frogr/model/Model;", "", "Lde/whitefrog/frogr/model/Base;", "()V", "checkedFields", "Ljava/util/HashSet;", "", "getCheckedFields", "()Ljava/util/HashSet;", "setCheckedFields", "(Ljava/util/HashSet;)V", "created", "", "getCreated", "()Ljava/lang/Long;", "setCreated", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "fetchedFields", "getFetchedFields", "setFetchedFields", "value", "id", "getId", "()J", "setId", "(J)V", "initialId", "", "lastModified", "model", "getModel", "()Ljava/lang/String;", "setModel", "(Ljava/lang/String;)V", "persisted", "getPersisted", "()Z", "removeProperties", "getRemoveProperties", "setRemoveProperties", "type", "getType", "setType", "uuid", "getUuid", "setUuid", "addCheckedField", "", "field", "clone", "T", "fields", "", "([Ljava/lang/String;)Lde/whitefrog/frogr/model/Base;", "", "(Ljava/util/List;)Lde/whitefrog/frogr/model/Base;", "compareTo", "", "other", "equals", "", "getLastModified", "hashCode", "removeProperty", "property", "resetId", "setLastModified", "toString", "updateLastModified", "Companion", "frogr-base"})
public abstract class Entity
implements Model,
Comparable<Base> {
    @JsonView(value={Views.Hidden.class})
    private long id = de.whitefrog.frogr.model.Entity$Companion.access$getRandom$p(Companion).nextLong();
    @Uuid
    @Fetch
    @Unique
    @Nullable
    private String uuid;
    @Fetch
    @Nullable
    private String type;
    @JsonView(value={Views.Hidden.class})
    @Nullable
    private String model;
    @JsonView(value={Views.Secure.class})
    @Nullable
    private Long created;
    @JsonView(value={Views.Secure.class})
    private Long lastModified;
    @NotPersistent
    private boolean initialId = true;
    @NotPersistent
    @JsonIgnore
    @NotNull
    private HashSet<String> checkedFields = new HashSet();
    @NotPersistent
    @JsonIgnore
    @NotNull
    private HashSet<String> fetchedFields = new HashSet();
    @NotPersistent
    @JsonIgnore
    @NotNull
    private HashSet<String> removeProperties = new HashSet();
    @JvmField
    @NotNull
    public static final String AllFields = "all";
    @JvmField
    @NotNull
    public static final String IdProperty = "id";
    @JvmField
    @NotNull
    public static final String LastModified = "lastModified";
    @JvmField
    @NotNull
    public static final String Created = "created";
    @JvmField
    @NotNull
    public static final String Type = "type";
    @JvmField
    @NotNull
    public static final String Model = "model";
    @JvmField
    @NotNull
    public static final String Uuid = "uuid";
    private static final Random random;
    public static final Companion Companion;

    @Override
    public long getId() {
        return this.initialId ? -1L : this.id;
    }

    @Override
    public void setId(long value) {
        this.id = value;
        this.initialId = false;
    }

    @Override
    @Nullable
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public void setUuid(@Nullable String string) {
        this.uuid = string;
    }

    @Override
    @Nullable
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(@Nullable String string) {
        this.type = string;
    }

    @Override
    @Nullable
    public String getModel() {
        return this.model;
    }

    @Override
    public void setModel(@Nullable String string) {
        this.model = string;
    }

    @Override
    @Nullable
    public Long getCreated() {
        return this.created;
    }

    @Override
    public void setCreated(@Nullable Long l) {
        this.created = l;
    }

    @Override
    @NotNull
    public HashSet<String> getCheckedFields() {
        return this.checkedFields;
    }

    @Override
    public void setCheckedFields(@NotNull HashSet<String> hashSet) {
        Intrinsics.checkParameterIsNotNull(hashSet, (String)"<set-?>");
        this.checkedFields = hashSet;
    }

    @Override
    @NotNull
    public HashSet<String> getFetchedFields() {
        return this.fetchedFields;
    }

    @Override
    public void setFetchedFields(@NotNull HashSet<String> hashSet) {
        Intrinsics.checkParameterIsNotNull(hashSet, (String)"<set-?>");
        this.fetchedFields = hashSet;
    }

    @Override
    @NotNull
    public HashSet<String> getRemoveProperties() {
        return this.removeProperties;
    }

    @Override
    public void setRemoveProperties(@NotNull HashSet<String> hashSet) {
        Intrinsics.checkParameterIsNotNull(hashSet, (String)"<set-?>");
        this.removeProperties = hashSet;
    }

    @Override
    public void removeProperty(@NotNull String property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        this.getRemoveProperties().add(property);
    }

    @Override
    @JsonIgnore
    public boolean getPersisted() {
        return this.getId() > (long)-1 || this.getUuid() != null;
    }

    @Override
    @NotNull
    public <T extends Base> T clone(String ... fields) {
        Intrinsics.checkParameterIsNotNull((Object)fields, (String)"fields");
        List<String> list = Arrays.asList(Arrays.copyOf(fields, fields.length));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(*fields)");
        return this.clone(list);
    }

    @Override
    @NotNull
    public <T extends Base> T clone(@NotNull List<String> fields) {
        Base base;
        Intrinsics.checkParameterIsNotNull(fields, (String)"fields");
        try {
            Object obj = this.getClass().newInstance();
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            base = (Base)obj;
            base.setType(this.type());
            base.setId(this.getId());
            base.setUuid(this.getUuid());
        }
        catch (ReflectiveOperationException e) {
            throw (Throwable)new FrogrException(e.getMessage(), e);
        }
        return (T)base;
    }

    @Override
    @Nullable
    public String type() {
        return this.getType();
    }

    @Override
    public void addCheckedField(@NotNull String field) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        this.getCheckedFields().add(field);
    }

    @Override
    @Nullable
    public Long getLastModified() {
        return this.lastModified;
    }

    public final void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public void updateLastModified() {
        this.lastModified = System.currentTimeMillis();
    }

    @Override
    public void resetId() {
        this.setId(Entity.Companion.getRandom().nextLong());
        this.initialId = true;
    }

    @Override
    public int compareTo(@NotNull Base other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return Long.compare(this.getId(), other.getId());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Entity)) {
            return false;
        }
        Object base = other;
        if (this.getUuid() != null && ((Entity)base).getUuid() != null && Intrinsics.areEqual((Object)this.getUuid(), (Object)((Entity)base).getUuid()) ^ true) {
            return false;
        }
        if (this.initialId) {
            return false;
        }
        if (this.getId() != ((Entity)base).getId()) {
            return false;
        }
        return !(Intrinsics.areEqual(this.getClass(), ((Entity)base).getClass()) ^ true);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.getId()).toHashCode();
    }

    @NotNull
    public String toString() {
        String typeName = this.type() != null ? this.type() : this.getClass().getSimpleName();
        String id = this.getId() == -1L ? this.getUuid() : String.valueOf(this.getId());
        return "" + typeName + " (" + id + ')';
    }

    static {
        Companion = new Companion(null);
        AllFields = AllFields;
        IdProperty = IdProperty;
        LastModified = LastModified;
        Created = Created;
        Type = Type;
        Model = Model;
        Uuid = Uuid;
        random = new Random();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lde/whitefrog/frogr/model/Entity$Companion;", "", "()V", "AllFields", "", "Created", "IdProperty", "LastModified", "Model", "Type", "Uuid", "random", "Ljava/util/Random;", "getRandom", "()Ljava/util/Random;", "frogr-base"})
    public static final class Companion {
        private final Random getRandom() {
            return random;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

