/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.helper;

import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;

public abstract class TimeUtils {
    public static String formatInterval(long i) {
        return TimeUtils.formatInterval(i, TimeUnit.MILLISECONDS);
    }

    public static String formatInterval(long i, TimeUnit timeUnit) {
        if (!timeUnit.equals((Object)TimeUnit.NANOSECONDS)) {
            i = timeUnit.toNanos(i);
        }
        long days = TimeUnit.NANOSECONDS.toDays(i);
        long hr = TimeUnit.NANOSECONDS.toHours(i - TimeUnit.DAYS.toNanos(days));
        long min = TimeUnit.NANOSECONDS.toMinutes(i - TimeUnit.DAYS.toNanos(days) - TimeUnit.HOURS.toNanos(hr));
        long sec = TimeUnit.NANOSECONDS.toSeconds(i - TimeUnit.DAYS.toNanos(days) - TimeUnit.HOURS.toNanos(hr) - TimeUnit.MINUTES.toNanos(min));
        long ms = TimeUnit.NANOSECONDS.toMillis(i - TimeUnit.DAYS.toNanos(days) - TimeUnit.HOURS.toNanos(hr) - TimeUnit.MINUTES.toNanos(min) - TimeUnit.SECONDS.toNanos(sec));
        long micro = TimeUnit.NANOSECONDS.toMicros(i - TimeUnit.DAYS.toNanos(days) - TimeUnit.HOURS.toNanos(hr) - TimeUnit.MINUTES.toNanos(min) - TimeUnit.SECONDS.toNanos(sec) - TimeUnit.MILLISECONDS.toNanos(ms));
        long ns = i - TimeUnit.DAYS.toNanos(days) - TimeUnit.HOURS.toNanos(hr) - TimeUnit.MINUTES.toNanos(min) - TimeUnit.SECONDS.toNanos(sec) - TimeUnit.MILLISECONDS.toNanos(ms) - TimeUnit.MICROSECONDS.toNanos(micro);
        if (days > 0L) {
            return MessageFormat.format("{0} {0,choice,0#days|1#day|1<days} {1} {1,choice,0#hours|1#hour|1<hours}", days, hr);
        }
        if (hr > 0L) {
            return MessageFormat.format("{0} {0,choice,0#hours|1#hour|1<hours} {1} {1,choice,0#minutes|1#minute|1<minutes}", hr, min);
        }
        if (min > 0L) {
            return MessageFormat.format("{0} {0,choice,0#minutes|1#minute|1<minutes} {1} {1,choice,0#seconds|1#second|1<seconds}", min, sec);
        }
        if (sec > 0L) {
            return MessageFormat.format("{0} {0,choice,0#seconds|1#second|1<seconds} {1}ms", sec, ms);
        }
        if (ms > 10L) {
            return MessageFormat.format("{0}ms", ms);
        }
        if (ms > 0L) {
            return MessageFormat.format("{0}.{1}ms", ms, micro);
        }
        if (micro > 10L) {
            return MessageFormat.format("{0}\u00b5s", micro);
        }
        if (micro > 0L) {
            return MessageFormat.format("{0}.{1}\u00b5s", micro, ns);
        }
        return MessageFormat.format("{0}ns", ns);
    }

    public static String perSecond(long time, long count) {
        if (count == 0L) {
            return "0/s";
        }
        return TimeUtils.perSecond(time / count);
    }

    public static String perSecond(double divisor) {
        double after = (double)TimeUnit.SECONDS.toNanos(1L) / divisor;
        return String.format("%.2f/s", after);
    }
}

