/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr;

import com.codahale.metrics.health.HealthCheck;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import de.whitefrog.frogr.Service;
import de.whitefrog.frogr.health.GraphHealthCheck;
import de.whitefrog.frogr.rest.request.SearchParameterResolver;
import de.whitefrog.frogr.rest.request.ServiceInjector;
import de.whitefrog.frogr.rest.response.ExceptionMapper;
import de.whitefrog.frogr.rest.response.WrappingWriterInterceptor;
import io.dropwizard.Bundle;
import io.dropwizard.Configuration;
import io.dropwizard.forms.MultiPartBundle;
import io.dropwizard.jetty.ConnectorFactory;
import io.dropwizard.jetty.HttpConnectorFactory;
import io.dropwizard.server.DefaultServerFactory;
import io.dropwizard.server.SimpleServerFactory;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Application<C extends Configuration>
extends io.dropwizard.Application<C> {
    private static final Logger logger = LoggerFactory.getLogger(Application.class);
    private static final String AllowedMethods = "OPTIONS,GET,PUT,POST,DELETE,HEAD";
    private static final String AllowedHeaders = "X-Requested-With,Content-Type,Accept,Origin,Authorization";
    private List<String> packages = new ArrayList<String>();
    private ServiceInjector serviceInjector;

    public Service service() {
        return this.serviceInjector().provide();
    }

    public ServiceInjector serviceInjector() {
        if (this.serviceInjector == null) {
            this.serviceInjector = new ServiceInjector();
        }
        return this.serviceInjector;
    }

    public void initialize(Bootstrap<C> bootstrap) {
        bootstrap.addBundle((Bundle)new MultiPartBundle());
        super.initialize(bootstrap);
    }

    public void run(C configuration, Environment environment) throws Exception {
        environment.jersey().register(ExceptionMapper.class);
        environment.jersey().register(SearchParameterResolver.class);
        environment.jersey().packages(this.packages.toArray(new String[this.packages.size()]));
        FilterRegistration.Dynamic cors = environment.servlets().addFilter("CORS", CrossOriginFilter.class);
        cors.setInitParameter("allowedOrigins", "*");
        cors.setInitParameter("Access-Control-Allow-Origin", "*");
        cors.setInitParameter("allowedHeaders", AllowedHeaders);
        cors.setInitParameter("Access-Control-Allow-Methods", AllowedMethods);
        cors.setInitParameter("allowedMethods", AllowedMethods);
        cors.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
        environment.healthChecks().register("graph", (HealthCheck)new GraphHealthCheck(this.service()));
        environment.getObjectMapper().enable(new MapperFeature[]{MapperFeature.USE_ANNOTATIONS});
        environment.getObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        environment.getObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        environment.jersey().register(WrappingWriterInterceptor.class);
        environment.jersey().register((Object)new AbstractBinder(){

            protected void configure() {
                this.bindFactory(Application.this.serviceInjector()).to(Service.class);
            }
        });
        if (configuration.getServerFactory() instanceof DefaultServerFactory) {
            DefaultServerFactory serverFactory = (DefaultServerFactory)configuration.getServerFactory();
            for (ConnectorFactory connector : serverFactory.getApplicationConnectors()) {
                if (!connector.getClass().isAssignableFrom(HttpConnectorFactory.class)) continue;
                logger.info("Service available at: http://localhost:{}", (Object)((HttpConnectorFactory)connector).getPort());
                break;
            }
        } else {
            SimpleServerFactory serverFactory = (SimpleServerFactory)configuration.getServerFactory();
            HttpConnectorFactory connector = (HttpConnectorFactory)serverFactory.getConnector();
            if (connector.getClass().isAssignableFrom(HttpConnectorFactory.class)) {
                logger.info("Service available at: http://localhost:{}", (Object)connector.getPort());
            }
        }
    }

    public void register(String ... packages) {
        if (packages.length == 1 && packages[0].contains(";")) {
            packages = packages[0].split(";");
        }
        this.packages.addAll(Arrays.asList(packages));
    }

    public List<String> registry() {
        return this.packages;
    }

    public void shutdown() {
        if (this.service() != null) {
            this.service().shutdown();
        } else {
            logger.error("service not initialized");
        }
    }
}

