/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.rest.service;

import com.codahale.metrics.Timer;
import com.fasterxml.jackson.annotation.JsonView;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.model.SaveContext;
import de.whitefrog.frogr.model.rest.SearchParameter;
import de.whitefrog.frogr.repository.Repository;
import de.whitefrog.frogr.rest.Views;
import de.whitefrog.frogr.rest.request.SearchParam;
import de.whitefrog.frogr.rest.response.Response;
import de.whitefrog.frogr.rest.service.RestService;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.neo4j.graphdb.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CRUDService<R extends Repository<M>, M extends Model>
extends RestService<R, M> {
    private static final Logger logger = LoggerFactory.getLogger(CRUDService.class);

    @POST
    public List<M> create(List<M> models) {
        try (Transaction tx = this.service().beginTx();){
            for (Model model : models) {
                if (model.getPersisted()) {
                    throw new ForbiddenException("the model is not yet persisted");
                }
                SaveContext<Model> context = new SaveContext<Model>((Repository<Model>)this.repository(), model);
                try {
                    this.repository().save(context);
                }
                catch (Exception e) {
                    logger.error("failed to save {}", (Object)model);
                    throw e;
                }
            }
            tx.success();
        }
        return models;
    }

    @PUT
    public List<M> update(List<M> models) {
        try (Transaction tx = this.service().beginTx();){
            for (Model model : models) {
                if (!model.getPersisted()) {
                    throw new ForbiddenException("the model has to be created first");
                }
                SaveContext<Model> context = new SaveContext<Model>((Repository<Model>)this.repository(), model);
                try {
                    this.repository().save(context);
                }
                catch (Exception e) {
                    logger.error("failed to update {}", (Object)model);
                    throw e;
                }
            }
            tx.success();
        }
        return models;
    }

    @GET
    @Path(value="{uuid: [a-zA-Z0-9]+}")
    @JsonView(value={Views.Public.class})
    public Model read(@PathParam(value="uuid") String uuid, @SearchParam SearchParameter params) {
        return (Model)this.search(params.uuids(uuid)).singleton();
    }

    @GET
    @JsonView(value={Views.Public.class})
    public Response search(@SearchParam SearchParameter params) {
        Timer.Context timer = metrics.timer("myband." + this.repository().getModelClass().getSimpleName().toLowerCase() + ".search").time();
        Response response = new Response();
        try (Transaction tx = this.service().beginTx();){
            SearchParameter paramsClone = params.clone();
            if (params.limit() > 0) {
                List list = this.repository().search().params(params).list();
                response.setData(list);
            }
            timer.stop();
            response.setSuccess(true);
            if (params.count()) {
                response.setTotal(this.repository().search().params(paramsClone).count());
            }
        }
        return response;
    }

    @POST
    @Path(value="search")
    @JsonView(value={Views.Public.class})
    public Response searchPost(SearchParameter params) {
        return this.search(params);
    }

    @DELETE
    @Path(value="{uuid: [a-zA-Z0-9]+}")
    public void delete(@PathParam(value="uuid") String uuid) {
        try (Transaction tx = this.service().beginTx();){
            Model model = (Model)this.repository().findByUuid(uuid, new String[0]);
            if (model == null) {
                throw new NotFoundException();
            }
            this.repository().remove((Model)model);
            tx.success();
        }
    }
}

