/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.rest.response;

import de.whitefrog.frogr.exception.DuplicateEntryException;
import de.whitefrog.frogr.exception.FrogrException;
import de.whitefrog.frogr.exception.MissingRequiredException;
import de.whitefrog.frogr.rest.response.Response;
import java.security.InvalidParameterException;
import java.util.Map;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.neo4j.helpers.collection.MapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ExceptionMapper
implements javax.ws.rs.ext.ExceptionMapper<Exception> {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionMapper.class);
    public static final Map<Class<FrogrException>, String> codes = MapUtil.genericMap((Object[])new Object[0]);

    public javax.ws.rs.core.Response toResponse(Exception exception) {
        Response response = new Response();
        response.setSuccess(false);
        response.setMessage(exception.getMessage());
        if (exception instanceof WebApplicationException) {
            if (!(exception instanceof ForbiddenException) && !(exception instanceof NotAuthorizedException) && ((WebApplicationException)exception).getResponse().getStatus() != Response.Status.FORBIDDEN.getStatusCode()) {
                logger.error(exception.getMessage(), (Throwable)exception);
            }
            return javax.ws.rs.core.Response.fromResponse((javax.ws.rs.core.Response)((WebApplicationException)exception).getResponse()).entity(response).build();
        }
        if (exception instanceof MissingRequiredException || exception instanceof InvalidParameterException || exception instanceof ConstraintViolationException || exception instanceof DuplicateEntryException) {
            logger.error(exception.getMessage());
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity(response).build();
        }
        logger.error(exception.getMessage(), (Throwable)exception);
        return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity(response).build();
    }
}

