/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.repository;

import de.whitefrog.frogr.Service;
import de.whitefrog.frogr.cypher.QueryBuilder;
import de.whitefrog.frogr.exception.MissingRequiredException;
import de.whitefrog.frogr.exception.PersistException;
import de.whitefrog.frogr.helper.ReflectionUtil;
import de.whitefrog.frogr.model.Base;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.model.SaveContext;
import de.whitefrog.frogr.model.rest.FieldList;
import de.whitefrog.frogr.model.rest.SearchParameter;
import de.whitefrog.frogr.persistence.AnnotationDescriptor;
import de.whitefrog.frogr.persistence.Persistence;
import de.whitefrog.frogr.repository.Repository;
import de.whitefrog.frogr.service.Search;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.commons.collections.CollectionUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRepository<T extends Base>
implements Repository<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Service service;
    private String type;
    protected Class<?> modelClass;

    public BaseRepository() {
        this.type = this.getClass().getSimpleName().substring(0, this.getClass().getSimpleName().indexOf("Repository"));
    }

    public BaseRepository(String type) {
        this.type = type;
    }

    @Override
    public T createModel(PropertyContainer node) {
        return this.createModel(node, new FieldList());
    }

    @Override
    public boolean contains(T model) {
        return model.getId() != -1L && this.find(model.getId(), new String[0]) != null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Class<?> getModelClass() {
        if (this.modelClass == null) {
            this.modelClass = Persistence.cache().getModel(this.getType());
        }
        return this.modelClass;
    }

    Set<String> getModelInterfaces(Class<?> clazz) {
        Class<?>[] interfaces;
        HashSet<String> output = new HashSet<String>();
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            if (!Model.class.isAssignableFrom(i) || i.equals(Model.class)) continue;
            output.add(i.getSimpleName());
            output.addAll(this.getModelInterfaces(i));
        }
        return output;
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public T fetch(T tag, String ... fields) {
        return this.fetch(tag, FieldList.parseFields(fields));
    }

    @Override
    public T fetch(T tag, FieldList fields) {
        return this.fetch(tag, false, fields);
    }

    @Override
    public T fetch(T tag, boolean refetch, FieldList fields) {
        Persistence.fetch(tag, fields, refetch);
        return tag;
    }

    @Override
    public T find(long id, String ... fields) {
        return this.search().ids(id).fields(fields).single();
    }

    @Override
    public T findByUuid(String uuid, String ... fields) {
        return this.search().filter("uuid", uuid).fields(fields).single();
    }

    @Override
    public GraphDatabaseService graph() {
        return this.service().graph();
    }

    @Override
    public void initialize() {
    }

    @Override
    public QueryBuilder queryBuilder() {
        return new QueryBuilder(this);
    }

    @Override
    public String queryIdentifier() {
        return this.getType().toLowerCase();
    }

    @Override
    public void save(T model) throws PersistException {
        this.save((T)new SaveContext<T>(this, model));
    }

    @Override
    @SafeVarargs
    public final void save(T ... entities) throws PersistException {
        for (T entity : entities) {
            this.save(entity);
        }
    }

    @Override
    public Search search() {
        return new Search(this);
    }

    @Override
    public Service service() {
        return this.service;
    }

    @Override
    public void sort(List<T> list, List<SearchParameter.OrderBy> orderBy) {
        if (orderBy != null && !list.isEmpty()) {
            Class<?> clazz = ((Base)list.get(0)).getClass();
            ArrayList<Field> orderedFields = new ArrayList<Field>(orderBy.size());
            for (SearchParameter.OrderBy order : orderBy) {
                try {
                    Field field = ReflectionUtil.getSuperField(clazz, order.field());
                    String dir = order.dir();
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    Collections.sort(list, (o1, o2) -> {
                        try {
                            if (!orderedFields.isEmpty()) {
                                boolean inOrder = false;
                                for (Field orderedField : orderedFields) {
                                    Object val2;
                                    Object val1 = orderedField.get(o1);
                                    if (val1 != (val2 = orderedField.get(o2)) && (val1 == null || val2 == null)) {
                                        inOrder = true;
                                        break;
                                    }
                                    int compare = val1 == null ? 1 : ((Comparable)val1).compareTo(val2);
                                    if (compare == 0) continue;
                                    inOrder = true;
                                    break;
                                }
                                if (inOrder) {
                                    return 0;
                                }
                            }
                            Object val1 = field.get(o1);
                            Object val2 = field.get(o2);
                            if (dir.equalsIgnoreCase("asc")) {
                                if (val1 == null) {
                                    return -1;
                                }
                                if (val2 == null) {
                                    return 1;
                                }
                                return ((Comparable)val1).compareTo(val2);
                            }
                            if (val2 == null) {
                                return -1;
                            }
                            if (val1 == null) {
                                return 1;
                            }
                            return ((Comparable)val2).compareTo(val1);
                        }
                        catch (IllegalAccessException e) {
                            this.logger.error("field " + field.getName() + ", used for sorting, is not accessible");
                            return 0;
                        }
                    });
                    orderedFields.add(field);
                }
                catch (NoSuchFieldException e) {
                    this.logger.warn("couldn't sort by field " + order.field() + ", field does not exist on class " + clazz.getName());
                }
            }
        }
    }

    public void validateModel(SaveContext<T> context) {
        context.fieldMap().forEach(f -> {
            if (context.model().getCheckedFields().contains(f.getName())) {
                return;
            }
            AnnotationDescriptor annotations = Persistence.cache().fieldAnnotations(context.model().getClass(), f.getName());
            if (!context.model().getPersisted() && annotations.required) {
                try {
                    Object value = f.field().get(context.model());
                    if (value == null || value instanceof String && ((String)value).isEmpty()) {
                        throw new MissingRequiredException((Base)context.model(), f.field());
                    }
                }
                catch (IllegalAccessException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            Set violations = this.service().validator().validateProperty(context.model(), f.getName(), new Class[0]);
            for (ConstraintViolation violation : violations) {
                this.logger.error(violation.getPropertyPath().toString() + " " + violation.getMessage());
            }
            if (CollectionUtils.isNotEmpty((Collection)violations)) {
                throw new ConstraintViolationException("violations storing " + context.model(), violations);
            }
        });
    }

    @Override
    public void dispose() {
    }
}

