/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.repository;

import de.whitefrog.frogr.exception.FrogrException;
import de.whitefrog.frogr.exception.PersistException;
import de.whitefrog.frogr.model.Base;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.model.SaveContext;
import de.whitefrog.frogr.model.relationship.BaseRelationship;
import de.whitefrog.frogr.model.rest.FieldList;
import de.whitefrog.frogr.persistence.Persistence;
import de.whitefrog.frogr.persistence.Relationships;
import de.whitefrog.frogr.repository.BaseRepository;
import de.whitefrog.frogr.repository.RelationshipRepository;
import java.lang.reflect.Constructor;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.reflect.ConstructorUtils;
import org.apache.commons.lang3.Validate;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRelationshipRepository<T extends BaseRelationship>
extends BaseRepository<T>
implements RelationshipRepository<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public BaseRelationshipRepository() {
    }

    public BaseRelationshipRepository(String modelName) {
        super(modelName);
    }

    @Override
    public T createModel(Model from, Model to) {
        try {
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(this.getModelClass(), (Class[])new Class[]{from.getClass(), to.getClass()});
            return (T)((BaseRelationship)constructor.newInstance(from, to));
        }
        catch (ReflectiveOperationException e) {
            throw new FrogrException(e.getMessage(), e);
        }
    }

    @Override
    public T createModel(PropertyContainer node, FieldList fields) {
        return (T)((BaseRelationship)this.fetch(Persistence.get(node), false, fields));
    }

    public T find(long id, FieldList fields) {
        try {
            Base model = this.createModel((PropertyContainer)this.graph().getRelationshipById(id), fields);
            if (CollectionUtils.isNotEmpty((Collection)fields)) {
                this.fetch(model, fields);
            }
            return (T)model;
        }
        catch (IllegalStateException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    @Override
    public Relationship getRelationship(de.whitefrog.frogr.model.relationship.Relationship model) {
        Validate.notNull((Object)model, (String)"The model is null", (Object[])new Object[0]);
        Validate.notNull((Object)model.getId(), (String)"ID can not be null.", (Object[])new Object[0]);
        try {
            return this.service().graph().getRelationshipById(model.getId());
        }
        catch (NotFoundException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void remove(T model) throws PersistException {
        Validate.notNull((Object)((BaseRelationship)model).getId(), (String)"'id' is required", (Object[])new Object[0]);
        Relationships.delete(model);
        this.logger.info("{} deleted", model);
    }

    @Override
    public void save(SaveContext<T> context) throws PersistException {
        this.validateModel(context);
        boolean create = !((BaseRelationship)context.model()).getPersisted();
        Relationships.save(context);
        this.logger().info("{} {}", context.model(), (Object)(create ? "created" : "updated"));
    }
}

