/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.repository;

import de.whitefrog.frogr.exception.FrogrException;
import de.whitefrog.frogr.exception.PersistException;
import de.whitefrog.frogr.exception.TypeMismatchException;
import de.whitefrog.frogr.model.Base;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.model.SaveContext;
import de.whitefrog.frogr.model.rest.FieldList;
import de.whitefrog.frogr.persistence.Persistence;
import de.whitefrog.frogr.repository.BaseRepository;
import de.whitefrog.frogr.repository.ModelRepository;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;

public abstract class BaseModelRepository<T extends Model>
extends BaseRepository<T>
implements ModelRepository<T> {
    private final Label label;
    private Set<Label> labels;

    public BaseModelRepository() {
        this.label = Label.label((String)this.getType());
        if (this.getModelClass() != null) {
            this.labels = this.getModelInterfaces(this.getModelClass()).stream().map(Label::label).collect(Collectors.toSet());
        } else {
            this.logger().warn("no model class found for {}", this.getClass());
        }
    }

    public BaseModelRepository(String modelName) {
        super(modelName);
        this.label = Label.label((String)modelName);
        this.labels = this.getModelInterfaces(this.getModelClass()).stream().map(Label::label).collect(Collectors.toSet());
    }

    @Override
    public T createModel() {
        try {
            return (T)((Model)this.getModelClass().newInstance());
        }
        catch (ReflectiveOperationException e) {
            throw new FrogrException(e.getMessage(), e);
        }
    }

    @Override
    public T createModel(PropertyContainer node, FieldList fields) {
        if (node instanceof Node && !this.checkType((Node)node)) {
            throw new TypeMismatchException((Node)node, this.label());
        }
        return (T)((Model)Persistence.get(node, fields));
    }

    boolean checkType(Node node) {
        return node.hasLabel(this.label());
    }

    public T find(long id, FieldList fields) {
        try {
            Base model = this.createModel((PropertyContainer)this.graph().getNodeById(id), fields);
            if (CollectionUtils.isNotEmpty((Collection)fields)) {
                this.fetch(model, fields);
            }
            return (T)model;
        }
        catch (IllegalStateException e) {
            this.logger().warn(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    @Override
    public Node getNode(Model model) {
        Validate.notNull((Object)model, (String)"The model is null", (Object[])new Object[0]);
        Validate.notNull((Object)model.getId(), (String)"ID can not be null.", (Object[])new Object[0]);
        try {
            return this.service().graph().getNodeById(model.getId());
        }
        catch (NotFoundException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public Label label() {
        return this.label;
    }

    @Override
    public Set<Label> labels() {
        return this.labels;
    }

    @Override
    public void remove(T model) throws PersistException {
        Validate.notNull((Object)model.getId(), (String)"'id' is required", (Object[])new Object[0]);
        Persistence.delete(this, model);
        this.logger().info("{} deleted", model);
    }

    @Override
    public void save(SaveContext<T> context) throws PersistException {
        this.validateModel(context);
        boolean create = !((Model)context.model()).getPersisted();
        Persistence.save(this, context);
        this.logger().info("{} {}", context.model(), (Object)(create ? "created" : "updated"));
    }
}

