/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.persistence;

import de.whitefrog.frogr.Service;
import de.whitefrog.frogr.exception.FrogrException;
import de.whitefrog.frogr.exception.PersistException;
import de.whitefrog.frogr.exception.RelatedNotPersistedException;
import de.whitefrog.frogr.exception.RepositoryInstantiationException;
import de.whitefrog.frogr.exception.RepositoryNotFoundException;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.model.SaveContext;
import de.whitefrog.frogr.model.annotation.RelatedTo;
import de.whitefrog.frogr.model.relationship.BaseRelationship;
import de.whitefrog.frogr.model.rest.FieldList;
import de.whitefrog.frogr.model.rest.QueryField;
import de.whitefrog.frogr.persistence.AnnotationDescriptor;
import de.whitefrog.frogr.persistence.FieldDescriptor;
import de.whitefrog.frogr.persistence.Persistence;
import de.whitefrog.frogr.repository.DefaultRelationshipRepository;
import de.whitefrog.frogr.repository.ModelRepository;
import de.whitefrog.frogr.repository.RelationshipRepository;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Relationships {
    private static final Logger logger = LoggerFactory.getLogger(Relationships.class);
    private static Service service;

    public static void setService(Service _service) {
        service = _service;
    }

    private static <T extends Model> BaseRelationship addRelationship(T model, Node node, RelatedTo annotation, Model foreignModel) {
        DefaultRelationshipRepository<BaseRelationship> repository;
        if (foreignModel.getId() == -1L) {
            if (foreignModel.getUuid() != null) {
                foreignModel = (Model)service.repository(foreignModel.getClass()).findByUuid(foreignModel.getUuid(), new String[0]);
            } else {
                throw new RelatedNotPersistedException("the related field " + foreignModel + " is not yet persisted");
            }
        }
        Node foreignNode = Persistence.getNode(foreignModel);
        RelationshipType relationshipType = RelationshipType.withName((String)annotation.type());
        if (!annotation.multiple() && Relationships.hasRelationshipTo(node, foreignNode, relationshipType, annotation.direction())) {
            return (BaseRelationship)Persistence.get((PropertyContainer)Relationships.getRelationshipBetween(node, foreignNode, relationshipType, annotation.direction()));
        }
        try {
            repository = (DefaultRelationshipRepository<BaseRelationship>)service.repository(relationshipType.name());
        }
        catch (RepositoryNotFoundException e) {
            repository = new DefaultRelationshipRepository<BaseRelationship>(relationshipType.name());
            try {
                service.repositoryFactory().setRepositoryService(repository);
                service.repositoryFactory().register(relationshipType.name(), repository);
            }
            catch (ReflectiveOperationException ex) {
                throw new RepositoryInstantiationException(ex.getCause());
            }
        }
        BaseRelationship relationship = annotation.direction() == Direction.OUTGOING ? (BaseRelationship)repository.createModel(model, foreignModel) : (annotation.direction() == Direction.INCOMING ? (BaseRelationship)repository.createModel(foreignModel, model) : (BaseRelationship)repository.createModel(model, foreignModel));
        repository.save(relationship);
        return relationship;
    }

    public static <T extends BaseRelationship> T getRelationshipBetween(Model model, Model other, RelationshipType type, Direction dir) {
        return (T)((BaseRelationship)Persistence.get((PropertyContainer)Relationships.getRelationshipBetween(Persistence.getNode(model), Persistence.getNode(other), type, dir)));
    }

    public static Relationship getRelationshipBetween(Node node, Node other, RelationshipType type, Direction dir) {
        Iterable relationships = node.getRelationships(dir, new RelationshipType[]{type});
        for (Relationship relationship : relationships) {
            if (!relationship.getOtherNode(node).equals(other)) continue;
            return relationship;
        }
        return null;
    }

    static Model getRelatedModel(Model model, RelatedTo annotation, FieldList fields) {
        block3: {
            Validate.notNull((Object)model);
            Validate.notNull((Object)annotation.type());
            try {
                Relationship relationship = Persistence.getNode(model).getSingleRelationship(RelationshipType.withName((String)annotation.type()), annotation.direction());
                if (relationship != null) {
                    Node node = Persistence.getNode(model);
                    Node other = relationship.getOtherNode(node);
                    String type = (String)other.getProperty("type");
                    ModelRepository repository = (ModelRepository)service.repository(type);
                    return (Model)repository.createModel((PropertyContainer)other, fields);
                }
            }
            catch (NotFoundException e) {
                if (!e.getMessage().startsWith("More than")) break block3;
                logger.error(e.getMessage());
                logger.error("Relationships are:");
                Persistence.getNode(model).getRelationships(RelationshipType.withName((String)annotation.type()), annotation.direction()).forEach(rel -> logger.error(rel.toString()));
                throw e;
            }
        }
        return null;
    }

    static <M extends Model> Set<M> getRelatedModels(Model model, FieldDescriptor descriptor, QueryField fieldDescriptor, FieldList fields) {
        RelatedTo annotation = descriptor.annotations().relatedTo;
        Validate.notNull((Object)model);
        Validate.notNull((Object)annotation.type());
        ResourceIterator iterator = (ResourceIterator)Persistence.getNode(model).getRelationships(annotation.direction(), new RelationshipType[]{RelationshipType.withName((String)annotation.type())}).iterator();
        HashSet models = new HashSet();
        Node node = Persistence.getNode(model);
        long count = 0L;
        while (iterator.hasNext()) {
            if (count < (long)fieldDescriptor.skip()) {
                iterator.next();
                ++count;
                continue;
            }
            if (count++ == (long)(fieldDescriptor.skip() + fieldDescriptor.limit())) break;
            Relationship relationship = (Relationship)iterator.next();
            Node other = relationship.getOtherNode(node);
            String type = (String)other.getProperty("type");
            if (annotation.restrictType() && !type.equals(descriptor.baseClass().getSimpleName())) {
                --count;
                continue;
            }
            ModelRepository repository = (ModelRepository)service.repository(type);
            models.add(repository.createModel((PropertyContainer)other, fields));
        }
        iterator.close();
        return models;
    }

    public static <R extends de.whitefrog.frogr.model.relationship.Relationship> Relationship getRelationship(R relationship) {
        if (relationship.getId() > -1L) {
            return service.graph().getRelationshipById(relationship.getId());
        }
        throw new UnsupportedOperationException("cant find relationship without id");
    }

    static <R extends BaseRelationship> R getRelationship(Model model, FieldDescriptor descriptor, FieldList fields) {
        RelatedTo annotation = descriptor.annotations().relatedTo;
        Validate.notNull((Object)model);
        Validate.notNull((Object)annotation.type());
        ResourceIterator iterator = (ResourceIterator)Persistence.getNode(model).getRelationships(annotation.direction(), new RelationshipType[]{RelationshipType.withName((String)annotation.type())}).iterator();
        BaseRelationship relationshipModel = null;
        if (iterator.hasNext()) {
            Relationship relationship = (Relationship)iterator.next();
            relationshipModel = (BaseRelationship)Persistence.get((PropertyContainer)relationship, fields);
        }
        iterator.close();
        return (R)relationshipModel;
    }

    static <R extends BaseRelationship> Set<R> getRelationships(Model model, FieldDescriptor descriptor, QueryField queryField, FieldList fields) {
        RelatedTo annotation = descriptor.annotations().relatedTo;
        Validate.notNull((Object)model);
        Validate.notNull((Object)annotation.type());
        ResourceIterator iterator = (ResourceIterator)Persistence.getNode(model).getRelationships(annotation.direction(), new RelationshipType[]{RelationshipType.withName((String)annotation.type())}).iterator();
        HashSet models = new HashSet();
        long count = 0L;
        while (iterator.hasNext()) {
            if (queryField != null && count < (long)queryField.skip()) {
                iterator.next();
                ++count;
                continue;
            }
            if (queryField != null && count++ == (long)(queryField.skip() + queryField.limit())) break;
            Relationship relationship = (Relationship)iterator.next();
            models.add(Persistence.get((PropertyContainer)relationship, fields));
        }
        iterator.close();
        return models;
    }

    public static boolean hasRelationshipTo(Node node, Node other, RelationshipType type, Direction direction) {
        Iterable relationships = node.getRelationships(direction, new RelationshipType[]{type});
        for (Relationship relationship : relationships) {
            if (!relationship.getOtherNode(node).equals(other)) continue;
            return true;
        }
        return false;
    }

    public static <T extends de.whitefrog.frogr.model.relationship.Relationship> T save(SaveContext<T> context) {
        de.whitefrog.frogr.model.relationship.Relationship model = (de.whitefrog.frogr.model.relationship.Relationship)context.model();
        boolean create = false;
        if (!model.getPersisted()) {
            create = true;
            Node fromNode = Persistence.getNode(model.getFrom());
            Node toNode = Persistence.getNode(model.getTo());
            RelationshipType relType = RelationshipType.withName((String)context.repository().getType());
            Relationship relationship = fromNode.createRelationshipTo(toNode, relType);
            context.setNode((PropertyContainer)relationship);
            model.setId(relationship.getId());
            model.setCreated(System.currentTimeMillis());
            model.setType(model.getClass().getSimpleName());
        } else {
            if (model.getType() == null) {
                model.setType(context.repository().getType());
            }
            model.updateLastModified();
        }
        for (String property : model.getRemoveProperties()) {
            Relationships.removeProperty(model, property);
        }
        for (FieldDescriptor field : context.fieldMap()) {
            Persistence.saveField(context, field, create);
        }
        model.getCheckedFields().clear();
        if (logger.isInfoEnabled()) {
            logger.info("Relationship {}({}, {}) {}", new Object[]{model.getType(), model.getFrom(), model.getTo(), create ? "created" : "updated"});
        }
        return (T)model;
    }

    static <T extends Model> void saveField(SaveContext<T> context, FieldDescriptor descriptor) throws IllegalAccessException {
        AnnotationDescriptor annotations = descriptor.annotations();
        Model model = (Model)context.model();
        Node node = (Node)context.node();
        RelatedTo relatedTo = annotations.relatedTo;
        Object value = descriptor.field().get(model);
        if (!descriptor.isCollection()) {
            Relationship existing = node.getSingleRelationship(RelationshipType.withName((String)relatedTo.type()), relatedTo.direction());
            if (existing != null) {
                existing.delete();
            }
            Model foreignModel = (Model)value;
            Relationships.addRelationship(model, node, relatedTo, foreignModel);
        } else {
            Collection collection = (Collection)value;
            if (!annotations.lazy) {
                RelationshipType relationshipType = RelationshipType.withName((String)relatedTo.type());
                for (Relationship relationship : node.getRelationships(relatedTo.direction(), new RelationshipType[]{relationshipType})) {
                    Object other = Persistence.get((PropertyContainer)relationship.getOtherNode(node));
                    if (collection.contains(other)) continue;
                    relationship.delete();
                    logger.info("relationship between {} and {} removed", (Object)model, other);
                }
            }
            if (descriptor.isModel()) {
                for (Model foreignModel : (Collection)value) {
                    if (foreignModel.getId() == -1L) {
                        if (foreignModel.getUuid() != null) {
                            foreignModel = (Model)service.repository(foreignModel.getClass()).findByUuid(foreignModel.getUuid(), new String[0]);
                        } else {
                            throw new RelatedNotPersistedException("the related field " + foreignModel + " (" + relatedTo.type() + ") is not yet persisted");
                        }
                    }
                    Relationships.addRelationship(model, node, relatedTo, foreignModel);
                }
            } else {
                for (BaseRelationship relModel : (Collection)value) {
                    if (!relModel.getTo().getPersisted()) {
                        throw new RelatedNotPersistedException("the " + relModel.getTo() + " (" + relatedTo.type() + ") is not yet persisted");
                    }
                    RelationshipRepository repository = (RelationshipRepository)service.repository(relModel.getClass());
                    if (relatedTo.direction().equals((Object)Direction.INCOMING)) {
                        if (!relModel.getTo().equals(model)) {
                            throw new PersistException(relModel + " should have " + model + " as 'to' field set");
                        }
                    } else if (relatedTo.direction().equals((Object)Direction.OUTGOING)) {
                        if (!relModel.getFrom().equals(model)) {
                            throw new PersistException(relModel + " should have " + model + " as 'from' field set");
                        }
                    } else if (relatedTo.direction().equals((Object)Direction.BOTH) && !relModel.getFrom().equals(model) && !relModel.getTo().equals(model)) {
                        throw new PersistException(relModel + "should have " + model + " either set as 'from' or 'to' field");
                    }
                    repository.save(relModel);
                }
            }
        }
    }

    public static void removeProperty(de.whitefrog.frogr.model.relationship.Relationship model, String property) {
        Relationship node = Relationships.getRelationship(model);
        node.removeProperty(property);
        try {
            Field field = model.getClass().getDeclaredField(property);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(model, null);
        }
        catch (ReflectiveOperationException e) {
            throw new FrogrException("field " + property + " could not be found on " + model, e);
        }
    }

    public static <R extends BaseRelationship> void delete(R relationship) {
        Relationships.getRelationship(relationship).delete();
        logger.info("relationship {} between {} and {} removed", new Object[]{relationship.type(), relationship.getFrom(), relationship.getTo()});
    }

    public static <T extends Model> void delete(T model, RelationshipType type, Direction direction, Model foreignModel) {
        if (foreignModel.getId() == -1L) {
            if (foreignModel.getUuid() != null) {
                foreignModel = (Model)service.repository(foreignModel.getClass()).findByUuid(foreignModel.getUuid(), new String[0]);
            } else {
                throw new RelatedNotPersistedException("the related field " + foreignModel + " is not yet persisted");
            }
        }
        Node node = Persistence.getNode(model);
        Node foreignNode = Persistence.getNode(foreignModel);
        for (Relationship relationship : node.getRelationships(type, direction)) {
            if (!relationship.getOtherNode(node).equals(foreignNode)) continue;
            relationship.delete();
            logger.info("relationship {} between {} and {} removed", new Object[]{type.name(), model, foreignModel});
        }
    }
}

