/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.persistence;

import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.TimeBasedGenerator;
import de.whitefrog.frogr.Service;
import de.whitefrog.frogr.exception.DuplicateEntryException;
import de.whitefrog.frogr.exception.FrogrException;
import de.whitefrog.frogr.exception.MissingRequiredException;
import de.whitefrog.frogr.exception.PersistException;
import de.whitefrog.frogr.model.Base;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.model.SaveContext;
import de.whitefrog.frogr.model.annotation.RelationshipCount;
import de.whitefrog.frogr.model.relationship.BaseRelationship;
import de.whitefrog.frogr.model.rest.FieldList;
import de.whitefrog.frogr.model.rest.QueryField;
import de.whitefrog.frogr.persistence.AnnotationDescriptor;
import de.whitefrog.frogr.persistence.FieldDescriptor;
import de.whitefrog.frogr.persistence.ModelCache;
import de.whitefrog.frogr.persistence.Relationships;
import de.whitefrog.frogr.repository.ModelRepository;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.reflect.ConstructorUtils;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Persistence {
    private static final Logger logger = LoggerFactory.getLogger(Persistence.class);
    private static Service service;
    private static ModelCache cache;

    public static void setService(Service _service) {
        service = _service;
        cache = new ModelCache(_service.registry());
        Relationships.setService(_service);
    }

    public static ModelCache cache() {
        return cache;
    }

    public static <T extends Model> void delete(ModelRepository<T> repository, T model) {
        Node node = Persistence.getNode(model);
        for (Relationship relationship : node.getRelationships()) {
            relationship.delete();
        }
        node.delete();
    }

    public static <T extends Model> T save(ModelRepository<T> repository, SaveContext<T> context) throws MissingRequiredException {
        Model model = (Model)context.model();
        Label label = repository.label();
        boolean create = false;
        if (!model.getPersisted()) {
            create = true;
            Node node = service.graph().createNode(new Label[]{label});
            context.setNode((PropertyContainer)node);
            repository.labels().stream().filter(l -> !node.hasLabel(l)).forEach(arg_0 -> ((Node)node).addLabel(arg_0));
            model.setId(node.getId());
            model.setCreated(System.currentTimeMillis());
            model.setType(label.name());
        } else {
            if (model.getType() == null) {
                model.setType(label.name());
            }
            model.updateLastModified();
        }
        for (String property : ((Model)context.model()).getRemoveProperties()) {
            Persistence.removeProperty((Model)context.model(), property);
        }
        for (FieldDescriptor field : context.fieldMap()) {
            Persistence.saveField(context, field, create);
        }
        model.getCheckedFields().clear();
        logger.info("{} {}", (Object)model, (Object)(create ? "created" : "updated"));
        return (T)model;
    }

    static <T extends Base> void saveField(SaveContext<T> context, FieldDescriptor descriptor, boolean created) {
        Field field = descriptor.field();
        AnnotationDescriptor annotations = descriptor.annotations();
        T model = context.model();
        Object node = context.node();
        if (node == null) {
            throw new NullPointerException("node can not be null");
        }
        if (field == null) {
            throw new NullPointerException("field can not be null");
        }
        Object value = null;
        try {
            boolean valueChanged;
            value = field.get(model);
            if (created && annotations.required && (value == null || value instanceof String && ((String)value).isEmpty())) {
                throw new MissingRequiredException((Base)model, field);
            }
            boolean bl = valueChanged = created || context.fieldChanged(field.getName());
            if (!annotations.notPersistant && !annotations.blob) {
                if (created && annotations.uuid && field.get(model) == null) {
                    String uuid = Persistence.generateUuid();
                    field.set(model, uuid);
                    value = uuid;
                    valueChanged = true;
                }
                if (value != null) {
                    if (annotations.relatedTo != null && valueChanged && Model.class.isAssignableFrom(context.model().getClass())) {
                        Relationships.saveField(context, descriptor);
                        logger.info("{}: updated relationships for \"{}\"", model, (Object)field.getName());
                    }
                    if (!(value instanceof Collection) && !(value instanceof Model)) {
                        if (value.getClass().isEnum()) {
                            if (!node.hasProperty(field.getName()) || !((Enum)value).name().equals(node.getProperty(field.getName()))) {
                                node.setProperty(field.getName(), (Object)((Enum)value).name());
                                logger.info("{}: set enum value for \"{}\" to \"{}\"", new Object[]{model, field.getName(), ((Enum)value).name()});
                            }
                        } else if (value instanceof Date) {
                            node.setProperty(field.getName(), (Object)((Date)value).getTime());
                            logger.info("{}: set date value for \"{}\" to \"{}\"", new Object[]{model, field.getName(), ((Date)value).getTime()});
                        } else if (valueChanged) {
                            node.setProperty(field.getName(), value);
                            logger.info("{}: set value for \"{}\" to \"{}\"", new Object[]{model, field.getName(), value});
                        }
                    }
                } else if (valueChanged && annotations.nullRemove) {
                    node.removeProperty(field.getName());
                }
            }
        }
        catch (ReflectiveOperationException e) {
            logger.error("Could not get property on {}: {}", new Object[]{model, e.getMessage(), e});
        }
        catch (ConstraintViolationException e) {
            throw new DuplicateEntryException("A " + model.getClass().getSimpleName().toLowerCase() + " with the " + field.getName() + " \"" + value + "\" already exists", (Base)model, field);
        }
        catch (IllegalArgumentException e) {
            logger.error("Could not store property {} on {}: {}", new Object[]{field.getName(), model, e.getMessage()});
        }
    }

    public static <T extends Base> T get(PropertyContainer node) throws PersistException {
        return Persistence.get(node, new FieldList());
    }

    public static <T extends Base> T get(PropertyContainer node, FieldList fields) throws PersistException {
        Validate.notNull((Object)node, (String)"node can't be null");
        try {
            Base model;
            Class clazz = Persistence.getClass(node);
            if (clazz == null) {
                Class clazz2 = clazz = node instanceof Node ? Model.class : BaseRelationship.class;
            }
            if (node instanceof Node) {
                model = (Base)clazz.newInstance();
                model.setId(((Node)node).getId());
            } else {
                Relationship rel = (Relationship)node;
                Model from = (Model)Persistence.get((PropertyContainer)rel.getStartNode());
                if (fields.get("from") != null && fields.get("from").subFields() != null) {
                    Persistence.fetch(from, fields.get("from").subFields());
                }
                Model to = (Model)Persistence.get((PropertyContainer)rel.getEndNode());
                if (fields.get("to") != null && fields.get("to").subFields() != null) {
                    Persistence.fetch(to, fields.get("to").subFields());
                }
                Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)clazz, (Class[])new Class[]{from.getClass(), to.getClass()});
                model = (Base)constructor.newInstance(from, to);
                model.setId(rel.getId());
            }
            model.setId(node instanceof Node ? ((Node)node).getId() : ((Relationship)node).getId());
            service.repository(clazz).fetch((Base)model, false, fields);
            return (T)model;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e instanceof PersistException ? (PersistException)e : new PersistException(e);
        }
    }

    private static Class getClass(PropertyContainer node) throws ClassNotFoundException {
        String className = node instanceof Relationship ? ((Relationship)node).getType().name() : (String)node.getProperty(node.hasProperty(Model.Companion.getModel()) ? "model" : "type");
        return Persistence.cache().getModel(className);
    }

    private static String generateUuid() {
        TimeBasedGenerator uuidGenerator = Generators.timeBasedGenerator();
        UUID uuid = uuidGenerator.generate();
        return Long.toHexString(uuid.getMostSignificantBits()) + Long.toHexString(uuid.getLeastSignificantBits());
    }

    public static void removeProperty(Model model, String property) {
        Node node = Persistence.getNode(model);
        node.removeProperty(property);
        try {
            Field field = model.getClass().getDeclaredField(property);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(model, null);
        }
        catch (ReflectiveOperationException e) {
            throw new FrogrException("field " + property + " could not be found on " + model, e);
        }
    }

    public static Node getNode(Model model) {
        Validate.notNull((Object)model);
        if (model.getId() > -1L) {
            return service.graph().getNodeById(model.getId());
        }
        if (model.getUuid() != null && model.getType() != null) {
            Node node = service.graph().findNode(Label.label((String)model.getType()), "uuid", (Object)model.getUuid());
            model.setId(node.getId());
            return node;
        }
        throw new UnsupportedOperationException("cant get a node without id or uuid");
    }

    public static <T extends Base> void fetch(T model, String ... fields) {
        Persistence.fetch(model, FieldList.parseFields(Arrays.asList(fields)), false);
    }

    public static <T extends Base> void fetch(T model, FieldList fields) {
        Persistence.fetch(model, fields, false);
    }

    public static <T extends Base> void fetch(T model, FieldList fields, boolean refetch) {
        Validate.notNull(model, (String)"model cannot be null");
        if (!model.getPersisted()) {
            return;
        }
        try {
            Node node;
            List<String> ignoredFields = Arrays.asList("id");
            if (model instanceof de.whitefrog.frogr.model.relationship.Relationship) {
                BaseRelationship relModel = (BaseRelationship)model;
                node = Relationships.getRelationship(relModel);
                ignoredFields = Arrays.asList("id", "from", "to");
            } else {
                node = Persistence.getNode((Model)model);
            }
            for (FieldDescriptor descriptor : cache.fieldMap(model.getClass())) {
                boolean fetch;
                if (CollectionUtils.isEmpty((Collection)fields) && descriptor.annotations().notPersistant || ignoredFields.contains(descriptor.field().getName())) continue;
                boolean bl = fetch = descriptor.annotations().fetch || fields.containsField("all") || fields.containsField(descriptor.field().getName());
                if (!fetch) continue;
                Persistence.fetchField((PropertyContainer)node, model, descriptor, fields, refetch);
            }
        }
        catch (ReflectiveOperationException e) {
            logger.error("could not load relations for {}: {}", new Object[]{model, e.getMessage(), e});
        }
    }

    private static <T extends Base> void fetchField(PropertyContainer node, T model, FieldDescriptor descriptor, FieldList fields, boolean refetch) throws ReflectiveOperationException {
        if (!refetch && model.getFetchedFields().contains(descriptor.field().getName())) {
            return;
        }
        AnnotationDescriptor annotations = descriptor.annotations();
        Field field = descriptor.field();
        if (!(field.getName().equals("type") || annotations.fetch || field.getName().equals("uuid") || fields.containsField("all") || fields.containsField(field.getName()))) {
            return;
        }
        field.setAccessible(true);
        if (node instanceof Node && annotations.relationshipCount != null && fields.containsField(field.getName())) {
            RelationshipCount count = annotations.relationshipCount;
            field.set(model, Iterables.count((Iterable)((Node)node).getRelationships(count.direction(), new RelationshipType[]{RelationshipType.withName((String)count.type())})));
        } else if (model instanceof Model && annotations.relatedTo != null) {
            QueryField fieldDescriptor;
            if (!annotations.fetch && !fields.containsField(field.getName())) {
                return;
            }
            FieldList subFields = fields.containsField(field.getName()) ? fields.get(field.getName()).subFields() : new FieldList();
            QueryField queryField = fieldDescriptor = fields.containsField(field.getName()) ? fields.get(field.getName()) : new QueryField(field.getName());
            if (descriptor.isCollection()) {
                Set<Object> related = descriptor.isModel() ? Relationships.getRelatedModels((Model)model, descriptor, fieldDescriptor, subFields) : Relationships.getRelationships((Model)model, descriptor, fieldDescriptor, subFields);
                field.set(model, Set.class.isAssignableFrom(field.getType()) ? related : new ArrayList(related));
            } else {
                Object related = descriptor.isModel() ? Relationships.getRelatedModel((Model)model, annotations.relatedTo, subFields) : Relationships.getRelationship((Model)model, descriptor, subFields);
                field.set(model, related);
            }
        } else if (node.hasProperty(field.getName())) {
            if (Enum.class.isAssignableFrom(field.getType())) {
                field.set(model, Enum.valueOf(field.getType(), (String)node.getProperty(field.getName())));
            } else if (Date.class.isAssignableFrom(field.getType())) {
                field.set(model, new Date((Long)node.getProperty(field.getName())));
            } else {
                field.set(model, node.getProperty(field.getName()));
            }
        }
        model.getFetchedFields().add(field.getName());
    }

    public static <T extends Model> T findByUuid(String label, String uuid) {
        ResourceIterator iterator = service.graph().findNodes(Label.label((String)label), "uuid", (Object)uuid);
        return (T)(iterator.hasNext() ? (Model)Persistence.get((PropertyContainer)iterator.next()) : null);
    }
}

