/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.patch;

import com.github.zafarkhaja.semver.Version;
import de.whitefrog.frogr.Service;
import de.whitefrog.frogr.patch.Patch;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.neo4j.graphdb.Transaction;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Patcher {
    private static final Logger logger = LoggerFactory.getLogger(Patcher.class);

    private static TreeMap<Version, List<Patch>> getPatches(Service service) {
        Reflections reflections = new Reflections(Patch.class.getPackage().getName(), new Scanner[0]);
        Set patchClasses = reflections.getSubTypesOf(Patch.class);
        TreeMap<Version, List<Patch>> patches = new TreeMap<Version, List<Patch>>();
        for (Class patchClass : patchClasses) {
            try {
                Constructor constructor = patchClass.getConstructor(Service.class);
                Patch patch = (Patch)constructor.newInstance(service);
                if (patches.containsKey(patch.getVersion())) {
                    patches.get(patch.getVersion()).add(patch);
                    continue;
                }
                ArrayList<Patch> patchList = new ArrayList<Patch>();
                patchList.add(patch);
                patches.put(patch.getVersion(), patchList);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return patches;
    }

    public static void patch(Service service) {
        String version = service.getManifestVersion();
        if (!version.equals("undefined")) {
            Patcher.patch(service, version);
        }
    }

    private static void patch(Service service, String versionString) {
        Version version = Version.valueOf((String)versionString);
        Transaction tx = service.beginTx();
        Version graphVersion = Version.valueOf((String)service.getVersion());
        logger.info("Graph version is {}", (Object)graphVersion);
        tx.success();
        tx.close();
        if (graphVersion.greaterThan(version)) {
            logger.warn("API version is {}, which is less than the graph version", (Object)version);
            NavigableMap<Version, List<Patch>> patches = Patcher.getPatches(service).subMap(version, false, graphVersion, true);
            if (patches.isEmpty()) {
                logger.warn("Don't worry, no patches necessary");
            } else {
                logger.warn("{} patches found, API update required!!!", (Object)patches.size());
            }
        } else if (!graphVersion.equals((Object)version)) {
            NavigableMap<Version, List<Patch>> patches = Patcher.getPatches(service).subMap(graphVersion, false, version, true);
            if (!patches.isEmpty()) {
                logger.info("Graph version differs ({} -> {})", (Object)graphVersion, (Object)version);
                for (Version patchVersion : patches.keySet()) {
                    logger.info("Applying patches for {}", (Object)patchVersion);
                    List patchList = (List)patches.get(patchVersion);
                    Collections.sort(patchList);
                    for (Patch patch : patchList) {
                        patch.setService(service);
                        try {
                            logger.info("    Applying {}Patch", (Object)patch.getClass().getSimpleName());
                            patch.update();
                        }
                        catch (Exception e) {
                            logger.error("   {}Patch failed: {}", new Object[]{patch.getClass().getSimpleName(), e.getMessage(), e});
                            logger.error("Shutting down!");
                            System.exit(1);
                        }
                    }
                    Transaction updateTx = service.beginTx();
                    Throwable throwable = null;
                    try {
                        logger.info("Patches {} -> {} applied", (Object)graphVersion, (Object)patchVersion);
                        service.setVersion(patchVersion.getNormalVersion());
                        updateTx.success();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (updateTx == null) continue;
                        if (throwable != null) {
                            try {
                                updateTx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        updateTx.close();
                    }
                }
                try (Transaction updateTx = service.beginTx();){
                    service.setVersion(version.getNormalVersion());
                    updateTx.success();
                }
            }
            try (Transaction updateTx = service.beginTx();){
                logger.info("Graph version differs ({} -> {}), no patches available", (Object)graphVersion, (Object)version);
                service.setVersion(version.getNormalVersion());
                updateTx.success();
            }
        }
    }
}

