/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.model.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.whitefrog.frogr.model.rest.FieldList;
import de.whitefrog.frogr.model.rest.Filter;
import de.whitefrog.frogr.model.rest.QueryField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class SearchParameter
implements Serializable {
    public static final int DefaultLimit = 10;
    public static final Locale DefaultLocale = Locale.GERMAN;
    private static final ObjectMapper mapper = new ObjectMapper();
    private String query;
    private Integer limit;
    private Integer page;
    private Integer start;
    private Integer depth;
    private Boolean count;
    private Locale locale;
    private Set<Long> ids = new HashSet<Long>();
    private Set<String> uuids = new HashSet<String>();
    private List<Filter> filters = new ArrayList<Filter>();
    private List<OrderBy> orderBy = new ArrayList<OrderBy>();
    private FieldList fields = new FieldList();
    private List<String> returns = new ArrayList<String>();

    public SearchParameter clone() {
        SearchParameter clone = new SearchParameter();
        clone.page = this.page;
        clone.limit = this.limit;
        clone.start = this.start;
        clone.query = this.query;
        clone.depth = this.depth;
        clone.count = this.count;
        clone.locale = this.locale;
        clone.ids = this.ids;
        clone.uuids = this.uuids;
        clone.filters = this.filters().stream().collect(Collectors.toList());
        clone.orderBy = this.orderBy().stream().collect(Collectors.toList());
        clone.fields = new FieldList();
        clone.returns = this.returns;
        this.fields.forEach(clone.fields::add);
        return clone;
    }

    public SearchParameter() {
    }

    public SearchParameter(int limit) {
        this.limit = limit;
    }

    public SearchParameter(int page, int limit) {
        if (page <= 0) {
            throw new IllegalArgumentException("page cannot be equal or less than 0");
        }
        this.page = page;
        this.limit = limit;
        this.start = (page - 1) * limit;
    }

    public boolean count() {
        return this.count != null && this.count != false;
    }

    public SearchParameter count(boolean count) {
        this.count = count;
        return this;
    }

    public boolean containsFilter(String property) {
        for (Filter filter : this.filters()) {
            if (!filter.getProperty().equals(property)) continue;
            return true;
        }
        return false;
    }

    public boolean containsOrder(String field) {
        for (OrderBy order : this.orderBy()) {
            if (!order.field().equals(field)) continue;
            return true;
        }
        return false;
    }

    public SearchParameter fields(String ... fields) {
        for (String field : fields) {
            this.fields.add(new QueryField(field));
        }
        return this;
    }

    public SearchParameter fields(QueryField ... fields) {
        Collections.addAll(this.fields, fields);
        return this;
    }

    public SearchParameter fields(FieldList fields) {
        this.fields = fields;
        return this;
    }

    public List<String> fields() {
        List fields = this.fields.stream().map(QueryField::field).collect(Collectors.toList());
        return new ArrayList<String>(fields);
    }

    public FieldList fieldList() {
        return this.fields;
    }

    public Integer depth() {
        return this.depth;
    }

    public SearchParameter depth(int depth) {
        this.depth = depth;
        return this;
    }

    public SearchParameter locale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public Locale locale() {
        return this.locale != null ? this.locale : DefaultLocale;
    }

    @JsonProperty(value="q")
    public String query() {
        return this.query;
    }

    @JsonProperty(value="q")
    public SearchParameter query(String query) {
        this.query = query;
        return this;
    }

    @JsonIgnore
    public boolean fetch() {
        return !this.fields().isEmpty();
    }

    public Collection<Filter> filters() {
        return this.filters;
    }

    public Filter getFilter(String property) {
        for (Filter filter : this.filters()) {
            if (!filter.getProperty().equals(property)) continue;
            return filter;
        }
        return null;
    }

    public SearchParameter filter(String property, String value) {
        this.filters.add(new Filter.Equals(property, value));
        return this;
    }

    public SearchParameter filter(Filter filter) {
        this.filters.add(filter);
        return this;
    }

    public SearchParameter removeFilter(String property) {
        Iterator<Filter> iterator = this.filters().iterator();
        while (iterator.hasNext()) {
            Filter filter = iterator.next();
            if (!filter.getProperty().equalsIgnoreCase(property)) continue;
            iterator.remove();
        }
        return this;
    }

    public SearchParameter start(int start) {
        this.start = start;
        if (this.limit != null) {
            this.page = Math.round(start / this.limit) + 1;
        }
        return this;
    }

    public int start() {
        return this.start != null ? this.start : 0;
    }

    @JsonIgnore
    public boolean isFiltered() {
        return !this.filters.isEmpty();
    }

    public SearchParameter idOnly() {
        this.fields("id");
        return this;
    }

    public List<Long> ids() {
        return new ArrayList<Long>(this.ids);
    }

    public SearchParameter ids(Long ... ids) {
        this.ids.addAll(Arrays.asList(ids));
        return this;
    }

    @Deprecated
    public SearchParameter ids(List<Long> ids) {
        this.ids = new HashSet<Long>(ids);
        return this;
    }

    public SearchParameter ids(Set<Long> ids) {
        this.ids = ids;
        return this;
    }

    public List<String> uuids() {
        return new ArrayList<String>(this.uuids);
    }

    public SearchParameter uuids(String ... uuids) {
        this.uuids.addAll(Arrays.asList(uuids));
        return this;
    }

    public SearchParameter uuids(List<String> uuids) {
        this.uuids = new HashSet<String>(uuids);
        return this;
    }

    public SearchParameter uuids(Set<String> uuids) {
        this.uuids = uuids;
        return this;
    }

    public int limit() {
        return this.limit != null ? this.limit : 10;
    }

    public SearchParameter limit(int limit) {
        this.limit = limit;
        if (this.start != null) {
            this.page = Math.round(this.start / limit) + 1;
        }
        return this;
    }

    public int page() {
        return this.page != null ? this.page : 1;
    }

    public SearchParameter page(int page) {
        this.page = page;
        if (this.limit != null) {
            this.start = (page - 1) * this.limit;
        }
        return this;
    }

    public SearchParameter incrementPage() {
        this.page(this.page() + 1);
        return this;
    }

    public List<OrderBy> orderBy() {
        return this.orderBy;
    }

    public SearchParameter orderBy(String field) {
        return this.orderBy(field, SortOrder.ASC);
    }

    public SearchParameter orderBy(String field, SortOrder dir) {
        this.orderBy.add(new OrderBy(field, dir));
        return this;
    }

    @JsonIgnore
    public boolean isOrdered() {
        return !this.orderBy.isEmpty();
    }

    public SearchParameter returns(String ... fields) {
        this.returns.addAll(Arrays.asList(fields));
        return this;
    }

    public List<String> returns() {
        return this.returns;
    }

    public String toString() {
        try {
            return "SearchParameter: " + mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "[could not decode]";
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class OrderBy {
        private String field;
        private String dir = SortOrder.ASC.name();

        public OrderBy() {
        }

        OrderBy(String field, String dir) {
            this.field = field;
            this.dir = dir;
        }

        OrderBy(String field, SortOrder dir) {
            this(field, dir.name());
        }

        public String field() {
            return this.field;
        }

        public String dir() {
            return this.dir;
        }
    }

    public static enum SortOrder {
        ASC,
        DESC;

    }
}

