/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr.model.rest;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.function.Predicate;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Equals.class, name="eq"), @JsonSubTypes.Type(value=NotEquals.class, name="neq"), @JsonSubTypes.Type(value=LessThan.class, name="lt"), @JsonSubTypes.Type(value=GreaterThan.class, name="gt"), @JsonSubTypes.Type(value=Range.class, name="range")})
public interface Filter
extends Predicate<Object> {
    public Object getValue();

    public void setValue(Object var1);

    public String getProperty();

    public void setProperty(String var1);

    public static class Range
    extends Default
    implements Filter,
    Predicate<Object> {
        private boolean including = true;
        private long from;
        private long to;

        public Range() {
        }

        public Range(String property, long from, long to) {
            super(property, from);
            this.from = from;
            this.to = to;
        }

        @Override
        public Long getValue() {
            return this.from;
        }

        @Override
        public void setValue(Object value) {
        }

        public long getFrom() {
            return this.from;
        }

        public void setFrom(long from) {
            this.from = from;
        }

        public long getTo() {
            return this.to;
        }

        public void setTo(long to) {
            this.to = to;
        }

        public boolean isIncluding() {
            return this.including;
        }

        public void setIncluding(boolean value) {
            this.including = value;
        }

        @Override
        public boolean test(Object other) {
            Long otherLong = other instanceof Integer ? new Long(((Integer)other).intValue()) : (Long)other;
            if (this.isIncluding()) {
                return otherLong <= this.getFrom() && otherLong >= this.getTo();
            }
            return otherLong < this.getFrom() && otherLong > this.getTo();
        }
    }

    public static class Contains
    extends Default
    implements Filter,
    Predicate<Object> {
        public Contains() {
        }

        public Contains(String property, String value) {
            super(property, value);
        }

        @Override
        public String getValue() {
            return (String)super.getValue();
        }

        @Override
        public boolean test(Object other) {
            return other instanceof String && ((String)other).contains(this.getValue());
        }
    }

    public static class EndsWith
    extends Default
    implements Filter,
    Predicate<Object> {
        public EndsWith() {
        }

        public EndsWith(String property, String value) {
            super(property, value);
        }

        @Override
        public String getValue() {
            return (String)super.getValue();
        }

        @Override
        public boolean test(Object other) {
            return other instanceof String && ((String)other).endsWith(this.getValue());
        }
    }

    public static class StartsWith
    extends Default
    implements Filter,
    Predicate<Object> {
        public StartsWith() {
        }

        public StartsWith(String property, String value) {
            super(property, value);
        }

        @Override
        public String getValue() {
            return (String)super.getValue();
        }

        @Override
        public boolean test(Object other) {
            return other instanceof String && ((String)other).startsWith(this.getValue());
        }
    }

    public static class LessThan
    extends Default
    implements Filter,
    Predicate<Object> {
        private boolean including = false;

        public LessThan() {
        }

        public LessThan(String property, Object value) {
            super(property, value);
        }

        @Override
        public Long getValue() {
            return (Long)super.getValue();
        }

        public boolean isIncluding() {
            return this.including;
        }

        public void setIncluding(boolean value) {
            this.including = value;
        }

        @Override
        public boolean test(Object other) {
            Long otherLong = other instanceof Integer ? new Long(((Integer)other).intValue()) : (Long)other;
            return this.isIncluding() ? otherLong <= this.getValue() : otherLong < this.getValue();
        }
    }

    public static class GreaterThan
    extends Default
    implements Filter,
    Predicate<Object> {
        private boolean including = false;

        public GreaterThan() {
        }

        public GreaterThan(String property, Object value) {
            super(property, value);
        }

        @Override
        public Long getValue() {
            return (Long)super.getValue();
        }

        public boolean isIncluding() {
            return this.including;
        }

        public void setIncluding(boolean value) {
            this.including = value;
        }

        @Override
        public boolean test(Object other) {
            Long otherLong = other instanceof Integer ? new Long(((Integer)other).intValue()) : (Long)other;
            return this.isIncluding() ? otherLong >= this.getValue() : otherLong > this.getValue();
        }
    }

    public static class NotEquals
    extends Default
    implements Filter,
    Predicate<Object> {
        public NotEquals() {
        }

        public NotEquals(String property, Object value) {
            super(property, value);
        }

        @Override
        public boolean test(Object other) {
            return !other.equals(this.getValue());
        }
    }

    public static class Equals
    extends Default
    implements Filter,
    Predicate<Object> {
        public Equals() {
        }

        public Equals(String property, Object value) {
            super(property, value);
        }

        @Override
        public boolean test(Object other) {
            return other.equals(this.getValue());
        }
    }

    public static abstract class Default
    implements Filter {
        private Object value;
        private String property;

        public Default() {
        }

        public Default(String property, Object value) {
            this.property = property;
            this.value = value;
        }

        @Override
        public String getProperty() {
            return this.property;
        }

        @Override
        public void setProperty(String property) {
            this.property = property;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void setValue(Object value) {
            this.value = value;
        }
    }
}

