/*
 * Decompiled with CFR 0.152.
 */
package de.whitefrog.frogr;

import de.whitefrog.frogr.Application;
import de.whitefrog.frogr.exception.FrogrException;
import de.whitefrog.frogr.model.Base;
import de.whitefrog.frogr.model.Graph;
import de.whitefrog.frogr.model.Model;
import de.whitefrog.frogr.patch.Patcher;
import de.whitefrog.frogr.persistence.AnnotationDescriptor;
import de.whitefrog.frogr.persistence.FieldDescriptor;
import de.whitefrog.frogr.persistence.Persistence;
import de.whitefrog.frogr.repository.GraphRepository;
import de.whitefrog.frogr.repository.ModelRepository;
import de.whitefrog.frogr.repository.Repository;
import de.whitefrog.frogr.repository.RepositoryFactory;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Service
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Service.class);
    private static final String snapshotSuffix = "-SNAPSHOT";
    private static Class mainClass = Application.class;
    private GraphDatabaseService graphDb;
    private String directory;
    private GraphRepository graphRepository;
    private Graph graph;
    private RepositoryFactory repositoryFactory;
    private Set<String> packageRegistry = new HashSet<String>();
    private Validator validator;
    private String neo4jConfig = "config/neo4j.properties";
    private State state = State.Started;

    public Service() {
        Locale.setDefault(Locale.GERMAN);
        this.register("de.whitefrog.frogr.model");
        this.register("de.whitefrog.frogr.repository");
    }

    public Transaction beginTx() {
        return this.graph().beginTx();
    }

    public void connect(String directory) {
        try {
            this.directory = directory;
            GraphDatabaseBuilder builder = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(new File(directory)).loadPropertiesFromURL(new PropertiesConfiguration(this.neo4jConfig).getURL());
            this.graphDb = builder.newGraphDatabase();
            Persistence.setService(this);
            this.repositoryFactory = new RepositoryFactory(this);
            this.graphRepository = new GraphRepository(this);
            try (Transaction tx = this.beginTx();){
                this.graph = this.graphRepository.getGraph();
                String version = this.getManifestVersion();
                if (this.graph == null) {
                    this.graph = this.graphRepository.create();
                    if (!version.equals("undefined")) {
                        this.graph.setVersion(version);
                    }
                    this.graphRepository.save(this.graph);
                    logger.info("--------------------------------------------");
                    logger.info("---   creating fresh database instance   ---");
                    logger.info("---   " + directory + "   ---");
                    logger.info("--------------------------------------------");
                } else {
                    if (!version.equals("undefined")) {
                        this.graph.setVersion(version);
                        this.graphRepository.save(this.graph);
                    }
                    logger.info("--------------------------------------------");
                    logger.info("---   starting database instance {}   ---", (Object)(this.graph.getVersion() != null ? this.graph.getVersion() : ""));
                    logger.info("---   {}   ---", (Object)directory);
                    logger.info("--------------------------------------------");
                }
                tx.success();
            }
            Patcher.patch(this);
            this.initializeSchema();
            Service.registerShutdownHook(this);
            this.state = State.Running;
        }
        catch (ConfigurationException e) {
            logger.error("Could not read cypher.properties", (Throwable)e);
        }
    }

    public void connect() {
        try {
            if (this.directory == null) {
                PropertiesConfiguration properties = new PropertiesConfiguration("config/neo4j.properties");
                this.directory = properties.getString("graph.location");
            }
            this.connect(this.directory);
        }
        catch (ConfigurationException e) {
            logger.error("Could not read neo4j.properties", (Throwable)e);
        }
    }

    public boolean isConnected() {
        return this.state.equals((Object)State.Running);
    }

    public String directory() {
        return this.directory;
    }

    public void setConfig(String configFile) {
        this.neo4jConfig = configFile;
    }

    public String getVersion() {
        return this.graph != null ? this.graph.getVersion() : null;
    }

    public void setVersion(String version) {
        try (Transaction tx = this.beginTx();){
            this.graph.setVersion(version);
            this.graphRepository.save(this.graph);
            tx.success();
        }
    }

    public State getState() {
        return this.state;
    }

    public Set<String> registry() {
        return this.packageRegistry;
    }

    public void register(String name) {
        this.packageRegistry.add(name);
    }

    private static void registerShutdownHook(Service service) {
        Runtime.getRuntime().addShutdownHook(new Thread(service::shutdown));
    }

    public <R extends Repository<T>, T extends Base> R repository(Class<T> clazz) {
        return (R)this.repositoryFactory().get(clazz);
    }

    public <R extends Repository> R repository(String name) {
        return (R)this.repositoryFactory().get(name);
    }

    public RepositoryFactory repositoryFactory() {
        return this.repositoryFactory;
    }

    public GraphDatabaseService graph() {
        if (this.graphDb == null) {
            this.connect();
        }
        return this.graphDb;
    }

    public synchronized String getManifestVersion() {
        String version = null;
        if (mainClass != null) {
            version = mainClass.getPackage().getImplementationVersion();
        }
        if (version == null) {
            version = System.getProperty("version", "undefined");
        }
        if (version.endsWith(snapshotSuffix)) {
            version = version.replace(snapshotSuffix, "");
        }
        return version;
    }

    public static void setMainClass(Class clazz) {
        mainClass = clazz;
    }

    public static Class getMainClass() {
        return mainClass;
    }

    private void initializeSchema() {
        try (Transaction tx = this.beginTx();){
            Schema schema = this.graph().schema();
            for (Class modelClass : Persistence.cache().getAllModels()) {
                if (!Model.class.isAssignableFrom(modelClass) || Modifier.isAbstract(modelClass.getModifiers())) continue;
                if (!Base.class.isAssignableFrom(modelClass)) {
                    throw new FrogrException("model class " + modelClass.getName() + " is not of type Base");
                }
                ModelRepository repository = (ModelRepository)this.repository(modelClass);
                List constraints = Iterables.asList((Iterable)schema.getConstraints(repository.label()));
                List indices = Iterables.asList((Iterable)schema.getIndexes(repository.label()));
                for (FieldDescriptor descriptor : Persistence.cache().fieldMap(modelClass)) {
                    AnnotationDescriptor annotations = descriptor.annotations();
                    ConstraintDefinition existing = null;
                    for (ConstraintDefinition constraint : constraints) {
                        String property = (String)Iterables.single((Iterable)constraint.getPropertyKeys());
                        if (!property.equals(descriptor.getName())) continue;
                        existing = constraint;
                        break;
                    }
                    IndexDefinition existingIndex = null;
                    for (IndexDefinition index : indices) {
                        String property = (String)Iterables.single((Iterable)index.getPropertyKeys());
                        if (!property.equals(descriptor.getName())) continue;
                        existingIndex = index;
                        break;
                    }
                    if (annotations.unique && existing == null) {
                        schema.constraintFor(repository.label()).assertPropertyIsUnique(descriptor.getName()).create();
                        logger.info("created unique constraint on field \"{}\" for model \"{}\"", (Object)descriptor.getName(), (Object)repository.getModelClass().getSimpleName());
                    } else if (!annotations.unique && existing != null) {
                        existing.drop();
                        logger.info("dropped unique constraint on field \"{}\" for model \"{}\"", (Object)descriptor.getName(), (Object)repository.getModelClass().getSimpleName());
                    }
                    if (annotations.indexed != null && !annotations.unique && existingIndex == null) {
                        schema.indexFor(repository.label()).on(descriptor.getName()).create();
                        logger.info("created index on field \"{}\" for model \"{}\"", (Object)descriptor.getName(), (Object)repository.getModelClass().getSimpleName());
                        continue;
                    }
                    if (annotations.indexed != null || annotations.unique || existingIndex == null) continue;
                    existingIndex.drop();
                    logger.info("dropped index on field \"{}\" for model \"{}\"", (Object)descriptor.getName(), (Object)repository.getModelClass().getSimpleName());
                }
            }
            tx.success();
        }
    }

    public Validator validator() {
        if (this.validator == null) {
            this.validator = Validation.buildDefaultValidatorFactory().getValidator();
        }
        return this.validator;
    }

    @Override
    public void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.state = State.ShuttingDown;
        this.repositoryFactory().cache().forEach(Repository::dispose);
        if (this.graphDb != null) {
            this.graphDb.shutdown();
        }
    }

    public static enum State {
        Started,
        Running,
        ShuttingDown;

    }
}

