/*
 * Decompiled with CFR 0.152.
 */
package de.whisperedshouts.plugins.iiqentities;

import de.whisperedshouts.plugins.iiqentities.IIQHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class GenerateIIQEntityMojo
extends AbstractMojo {
    private File outputDirectory;
    private String xmlEntityFile;
    private File tokenFile;
    private File entityFolder;
    private boolean createImportCommandXml;

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)String.format("Value of Property %s : %s", "outputDirectory", this.outputDirectory));
        this.getLog().debug((CharSequence)String.format("Value of Property %s : %s", "xmlEntityFile", this.xmlEntityFile));
        this.getLog().debug((CharSequence)String.format("Value of Property %s : %s", "tokenFile", this.tokenFile));
        this.getLog().debug((CharSequence)String.format("Value of Property %s : %s", "entityFolder", this.entityFolder));
        this.getLog().debug((CharSequence)String.format("Value of Property %s : %s", "createImportCommandXml", this.createImportCommandXml));
        if (!this.outputDirectory.exists()) {
            this.getLog().debug((CharSequence)("created output directory " + this.outputDirectory));
            this.outputDirectory.mkdirs();
        }
        if (this.tokenFile == null || !this.tokenFile.exists()) {
            try {
                this.tokenFile = File.createTempFile("iiq", "token");
                this.tokenFile.deleteOnExit();
                this.getLog().info((CharSequence)String.format("Created %s as a temporary file", this.tokenFile.getAbsolutePath()));
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
        }
        ArrayList<File> fileList = null;
        if (!this.entityFolder.exists()) {
            throw new MojoExecutionException("entity Folder does not exist!");
        }
        fileList = new ArrayList<File>();
        this.getLog().debug((CharSequence)("traversing directory " + this.entityFolder));
        IIQHelper.traverseDirectory(this.entityFolder, "xml", fileList);
        try {
            this.getLog().info((CharSequence)("generating deployment XML: " + this.xmlEntityFile));
            File f = new File(String.format("%s%s%s", this.outputDirectory.getAbsolutePath(), System.getProperty("file.separator"), this.xmlEntityFile));
            this.getLog().info((CharSequence)("Full Path: " + f.getAbsolutePath()));
            IIQHelper.createDeploymentXml(f, fileList, IIQHelper.createTokenMap(this.tokenFile), this.createImportCommandXml);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }
}

