/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.changesets;

import de.westnordost.osmapi.map.data.BoundingBox;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class QueryChangesetsFilters {
    private static final String CHARSET = "UTF-8";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_INSTANT;
    private Map<String, String> params = new HashMap<String, String>();

    public QueryChangesetsFilters byUser(String displayName) {
        if (this.params.containsKey("user")) {
            throw new IllegalArgumentException("already provided a user ID");
        }
        try {
            this.params.put("display_name", URLEncoder.encode(displayName, CHARSET));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this;
    }

    public QueryChangesetsFilters byUser(long userId) {
        if (this.params.containsKey("display_name")) {
            throw new IllegalArgumentException("already provided a user name");
        }
        this.params.put("user", String.valueOf(userId));
        return this;
    }

    public QueryChangesetsFilters byBounds(BoundingBox bounds) {
        if (bounds.crosses180thMeridian()) {
            throw new IllegalArgumentException("The bounds must not cross the 180th meridian");
        }
        this.params.put("bbox", bounds.getAsLeftBottomRightTopString());
        return this;
    }

    public QueryChangesetsFilters onlyClosed() {
        this.params.put("closed", "true");
        return this;
    }

    public QueryChangesetsFilters onlyOpen() {
        this.params.put("open", "true");
        return this;
    }

    public QueryChangesetsFilters byChangesets(Collection<Long> changesetIds) {
        long[] changesetIdArray = new long[changesetIds.size()];
        int i = 0;
        for (Long id : changesetIds) {
            changesetIdArray[i++] = id;
        }
        return this.byChangesets(changesetIdArray);
    }

    public QueryChangesetsFilters byChangesets(long ... changesetIds) {
        if (changesetIds.length == 0) {
            throw new IllegalArgumentException("Must at least supply one changeset id");
        }
        StringBuilder cids = new StringBuilder();
        for (int i = 0; i < changesetIds.length; ++i) {
            if (i > 0) {
                cids.append(",");
            }
            cids.append(changesetIds[i]);
        }
        this.params.put("changesets", cids.toString());
        return this;
    }

    public QueryChangesetsFilters byClosedAfter(Instant closedAfter) {
        this.params.put("time", FORMATTER.format(closedAfter));
        return this;
    }

    public QueryChangesetsFilters byOpenSomeTimeBetween(Instant createdBefore, Instant closedAfter) {
        this.params.put("time", FORMATTER.format(closedAfter) + "," + FORMATTER.format(createdBefore));
        return this;
    }

    public String toParamString() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(entry.getKey());
            result.append("=");
            result.append(entry.getValue());
        }
        return result.toString();
    }
}

