/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.changesets;

import de.westnordost.osmapi.ApiResponseReader;
import de.westnordost.osmapi.OsmConnection;
import de.westnordost.osmapi.changesets.ChangesetInfo;
import de.westnordost.osmapi.changesets.ChangesetParser;
import de.westnordost.osmapi.changesets.QueryChangesetsFilters;
import de.westnordost.osmapi.common.Handler;
import de.westnordost.osmapi.common.SingleElementHandler;
import de.westnordost.osmapi.common.errors.OsmConflictException;
import de.westnordost.osmapi.common.errors.OsmNotFoundException;
import de.westnordost.osmapi.map.MapDataFactory;
import de.westnordost.osmapi.map.OsmMapDataFactory;
import de.westnordost.osmapi.map.changes.MapDataChangesHandler;
import de.westnordost.osmapi.map.changes.MapDataChangesParser;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class ChangesetsApi {
    private static final String CHANGESET = "changeset";
    private final OsmConnection osm;

    public ChangesetsApi(OsmConnection osm) {
        this.osm = osm;
    }

    public ChangesetInfo get(long id) {
        SingleElementHandler handler = new SingleElementHandler();
        String query = "changeset/" + id + "?include_discussion=true";
        try {
            boolean authenticate = this.osm.getOAuth() != null;
            this.osm.makeRequest(query, authenticate, (ApiResponseReader)new ChangesetParser((Handler<ChangesetInfo>)handler));
        }
        catch (OsmNotFoundException e) {
            return null;
        }
        return (ChangesetInfo)handler.get();
    }

    public void find(Handler<ChangesetInfo> handler, QueryChangesetsFilters filters) {
        String query = filters != null ? "?" + filters.toParamString() : "";
        try {
            boolean authenticate = this.osm.getOAuth() != null;
            this.osm.makeRequest("changesets" + query, authenticate, (ApiResponseReader)new ChangesetParser(handler));
        }
        catch (OsmNotFoundException osmNotFoundException) {
            // empty catch block
        }
    }

    public ChangesetInfo comment(long id, String text) {
        if (text.isEmpty()) {
            throw new IllegalArgumentException("Text must not be empty");
        }
        SingleElementHandler handler = new SingleElementHandler();
        String apiCall = "changeset/" + id + "/comment?text=" + this.urlEncodeText(text);
        this.osm.makeAuthenticatedRequest(apiCall, "POST", (ApiResponseReader)new ChangesetParser((Handler<ChangesetInfo>)handler));
        return (ChangesetInfo)handler.get();
    }

    private String urlEncodeText(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public ChangesetInfo subscribe(long id) {
        ChangesetInfo result;
        SingleElementHandler handler = new SingleElementHandler();
        try {
            String apiCall = "changeset/" + id + "/subscribe";
            this.osm.makeAuthenticatedRequest(apiCall, "POST", (ApiResponseReader)new ChangesetParser((Handler<ChangesetInfo>)handler));
            result = (ChangesetInfo)handler.get();
        }
        catch (OsmConflictException ignore) {
            result = this.get(id);
        }
        return result;
    }

    public ChangesetInfo unsubscribe(long id) {
        ChangesetInfo result;
        block2: {
            SingleElementHandler handler = new SingleElementHandler();
            try {
                String apiCall = "changeset/" + id + "/unsubscribe";
                this.osm.makeAuthenticatedRequest(apiCall, "POST", (ApiResponseReader)new ChangesetParser((Handler<ChangesetInfo>)handler));
                result = (ChangesetInfo)handler.get();
            }
            catch (OsmNotFoundException e) {
                result = this.get(id);
                if (result != null) break block2;
                throw e;
            }
        }
        return result;
    }

    public void getData(long id, MapDataChangesHandler handler) {
        this.getData(id, handler, (MapDataFactory)new OsmMapDataFactory());
    }

    public void getData(long id, MapDataChangesHandler handler, MapDataFactory factory) {
        boolean authenticate = this.osm.getOAuth() != null;
        this.osm.makeRequest("changeset/" + id + "/download", authenticate, (ApiResponseReader)new MapDataChangesParser(handler, factory));
    }
}

