/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.changesets;

import de.westnordost.osmapi.ApiResponseReader;
import de.westnordost.osmapi.changesets.ChangesetInfo;
import de.westnordost.osmapi.changesets.ChangesetNote;
import de.westnordost.osmapi.common.Handler;
import de.westnordost.osmapi.common.XmlParser;
import de.westnordost.osmapi.map.data.BoundingBox;
import de.westnordost.osmapi.map.data.LatLon;
import de.westnordost.osmapi.map.data.OsmLatLon;
import de.westnordost.osmapi.user.User;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChangesetParser
extends XmlParser
implements ApiResponseReader<Void> {
    private static final String TAG = "tag";
    private static final String CHANGESET = "changeset";
    private static final String COMMENT = "comment";
    private static final String TEXT = "text";
    private Map<Long, User> users;
    private final Handler<ChangesetInfo> handler;
    private ChangesetInfo currentChangesetInfo;
    private ChangesetNote currentComment;
    private List<ChangesetNote> comments;
    private Map<String, String> tags;

    public ChangesetParser(Handler<ChangesetInfo> handler) {
        this.handler = handler;
    }

    public Void parse(InputStream in) throws IOException {
        this.users = new HashMap<Long, User>();
        this.doParse(in);
        this.users = null;
        return null;
    }

    protected void onStartElement() throws ParseException {
        String name = this.getName();
        if (CHANGESET.equals(name)) {
            this.currentChangesetInfo = this.parseChangeset();
        } else if (TAG.equals(name)) {
            if (this.tags == null) {
                this.tags = new HashMap<String, String>();
            }
            this.tags.put(this.getAttribute("k"), this.getAttribute("v"));
        } else if (COMMENT.equals(name)) {
            this.currentComment = this.parseChangesetComment();
        }
    }

    private ChangesetInfo parseChangeset() throws ParseException {
        User user;
        BoundingBox bounds = null;
        if (this.getAttribute("min_lat") != null) {
            bounds = new BoundingBox((LatLon)OsmLatLon.parseLatLon((String)this.getAttribute("min_lat"), (String)this.getAttribute("min_lon")), (LatLon)OsmLatLon.parseLatLon((String)this.getAttribute("max_lat"), (String)this.getAttribute("max_lon")));
        }
        String closedAtStr = this.getAttribute("closed_at");
        Instant closedAt = null;
        if (closedAtStr != null) {
            closedAt = Instant.parse(closedAtStr);
        }
        if ((user = this.parseUser()) == null) {
            throw new NullPointerException();
        }
        ChangesetInfo result = new ChangesetInfo();
        result.id = this.getLongAttribute("id");
        result.createdAt = Instant.parse(this.getAttribute("created_at"));
        result.closedAt = closedAt;
        result.user = user;
        result.boundingBox = bounds;
        result.isOpen = this.getBooleanAttribute("open");
        result.notesCount = this.getIntAttribute("comments_count");
        result.changesCount = this.getIntAttribute("changes_count");
        return result;
    }

    private ChangesetNote parseChangesetComment() throws ParseException {
        ChangesetNote comment = new ChangesetNote();
        comment.user = this.parseUser();
        comment.createdAt = Instant.parse(this.getAttribute("date"));
        return comment;
    }

    private User parseUser() {
        Long userId = this.getLongAttribute("uid");
        if (userId == null) {
            return null;
        }
        if (!this.users.containsKey(userId)) {
            User user = new User(userId.longValue(), this.getAttribute("user"));
            this.users.put(userId, user);
            return user;
        }
        return this.users.get(userId);
    }

    protected void onEndElement() {
        String name = this.getName();
        if (TEXT.equals(name)) {
            this.currentComment.text = this.getText();
        }
        if (COMMENT.equals(name)) {
            if (this.comments == null) {
                this.comments = new ArrayList<ChangesetNote>();
            }
            this.comments.add(this.currentComment);
            this.currentComment = null;
        } else if (CHANGESET.equals(name)) {
            this.currentChangesetInfo.tags = this.tags;
            this.currentChangesetInfo.discussion = this.comments;
            this.handler.handle((Object)this.currentChangesetInfo);
            this.currentChangesetInfo = null;
            this.tags = null;
            this.comments = null;
        }
    }
}

