/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.countryboundaries;

import de.westnordost.countryboundaries.CountryAreas;
import de.westnordost.countryboundaries.Fixed1E7;
import de.westnordost.countryboundaries.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class CountryBoundariesCell {
    private final Collection<String> containingIds;
    private final Collection<CountryAreas> intersectingCountries;

    CountryBoundariesCell(Collection<String> containingIds, Collection<CountryAreas> intersectingCountries) {
        this.containingIds = containingIds;
        this.intersectingCountries = intersectingCountries;
    }

    List<String> getIds(double longitude, double latitude) {
        ArrayList<String> result = new ArrayList<String>(this.containingIds.size());
        result.addAll(this.containingIds);
        if (!this.intersectingCountries.isEmpty()) {
            Point point = new Point(Fixed1E7.doubleToFixed(longitude), Fixed1E7.doubleToFixed(latitude));
            for (CountryAreas areas : this.intersectingCountries) {
                if (!areas.covers(point)) continue;
                result.add(areas.id);
            }
        }
        return result;
    }

    Collection<String> getAllIds() {
        ArrayList<String> result = new ArrayList<String>(this.containingIds.size() + this.intersectingCountries.size());
        result.addAll(this.containingIds);
        for (CountryAreas areas : this.intersectingCountries) {
            result.add(areas.id);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountryBoundariesCell that = (CountryBoundariesCell)o;
        return this.containingIds.equals(that.containingIds) && this.intersectingCountries.equals(that.intersectingCountries);
    }

    public int hashCode() {
        return 31 * this.containingIds.hashCode() + this.intersectingCountries.hashCode();
    }

    public String toString() {
        return Arrays.toString(this.containingIds.toArray()) + " " + Arrays.toString(this.intersectingCountries.toArray());
    }

    void write(ObjectOutputStream out) throws IOException {
        out.writeInt(this.containingIds.size());
        for (String id : this.containingIds) {
            out.writeUTF(id);
        }
        out.writeInt(this.intersectingCountries.size());
        for (CountryAreas areas : this.intersectingCountries) {
            areas.write(out);
        }
    }

    static CountryBoundariesCell read(ObjectInputStream in) throws IOException {
        int intersectingPolygonsSize;
        List<String> containingIds = Collections.emptyList();
        List<CountryAreas> intersectingCountries = Collections.emptyList();
        int containingIdsSize = in.readInt();
        if (containingIdsSize > 0) {
            containingIds = new ArrayList(containingIdsSize);
            for (int i = 0; i < containingIdsSize; ++i) {
                containingIds.add(in.readUTF().intern());
            }
        }
        if ((intersectingPolygonsSize = in.readInt()) > 0) {
            intersectingCountries = new ArrayList(intersectingPolygonsSize);
            for (int i = 0; i < intersectingPolygonsSize; ++i) {
                intersectingCountries.add(CountryAreas.read(in));
            }
        }
        return new CountryBoundariesCell(containingIds, intersectingCountries);
    }
}

