/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.twrente;

import de.wenzlaff.kalender.logic.Kalender;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class GenerateEventAction
implements ActionListener {
    private static final String ZEITFORMAT = "dd.MM.yyyy";
    private final JTextField dateField;
    private final JTextField dateFieldVon;
    private final JFrame frame;
    private final JTextField summaryField;
    private final List<String> selectedDays;
    private final ResourceBundle bundle;

    public GenerateEventAction(JTextField dateField, JTextField dateFieldVon, JFrame frame, JTextField summaryField, List<String> selectedDays, ResourceBundle bundle) {
        this.dateField = dateField;
        this.dateFieldVon = dateFieldVon;
        this.frame = frame;
        this.summaryField = summaryField;
        this.selectedDays = selectedDays;
        this.bundle = bundle;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String inputDate = this.dateField.getText();
        String summaryText = this.summaryField.getText();
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(ZEITFORMAT);
            LocalDate targetDate = LocalDate.parse(inputDate, formatter);
            String vonDate = this.dateFieldVon.getText();
            LocalDate fromDate = LocalDate.parse(vonDate, formatter);
            if (!targetDate.isAfter(fromDate)) {
                JOptionPane.showMessageDialog(this.frame, this.getFromBundle("dialog.error.futureDate"), "Fehler", 0);
                return;
            }
            JFileChooser fileChooser = this.getSaveDialog();
            int userSelection = fileChooser.showSaveDialog(this.frame);
            File selectedFile = null;
            if (userSelection == 0) {
                selectedFile = fileChooser.getSelectedFile();
            } else if (userSelection == 1) {
                JOptionPane.showMessageDialog(this.frame, this.getFromBundle("dialog.info.cancel"), this.getFromBundle("filechooser.info"), 1);
                return;
            }
            Kalender.generateICSFile(selectedFile, targetDate, fromDate, summaryText, this.selectedDays);
            String message = MessageFormat.format(this.getFromBundle("dialog.success"), selectedFile);
            JOptionPane.showMessageDialog(this.frame, message, this.getFromBundle("filechooser.ok"), 1);
        }
        catch (Exception ex) {
            String errorMessage = MessageFormat.format(this.getFromBundle("dialog.error.invalidDate"), ZEITFORMAT);
            JOptionPane.showMessageDialog(this.frame, errorMessage, this.getFromBundle("filechooser.error"), 0);
        }
    }

    private JFileChooser getSaveDialog() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(this.getFromBundle("filechooser.title"));
        FileNameExtensionFilter filter = new FileNameExtensionFilter(this.getFromBundle("filechooser.filter"), "ics", "ical");
        fileChooser.setFileFilter(filter);
        fileChooser.setCurrentDirectory(new File("."));
        fileChooser.setSelectedFile(new File("calendar.ics"));
        return fileChooser;
    }

    private String getFromBundle(String key) {
        try {
            return this.bundle.getString(key);
        }
        catch (Exception e) {
            return "Missing key: " + key;
        }
    }
}

